<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\UserTable;
use CBLib\Language\CBTxt;
use CB\Plugin\Activity\CBActivity;
use CB\Plugin\Activity\Table\ActivityTable;
use CB\Plugin\Activity\Table\NotificationTable;
use CB\Plugin\Activity\Table\CommentTable;
use CB\Plugin\Activity\Activity;
use CB\Plugin\Activity\Notifications;
use CB\Plugin\Activity\Comments;
use CBLib\Registry\ParamsInterface;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var ActivityTable|CommentTable|NotificationTable $row
 * @var UserTable                                    $viewer
 * @var Activity|Comments|Notifications              $stream
 * @var CBplug_cbactivity                            $this
 * @var string                                       $output
 */

global $_PLUGINS;

$links		=	$row->attachments();

$_PLUGINS->trigger( 'activity_onDisplayStreamAttachments', array( &$row, &$links, $viewer, $stream, $output ) );

$count		=	$links->count();

if ( ! $count ) {
	return;
}

$cbUser		=	CBuser::getInstance( $row->getInt( 'user_id', 0 ), false );
?>
<?php if ( $count > 1 ) { ?>
<div class="row no-gutters streamItemScroll">
	<div class="d-flex flex-column justify-content-center pr-2 streamItemScrollLeft">
		<span class="fa fa-chevron-left streamItemScrollLeftIcon"></span>
	</div>
<?php } ?>
	<?php
	foreach ( $links as $i => $link ) {
		/** @var ParamsInterface $link */
		$type		=	$link->getString( 'type', 'url' );
		$external	=	( ( ! $link->getBool( 'internal', false ) ) || ( $type === 'image' ) ? ' target="_blank" rel="nofollow noopener"' : null );
	?>
	<div class="<?php echo ( $type === 'url' ? 'bg-light border p-2 ' : null ) . ( $count > 1 ? 'col streamItemScrollContent ' : null ); ?>streamItemAttachment<?php echo ( $i !== 0 ? ' hidden' : null ); ?>">
		<div class="<?php echo ( $type === 'url' ? 'd-block d-sm-flex media streamMedia ' : ( ( ! in_array( $type, array( 'image', 'file' ), true ) ) || $link->getString( 'title' ) || $link->getString( 'description' ) ? 'card rounded-0 streamPanel ' : null ) ); ?>streamItemAttachmentInner">
			<?php
			if ( $link->getRaw( 'media' ) !== false ) {
				/** @var ParamsInterface $media */
				$media	=	$link->subTree( 'media' );
			?>
			<div class="<?php echo ( $type === 'url' ? 'mb-2 mb-sm-0 pr-sm-2 media-left w-sm-100 mw-50 mw-sm-100 streamMediaLeft ' : ( ( ! in_array( $type, array( 'image', 'file' ), true ) ) || $link->getString( 'title' ) || $link->getString( 'description' ) ? ( $type === 'video' ? 'p-0 ' : 'p-2 ' ) . 'card-body streamPanelBody ' : null ) ); ?>streamItemAttachmentMedia">
			<?php
			switch ( $type ) {
				case 'custom':
					echo $cbUser->replaceUserVars( $media->getRaw( 'custom' ), false, false, null, false );
					break;
				case 'video':
					require CBActivity::getTemplate( $stream->getString( 'template' ), 'attachments/video', false );
					break;
				case 'audio':
					require CBActivity::getTemplate( $stream->getString( 'template' ), 'attachments/audio', false );
					break;
				case 'image':
					require CBActivity::getTemplate( $stream->getString( 'template' ), 'attachments/image', false );
					break;
				case 'file':
					require CBActivity::getTemplate( $stream->getString( 'template' ), 'attachments/file', false );
					break;
				case 'url':
				default:
					require CBActivity::getTemplate( $stream->getString( 'template' ), 'attachments/url', false );
					break;
			}
			?>
			</div>
			<?php } ?>
			<?php if ( $type !== 'custom' ) { ?>
				<?php if ( $link->getString( 'title' ) || $link->getString( 'description' ) ) { ?>
				<div class="<?php echo ( $type === 'url' ? 'media-body streamMediaBody' : 'card-footer p-2 streamPanelFooter' ); ?> streamItemAttachmentInfo">
					<div class="cbMoreLess">
						<div class="cbMoreLessContent">
							<?php if ( $link->getString( 'title' ) ) { ?>
							<div><strong><a href="<?php echo htmlspecialchars( $link->getString( 'url' ) ); ?>"<?php echo $external; ?>><?php echo htmlspecialchars( $link->getString( 'title' ) ); ?></a></strong></div>
							<?php } ?>
							<?php echo htmlspecialchars( $link->getString( 'description' ) ); ?>
						</div>
						<div class="fade-edge cbMoreLessOpen hidden">
							<a href="javascript: void(0);" class="cbMoreLessButton"><?php echo CBTxt::T( 'See More' ); ?></a>
						</div>
					</div>
					<div class="text-small streamItemAttachmentUrl">
						<?php if ( ( ! $link->getString( 'title' ) ) && ( ! in_array( $type, array( 'image', 'file' ), true ) ) ) { ?>
						<div class="text-wrap"><strong><a href="<?php echo htmlspecialchars( $link->getString( 'url' ) ); ?>"<?php echo $external; ?>><?php echo htmlspecialchars( $link->getString( 'url' ) ); ?></a></strong></div>
						<?php } ?>
						<?php if ( $count > 1 ) { ?>
						<div class="text-muted text-right streamItemAttachmentCount"><?php echo ( $i + 1 ); ?> - <?php echo $count; ?></div>
						<?php } ?>
					</div>
				</div>
				<?php } elseif ( ( ! in_array( $type, array( 'image', 'file' ), true ) ) || ( in_array( $type, array( 'image', 'file' ), true ) && ( $count > 1 ) ) ) { ?>
				<div class="<?php echo ( $type === 'url' ? 'media-body streamMediaBody ' : ( ! in_array( $type, array( 'image', 'file' ), true ) ? 'card-footer p-2 streamPanelFooter ' : null ) ); ?>streamItemAttachmentInfo">
					<div class="text-small streamItemAttachmentUrl">
						<?php if ( ! in_array( $type, array( 'image', 'file' ), true ) ) { ?>
						<div class="text-wrap"><strong><a href="<?php echo htmlspecialchars( $link->getString( 'url' ) ); ?>"<?php echo $external; ?>><?php echo htmlspecialchars( $link->getString( 'url' ) ); ?></a></strong></div>
						<?php } ?>
						<?php if ( $count > 1 ) { ?>
						<div class="text-muted text-right streamItemAttachmentCount"><?php echo ( $i + 1 ); ?> - <?php echo $count; ?></div>
						<?php } ?>
					</div>
				</div>
				<?php } ?>
			<?php } elseif ( $count > 1 ) { ?>
			<div class="<?php echo ( $type === 'url' ? 'media-body streamMediaBody ' : null ); ?>streamItemAttachmentInfo">
				<div class="text-small streamItemAttachmentUrl">
					<div class="text-muted text-right streamItemAttachmentCount"><?php echo ( $i + 1 ); ?> - <?php echo $count; ?></div>
				</div>
			</div>
			<?php } ?>
		</div>
	</div>
	<?php } ?>
<?php if ( $count > 1 ) { ?>
	<div class="d-flex flex-column justify-content-center pl-2 streamItemScrollRight">
		<span class="fa fa-chevron-right streamItemScrollRightIcon"></span>
	</div>
</div>
<?php } ?>