<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Application\Application;
use CB\Database\Table\UserTable;
use CBLib\Language\CBTxt;
use CB\Plugin\Activity\CBActivity;
use CB\Plugin\Activity\Table\ActivityTable;
use CB\Plugin\Activity\Activity;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var ActivityTable     $row
 * @var UserTable         $viewer
 * @var Activity          $stream
 * @var CBplug_cbactivity $this
 * @var string            $output   
 *
 * @var string            $pinnedTooltip
 * @var string            $globalTooltip
 * @var string            $reportedTooltip
 */

global $_CB_framework, $_PLUGINS;

$canModerate				=	CBActivity::canModerate( $stream );
$rowId						=	md5( $stream->id() . '_' . $row->getInt( 'id', 0 ) );
$rowOwner					=	( $viewer->getInt( 'id', 0 ) === $row->getInt( 'user_id', 0 ) );

if ( $row->getBool( 'system', false ) ) {
	$title					=	$row->getHtml( 'title' );
	$message				=	$row->getHtml( 'message' );
} else {
	$title					=	htmlspecialchars( $row->getString( 'title' ) );
	$message				=	htmlspecialchars( $row->getString( 'message' ) );
}

$date						=	null;
$insert						=	null;
$footer						=	null;
$menu						=	array();

require CBActivity::getTemplate( $stream->getString( 'template' ), 'core/display', false );

$integrations				=	implode( '', $_PLUGINS->trigger( 'activity_onDisplayStreamActivity', array( &$row, &$title, &$date, &$message, &$insert, &$footer, &$menu, $stream, $output ) ) );

if ( $integrations ) {
	$footer					=	$integrations . $footer;
}

$title						=	$stream->parser( $title, $row )->parse( array( 'linebreaks' ) );
$message					=	$stream->parser( $message, $row )->parse();
$action						=	( CBActivity::findParamOverride( $row, 'actions', true, $stream ) ? $stream->parser( $row->action( $stream ) )->parse( array( 'linebreaks' ) ) : null );
$location					=	( CBActivity::findParamOverride( $row, 'locations', true, $stream ) ? $row->location( $stream ) : null );
$tags						=	null;

if ( CBActivity::findParamOverride( $row, 'tags', true, $stream ) ) {
	$tags					=	$row->tags( $stream )->tags( 'tagged' );

	if ( $tags ) {
		$tags				=	CBTxt::T( 'ACTIVITY_TAGS', 'with [tags]', array( '[tags]' => $tags ) );
	}
}

if ( $action || $location || $tags ) {
	$subContent				=	( $action ? $action : null )
							.	( $location ? ( $action ? ' ' : null ) . $location : null )
							.	( $tags ? ( $action || $location ? ' ' : null ) . $tags : null );

	if ( $title ) {
		$message			.=	'<div class="streamItemSubContent">&mdash; ' . $subContent . '</div>';
	} else {
		$title				.=	$subContent;
	}
}

if ( preg_match( '/^profile\.(\d+)(?:\.([a-zA-Z]+)(?:\.(.+))?)?/', $row->getString( 'asset' ), $matches )
	 && ( (int) $matches[1] !== $row->getInt( 'user_id', 0 ) )
	 && ( (int) $matches[1] !== $_CB_framework->displayedUser() )
	 && ( ( ! isset( $matches[2] ) ) || ( ! $matches[2] ) || ( $matches[2] && ( ! $title ) ) )
) {
	$targetUser				=	CBuser::getInstance( (int) $matches[1], false );

	if ( $targetUser->getUserData()->getInt( 'id', 0 ) ) {
		$title				.=	' <span class="fa fa-caret-right"></span> <strong>' . $targetUser->getField( 'formatname', null, 'html', 'none', 'list', 0, true ) . '</strong>';
	}
}

if ( ( ! $row->isHidden() ) && CBActivity::findParamOverride( $row, 'likes', true, $stream ) ) {
	$like					=	$row->likes( $stream )->likes( 'button' );

	if ( $like ) {
		if ( $footer ) {
			$footer			.=	'<div class="border-top mt-2 mb-2 streamPanelFooterDivider"></div>';
		}

		$footer				.=	$like;
	}
}

if ( ( ! $row->isHidden() ) && CBActivity::findParamOverride( $row, 'comments', true, $stream ) ) {
	$comments				=	$row->comments( $stream )->comments();

	if ( $comments ) {
		if ( $footer ) {
			$footer			.=	'<div class="border-top mt-2 mb-2 streamPanelFooterDivider"></div>';
		}

		$footer				.=	$comments;
	}
}

$modified					=	$row->params()->getString( 'modified' );

if ( $modified ) {
	$modified				=	cbTooltip( null, cbFormatDate( $modified ), null, 'auto', null, '<span class="fa fa-edit"></span>', null, 'class="align-text-top streamIconEdited" data-hascbtooltip="true" data-cbtooltip-position-my="bottom center" data-cbtooltip-position-at="top center" data-cbtooltip-classes="qtip-simple"' );
}

$theme						=	$row->theme( $stream );
$themeClasses				=	null;
$themeStyles				=	null;

if ( $theme ) {
	$themeClasses			=	' ' . trim( 'streamMessageTheme ' . htmlspecialchars( $theme['class'] ) );
	$themeStyles			=	( $theme['background'] ? ' style="background-image: url(' . htmlspecialchars( $theme['background'] ) . ')"' : null );
}

$menuItems					=	null;

if ( CBActivity::findParamOverride( $row, 'menu', true ) && ( $canModerate || $rowOwner || ( $viewer->getInt( 'id', 0 ) && ( ! $rowOwner ) ) || $menu ) ) {
	if ( $viewer->getInt( 'id', 0 ) && ( $row->isHidden() || ( ! $rowOwner ) || $row->isFollowing( $stream ) ) ) {
		$hideUser			=	CBuser::getInstance( $row->getInt( 'user_id', 0 ), false )->getField( 'formatname', null, 'html', 'none', 'profile', 0, true );

		if ( $row->isHidden() ) {
			if ( $row->getString( '_hidden_user' ) && ( ! $row->getBool( 'system', false ) ) ) {
				$menuItems	.=		'<li class="streamItemMenuItem"><a href="javascript: void(0);" data-cbactivity-action-url="' . $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'activity', 'func' => 'unhide', 'type' => 'user', 'id' => $row->getInt( 'id', 0 ), 'stream' => $stream->id() ), 'raw', 0, true ) . '" class="dropdown-item activityMenuItemUnhide streamItemAction" data-cbactivity-container=".streamItem' . $rowId . '"><span class="fa fa-unlock-alt"></span> ' . CBTxt::T( 'UNHIDE_ACTIVITY_FROM_USER', 'Unhide Activity from <span class="text-info">[user]</span>', array( '[user]' => $hideUser ) ) . '</a></li>';
			}

			if ( $row->getString( '_hidden_asset' ) ) {
				$menuItems	.=		'<li class="streamItemMenuItem"><a href="javascript: void(0);" data-cbactivity-action-url="' . $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'activity', 'func' => 'unhide', 'type' => 'asset', 'id' => $row->getInt( 'id', 0 ), 'stream' => $stream->id() ), 'raw', 0, true ) . '" class="dropdown-item activityMenuItemUnhide streamItemAction" data-cbactivity-container=".streamItem' . $rowId . '"><span class="fa fa-unlock-alt"></span> ' . CBTxt::T( 'Unhide similar Activity' ) . '</a></li>';
			}

			if ( $row->getString( '_hidden_id' ) ) {
				$menuItems	.=		'<li class="streamItemMenuItem"><a href="javascript: void(0);" data-cbactivity-action-url="' . $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'activity', 'func' => 'unhide', 'type' => 'activity', 'id' => $row->getInt( 'id', 0 ), 'stream' => $stream->id() ), 'raw', 0, true ) . '" class="dropdown-item activityMenuItemUnhide streamItemAction" data-cbactivity-container=".streamItem' . $rowId . '"><span class="fa fa-unlock-alt"></span> ' . CBTxt::T( 'Unhide this Activity' ) . '</a></li>';
			}
		} elseif ( ! $rowOwner ) {
			$menuItems		.=		( ! $row->getBool( 'system', false ) ? '<li class="streamItemMenuItem"><a href="javascript: void(0);" data-cbactivity-action-url="' . $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'activity', 'func' => 'hide', 'type' => 'user', 'id' => $row->getInt( 'id', 0 ), 'stream' => $stream->id() ), 'raw', 0, true ) . '" class="dropdown-item activityMenuItemHide streamItemAction" data-cbactivity-container=".streamItem' . $rowId . '" data-cbactivity-confirm="' . htmlspecialchars( CBTxt::T( 'ARE_YOU_SURE_HIDE_ACTIVITY_FROM_USER', 'Are you sure you want to hide all Activity from <span class="text-info">[user]</span>?', array( '[user]' => $hideUser ) ) ) . '" data-cbactivity-confirm-button="' . htmlspecialchars( CBTxt::T( 'HIDE_ACTIVITY_FROM_USER_BUTTON', 'Hide Activity from <strong>[user]</strong>', array( '[user]' => $hideUser ) ) ) . '"><span class="fa fa-lock"></span> ' . CBTxt::T( 'HIDE_ACTIVITY_FROM_USER', 'Hide Activity from <span class="text-info">[user]</span>', array( '[user]' => $hideUser ) ) . '</a></li>' : null )
							.		'<li class="streamItemMenuItem"><a href="javascript: void(0);" data-cbactivity-action-url="' . $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'activity', 'func' => 'hide', 'type' => 'asset', 'id' => $row->getInt( 'id', 0 ), 'stream' => $stream->id() ), 'raw', 0, true ) . '" class="dropdown-item activityMenuItemHide streamItemAction" data-cbactivity-container=".streamItem' . $rowId . '" data-cbactivity-confirm="' . htmlspecialchars( CBTxt::T( 'Are you sure you want to hide all Activity similar to this Activity?' ) ) . '" data-cbactivity-confirm-button="' . htmlspecialchars( CBTxt::T( 'Hide similar Activity' ) ) . '"><span class="fa fa-lock"></span> ' . CBTxt::T( 'Hide similar Activity' ) . '</a></li>'
							.		'<li class="streamItemMenuItem"><a href="javascript: void(0);" data-cbactivity-action-url="' . $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'activity', 'func' => 'hide', 'type' => 'activity', 'id' => $row->getInt( 'id', 0 ), 'stream' => $stream->id() ), 'raw', 0, true ) . '" class="dropdown-item activityMenuItemHide streamItemAction" data-cbactivity-container=".streamItem' . $rowId . '" data-cbactivity-confirm="' . htmlspecialchars( CBTxt::T( 'Are you sure you want to hide this Activity?' ) ) . '" data-cbactivity-confirm-button="' . htmlspecialchars( CBTxt::T( 'Hide this Activity' ) ) . '"><span class="fa fa-lock"></span> ' . CBTxt::T( 'Hide this Activity' ) . '</a></li>';
		}

		if ( $row->isFollowing( $stream ) ) {
			$menuItems		.=		'<li class="streamItemMenuItem"><a href="javascript: void(0);" data-cbactivity-action-url="' . $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'activity', 'func' => 'unfollow', 'id' => $row->getInt( 'id', 0 ), 'stream' => $stream->id() ), 'raw', 0, true ) . '" class="dropdown-item activityMenuItemUnfollow streamItemAction" data-cbactivity-container=".streamItem' . $rowId . '"><span class="fa fa-user"></span> ' . CBTxt::T( 'Unfollow this Activity' ) . '</a></li>';
		}

		if ( $canModerate || $rowOwner || $menu ) {
			$menuItems		.=		'<li class="streamItemMenuItem"><div class="dropdown-divider"></div></li>';
		}
	}

	if ( $canModerate || $rowOwner ) {
		if ( $stream->getBool( 'pinned', true ) && Application::MyUser()->isGlobalModerator() && ( ! $row->isHidden() ) ) {
			if ( $row->isPinned( $stream ) ) {
				$menuItems	.=		'<li class="streamItemMenuItem"><a href="javascript: void(0);" data-cbactivity-action-url="' . $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'activity', 'func' => 'unpin', 'id' => $row->getInt( 'id', 0 ), 'stream' => $stream->id() ), 'raw', 0, true ) . '" class="dropdown-item activityMenuItemUnpin streamItemAction" data-cbactivity-container=".streamItem' . $rowId . '"><span class="fa fa-star-o"></span> ' . CBTxt::T( 'Unpin this Activity' ) . '</a></li>';
			} else {
				$menuItems	.=		'<li class="streamItemMenuItem"><a href="javascript: void(0);" data-cbactivity-action-url="' . $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'activity', 'func' => 'pin', 'id' => $row->getInt( 'id', 0 ), 'stream' => $stream->id() ), 'raw', 0, true ) . '" class="dropdown-item activityMenuItemPin streamItemAction" data-cbactivity-container=".streamItem' . $rowId . '"><span class="fa fa-star"></span> ' . CBTxt::T( 'Pin this Activity' ) . '</a></li>';
			}
		}

		if ( CBActivity::canEdit( $row, $stream, $viewer ) ) {
			$menuItems		.=		'<li class="streamItemMenuItem"><a href="javascript: void(0);" data-cbactivity-action-url="' . $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'activity', 'func' => 'edit', 'id' => $row->getInt( 'id', 0 ), 'stream' => $stream->id() ), 'raw', 0, true ) . '" class="dropdown-item activityMenuItemEdit streamItemAction" data-cbactivity-container=".streamItem' . $rowId . '"><span class="fa fa-edit"></span> ' . CBTxt::T( 'Edit' ) . '</a></li>';
		}

		if ( CBActivity::canDelete( $row, $stream, $viewer ) ) {
			$menuItems		.=		'<li class="streamItemMenuItem"><a href="javascript: void(0);" data-cbactivity-action-url="' . $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'activity', 'func' => 'delete', 'id' => $row->getInt( 'id', 0 ), 'stream' => $stream->id() ), 'raw', 0, true ) . '" class="dropdown-item activityMenuItemDelete streamItemAction" data-cbactivity-container=".streamItem' . $rowId . '" data-cbactivity-confirm="' . htmlspecialchars( CBTxt::T( 'Are you sure you want to delete this Activity?' ) ) . '" data-cbactivity-confirm-button="' . htmlspecialchars( CBTxt::T( 'Delete Activity' ) ) . '"><span class="fa fa-trash-o"></span> ' . CBTxt::T( 'Delete' ) . '</a></li>';
		}
	}

	if ( CBActivity::getGlobalParams()->getBool( 'reporting', true ) && $viewer->getInt( 'id', 0 ) && ( ! $rowOwner ) && ( ! $canModerate ) && ( ! CBActivity::canModerate( $stream, $row->getInt( 'user_id', 0 ) ) ) && ( ! $row->isHidden() ) && ( ! $row->isGlobal( $stream ) ) ) {
		$menuItems			.=		'<li class="streamItemMenuItem"><a href="javascript: void(0);" data-cbactivity-action-url="' . $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'activity', 'func' => 'report', 'id' => $row->getInt( 'id', 0 ), 'stream' => $stream->id() ), 'raw', 0, true ) . '" class="dropdown-item activityMenuItemReport streamItemAction" data-cbactivity-container=".streamItem' . $rowId . '" data-cbactivity-confirm="' . htmlspecialchars( CBTxt::T( 'Are you sure you want to report and hide this Activity?' ) ) . '" data-cbactivity-confirm-button="' . htmlspecialchars( CBTxt::T( 'Report and Hide this Activity' ) ) . '"><span class="fa fa-exclamation-circle"></span> ' . CBTxt::T( 'Report this Activity' ) . '</a></li>';
	}

	if ( $menu ) {
		$menuItems			.=		'<li class="streamItemMenuItem">' . implode( '</li><li class="streamItemMenuItem">', $menu ) . '</li>';
	}

	if ( $menuItems ) {
		$menuItems			=	'<ul class="list-unstyled dropdown-menu d-block position-relative m-0 streamItemMenuItems activityMenuItems streamItemActions" data-cbactivity-stream="' . htmlspecialchars( $stream->id() ) . '">'
							.		$menuItems
							.	'</ul>';
	}
}
?>
<div class="d-block card<?php echo ( $row->isGlobal( $stream ) ? ' border-info' : ( $row->isPinned( $stream ) ? ' border-warning' : null ) ) . ( CBActivity::findParamOverride( $row, 'inline', false ) ? ' border-0 streamItemInline' : null ); ?> streamItem<?php echo ( CBActivity::findParamOverride( $row, 'compact', false ) ? ' streamItemCompact' : null ) . ( $row->isGlobal( $stream ) ? ' streamItemGlobal' : null ) . ( $row->isPinned( $stream ) ? ' streamItemPinned' : null ); ?> streamPanel activityContainer streamItem<?php echo $rowId; ?>" data-cbactivity-id="<?php echo $row->getInt( 'id', 0 ); ?>" data-cbactivity-timestamp="<?php echo Application::Date( $row->getString( 'date' ), 'UTC' )->getTimestamp(); ?>"<?php echo ( CBActivity::findParamOverride( $row, 'inline', false ) ? ' data-cbactivity-inline="true"' : null ); ?>>
	<div class="card-header bg-transparent border-0 p-0 streamPanelHeading activityContainerHeader">
		<div class="m-2<?php echo ( ! CBActivity::findParamOverride( $row, 'compact', false ) ? ' media streamMedia' : null ); ?> activityContainerHeaderInner">
			<?php if ( ! CBActivity::findParamOverride( $row, 'compact', false ) ) { ?>
			<div class="media-left streamMediaLeft activityContainerLogo">
				<?php echo CBActivity::getOwnerAvatar( $row ); ?>
			</div>
			<?php } ?>
			<div class="text-muted<?php echo ( ! CBActivity::findParamOverride( $row, 'compact', false ) ? ' media-body pl-2 pr-5 streamMediaBody' : ' pr-5' ); ?> activityContainerTitle">
				<div class="text-wrap activityContainerTitleTop">
					<?php echo CBActivity::getOwnerName( $row ); ?>
					<?php echo $title; ?>
				<?php if ( ! CBActivity::findParamOverride( $row, 'compact', false ) ) { ?>
				</div>
				<div class="text-small activityContainerTitleBottom">
				<?php } ?>
					<?php echo cbTooltip( null, cbFormatDate( CBActivity::findParamOverride( $row, 'date', $row->getString( 'date' ) ) ), null, 'auto', null, cbFormatDate( CBActivity::findParamOverride( $row, 'date', $row->getString( 'date' ) ), true, 'timeago' ), null, 'data-hascbtooltip="true" data-cbtooltip-position-my="bottom center" data-cbtooltip-position-at="top center" data-cbtooltip-classes="qtip-simple"' ); ?>
					<?php echo $modified; ?>
					<?php echo $date; ?>
				</div>
			</div>
		</div>
	</div>
	<?php if ( $message ) { ?>
	<div class="card-body p-0 streamPanelBody streamItemDisplay activityContainerContent">
		<div class="m-2 activityContainerContentInner cbMoreLess<?php echo $themeClasses; ?>"<?php echo $themeStyles; ?>>
			<div class="text-wrap streamItemContent cbMoreLessContent clearfix">
				<?php echo $message; ?>
			</div>
			<div class="fade-edge cbMoreLessOpen hidden">
				<a href="javascript: void(0);" class="cbMoreLessButton"><?php echo CBTxt::T( 'See More' ); ?></a>
			</div>
		</div>
	</div>
	<?php } ?>
	<?php if ( $insert ) { ?>
	<div class="card-body p-0 streamPanelBody streamItemDisplay activityContainerInsert">
		<div class="<?php echo ( ! CBActivity::findParamOverride( $row, 'compact', false ) ? 'm-1 ' : null ); ?>activityContainerInsertInner"><?php echo $insert; ?></div>
	</div>
	<?php } ?>
	<?php if ( CBActivity::findParamOverride( $row, 'links', true, $stream ) && $row->attachments()->count() ) { ?>
	<div class="card-body p-0 streamPanelBody streamItemDisplay activityContainerAttachments">
		<div class="m-1 activityContainerAttachmentsInner">
			<?php require CBActivity::getTemplate( $stream->getString( 'template' ), 'attachments/display', false ); ?>
		</div>
	</div>
	<?php } ?>
	<?php if ( $footer ) { ?>
	<div class="card-footer p-2 streamPanelFooter streamItemDisplay activityContainerFooter">
		<div class="activityContainerFooterInner"><?php echo $footer; ?></div>
	</div>
	<?php } ?>
	<?php if ( $row->isPinned( $stream ) || $row->isGlobal( $stream ) || $row->params()->getInt( 'reports', 0 ) || $menuItems ) { ?>
	<div class="<?php echo ( ! $menuItems ? 'd-none d-sm-block ' : null ); ?>position-absolute pr-2 pt-2 text-right streamItemMenu activityContainerMenu">
		<?php if ( $row->isPinned( $stream ) ) { ?>
		<span class="fa fa-star text-warning streamItemPinnedIcon"<?php echo $pinnedTooltip; ?>></span>
		<?php } ?>
		<?php if ( $row->isGlobal( $stream ) ) { ?>
		<span class="fa fa-bullhorn text-info streamItemGlobalIcon"<?php echo $globalTooltip; ?>></span>
		<?php } ?>
		<?php if ( $row->params()->getInt( 'reports', 0 ) ) { ?>
		<span class="fa fa-warning text-danger streamItemReportedIcon"<?php echo $reportedTooltip; ?>></span>
		<?php } ?>
		<?php if ( $menuItems ) { ?>
			<?php echo cbTooltip( null, $menuItems, null, 'auto', null, '<span class="ml-2 fa fa-ellipsis-v"></span>', 'javascript:void(0);', 'class="text-body cbDropdownMenu streamItemMenuToggle" data-cbtooltip-menu="true" data-cbtooltip-classes="qtip-nostyle" data-cbtooltip-open-classes="active"' ); ?>
		<?php } ?>
	</div>
	<?php } ?>
	<?php echo ( $output === 'save' ? CBActivity::reloadHeaders() : null ); ?>
	<div class="position-absolute d-flex flex-column justify-content-center align-items-center w-100 h-100 bg-light streamLoading hidden"><div class="spinner-border spinner-border-sm"></div></div>
</div>