<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\Activity\Trigger;

use CB\Database\Table\UserTable;
use CBLib\Application\Application;
use CB\Plugin\Activity\Notifications;

defined('CBLIB') or die();

class MenuTrigger extends \cbPluginHandler
{

	/**
	 * Displays frontend notifications icon on cb menu bar
	 *
	 * @param UserTable $user
	 * @return null|string
	 */
	public function getNotifications( $user )
	{
		if ( ( ! $this->params->getBool( 'general_notifications', true ) ) || ( Application::MyUser()->getUserId() !== $user->getInt( 'id', 0 ) ) ) {
			return null;
		}

		$notifications	=	new Notifications( $this->params->getString( 'notifications_asset' ), $user );

		$notifications->set( 'read', 'unread' );

		$return			=	$notifications->notifications( 'button' );

		if ( ! $return ) {
			return null;
		}

		return $return;
	}
}