<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\Activity;

use CB\Database\Table\UserTable;
use CBLib\Registry\ParamsInterface;
use CB\Plugin\Activity\Table\TagTable;

defined('CBLIB') or die();

interface TagsInterface extends ParamsInterface
{
	/**
	 * Retrieves tags rows or row count
	 *
	 * @param string $output
	 * @return TagTable[]|int
	 */
	public function rows( $output = null );

	/**
	 * Retrieves tags row
	 *
	 * @param int $id
	 * @return TagTable
	 */
	public function row( $id );

	/**
	 * Outputs tags HTML
	 *
	 * @param null|string $view
	 * @param int         $id
	 * @param array       $params
	 * @return string
	 */
	public function tags( $view = null, $id = 0, $params = array() );
}