<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\Activity\Table;

use CBLib\Application\Application;
use CBLib\Database\Table\Table;
use CBLib\Language\CBTxt;
use CBLib\Registry\Registry;
use CB\Database\Table\UserTable;
use CB\Plugin\Activity\CBActivity;

defined('CBLIB') or die();

class LikeTable extends Table
{
	/** @var int  */
	public $id				=	null;
	/** @var int  */
	public $user_id			=	null;
	/** @var string  */
	public $asset			=	null;
	/** @var int  */
	public $type			=	null;
	/** @var string  */
	public $date			=	null;
	/** @var string  */
	public $params			=	null;

	/** @var Registry  */
	protected $_params		=	null;

	/**
	 * Table name in database
	 *
	 * @var string
	 */
	protected $_tbl			=	'#__comprofiler_plugin_activity_likes';

	/**
	 * Primary key(s) of table
	 *
	 * @var string
	 */
	protected $_tbl_key		=	'id';

	/**
	 * @return bool
	 */
	public function check()
	{
		if ( ! $this->getInt( 'user_id', 0 ) ) {
			$this->setError( CBTxt::T( 'Owner not specified!' ) );

			return false;
		}

		if ( ! $this->getString( 'asset' ) ) {
			$this->setError( CBTxt::T( 'Asset not specified!' ) );

			return false;
		}

		return true;
	}

	/**
	 * @param bool $updateNulls
	 * @return bool
	 */
	public function store( $updateNulls = false )
	{
		global $_PLUGINS;

		$new	=	( ! $this->getInt( 'id', 0 ) );
		$old	=	new self();

		$this->set( 'date', $this->getString( 'date', Application::Database()->getUtcDateTime() ) );

		if ( ! $new ) {
			$old->load( $this->getInt( 'id', 0 ) );

			if ( in_array( false, $_PLUGINS->trigger( 'activity_onBeforeUpdateLike', array( &$this, $old ) ), true ) ) {
				return false;
			}
		} elseif ( in_array( false, $_PLUGINS->trigger( 'activity_onBeforeCreateLike', array( &$this ) ), true ) ) {
			return false;
		}

		if ( ! parent::store( $updateNulls ) ) {
			return false;
		}

		if ( ! $new ) {
			$_PLUGINS->trigger( 'activity_onAfterUpdateLike', array( $this, $old ) );
		} else {
			$_PLUGINS->trigger( 'activity_onAfterCreateLike', array( $this ) );
		}

		return true;
	}

	/**
	 * @param null|int $id
	 * @return bool
	 */
	public function delete( $id = null )
	{
		global $_PLUGINS;

		if ( in_array( false, $_PLUGINS->trigger( 'activity_onBeforeDeleteLike', array( &$this ) ), true ) ) {
			return false;
		}

		if ( ! parent::delete( $id ) ) {
			return false;
		}

		// Deletes activity about this like:
		$query			=	'SELECT *'
						.	"\n FROM " . $this->getDbo()->NameQuote( '#__comprofiler_plugin_activity' )
						.	"\n WHERE ( " . $this->getDbo()->NameQuote( 'asset' ) . " = " . $this->getDbo()->Quote( 'like.' . $this->getInt( 'id', 0 ) )
						.	" OR " . $this->getDbo()->NameQuote( 'asset' ) . " = " . $this->getDbo()->Quote( $this->getString( 'asset' ) . '.like.' . $this->getInt( 'id', 0 ) ) . " )";
		$this->getDbo()->setQuery( $query );
		$activities		=	$this->getDbo()->loadObjectList( null, '\CB\Plugin\Activity\Table\ActivityTable', array( $this->getDbo() ) );

		/** @var ActivityTable[] $activities */
		foreach ( $activities as $activity ) {
			$activity->delete();
		}

		// Deletes comments about this like:
		$query			=	'SELECT *'
						.	"\n FROM " . $this->getDbo()->NameQuote( '#__comprofiler_plugin_activity_comments' )
						.	"\n WHERE ( " . $this->getDbo()->NameQuote( 'asset' ) . " = " . $this->getDbo()->Quote( 'like.' . $this->getInt( 'id', 0 ) )
						.	" OR " . $this->getDbo()->NameQuote( 'asset' ) . " = " . $this->getDbo()->Quote( $this->getString( 'asset' ) . '.like.' . $this->getInt( 'id', 0 ) ) . " )";
		$this->getDbo()->setQuery( $query );
		$comments		=	$this->getDbo()->loadObjectList( null, '\CB\Plugin\Activity\Table\CommentTable', array( $this->getDbo() ) );

		/** @var CommentTable[] $comments */
		foreach ( $comments as $comment ) {
			$comment->delete();
		}

		// Deletes like specific notifications:
		$query			=	'SELECT *'
						.	"\n FROM " . $this->getDbo()->NameQuote( '#__comprofiler_plugin_activity_notifications' )
						.	"\n WHERE ( " . $this->getDbo()->NameQuote( 'asset' ) . " = " . $this->getDbo()->Quote( 'like.' . $this->getInt( 'id', 0 ) )
						.	" OR " . $this->getDbo()->NameQuote( 'asset' ) . " = " . $this->getDbo()->Quote( $this->getString( 'asset' ) . '.like.' . $this->getInt( 'id', 0 ) ) . " )";
		$this->getDbo()->setQuery( $query );
		$notifications	=	$this->getDbo()->loadObjectList( null, '\CB\Plugin\Activity\Table\NotificationTable', array( $this->getDbo() ) );

		/** @var NotificationTable[] $notifications */
		foreach ( $notifications as $notification ) {
			$notification->delete();
		}

		$_PLUGINS->trigger( 'activity_onAfterDeleteLike', array( $this ) );

		return true;
	}

	/**
	 * @return Registry
	 */
	public function params()
	{
		if ( ! ( $this->getRaw( '_params' ) instanceof Registry ) ) {
			$this->set( '_params', new Registry( $this->getRaw( 'params' ) ) );
		}

		return $this->getRaw( '_params' );
	}

	/**
	 * @return UserTable|ActivityTable|CommentTable|TagTable|FollowTable|LikeTable|NotificationTable|null
	 */
	public function source()
	{
		global $_PLUGINS;

		static $cache		=	array();

		$id					=	$this->getString( 'asset' );

		if ( ! isset( $cache[$id] ) ) {
			$source			=	CBActivity::getSource( $id );

			$_PLUGINS->trigger( 'activity_onLikeSource', array( $this, &$source ) );

			$cache[$id]		=	$source;
		}

		return $cache[$id];
	}

	/**
	 * @return LikeTypeTable
	 */
	public function type()
	{
		static $cache		=	array();

		$id					=	$this->getInt( 'type', 0 );

		if ( ! isset( $cache[$id] ) ) {
			$type			=	new LikeTypeTable();

			$type->load( $id );

			$cache[$id]		=	$type;
		}

		return $cache[$id];
	}
}