<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\Activity\Table;

use CBLib\Database\Table\Table;
use CBLib\Language\CBTxt;

defined('CBLIB') or die();

class HiddenTable extends Table
{
	/** @var int  */
	public $id				=	null;
	/** @var int  */
	public $user_id			=	null;
	/** @var string  */
	public $type			=	null;
	/** @var int  */
	public $object			=	null;
	/** @var string  */
	public $asset			=	null;

	/**
	 * Table name in database
	 *
	 * @var string
	 */
	protected $_tbl			=	'#__comprofiler_plugin_activity_hidden';

	/**
	 * Primary key(s) of table
	 *
	 * @var string
	 */
	protected $_tbl_key		=	'id';

	/**
	 * @return bool
	 */
	public function check()
	{
		if ( ! $this->getInt( 'user_id', 0 ) ) {
			$this->setError( CBTxt::T( 'Owner not specified!' ) );

			return false;
		}

		if ( ! preg_replace( '/[^-a-zA-Z0-9_.]/', '', $this->getString( 'type' ) ) ) {
			$this->setError( CBTxt::T( 'Type not specified!' ) );

			return false;
		}

		switch ( $this->getString( 'type' ) ) {
			case 'activity.asset':
			case 'comment.asset':
			case 'notification.asset':
				if ( ! $this->getString( 'asset' ) ) {
					$this->setError( CBTxt::T( 'Asset not specified!' ) );

					return false;
				}
				break;
			case 'activity':
			case 'activity.user':
			case 'comment':
			case 'comment.user':
			case 'notification':
			case 'notification.user':
			default:
				if ( ! $this->getString( 'object' ) ) {
					$this->setError( CBTxt::T( 'Object not specified!' ) );

					return false;
				}
				break;
		}

		return true;
	}

	/**
	 * @param bool $updateNulls
	 * @return bool
	 */
	public function store( $updateNulls = false )
	{
		global $_PLUGINS;

		$new	=	( ! $this->getInt( 'id', 0 ) );
		$old	=	new self();

		$this->set( 'type', preg_replace( '/[^-a-zA-Z0-9_.]/', '', $this->getString( 'type' ) ) );

		if ( ! $new ) {
			$old->load( $this->getInt( 'id', 0 ) );

			if ( in_array( false, $_PLUGINS->trigger( 'activity_onBeforeUpdateHidden', array( &$this, $old ) ), true ) ) {
				return false;
			}
		} elseif ( in_array( false, $_PLUGINS->trigger( 'activity_onBeforeCreateHidden', array( &$this ) ), true ) ) {
			return false;
		}

		if ( ! parent::store( $updateNulls ) ) {
			return false;
		}

		if ( ! $new ) {
			$_PLUGINS->trigger( 'activity_onAfterUpdateHidden', array( $this, $old ) );
		} else {
			$_PLUGINS->trigger( 'activity_onAfterCreateHidden', array( $this ) );
		}

		return true;
	}

	/**
	 * @param null|int $id
	 * @return bool
	 */
	public function delete( $id = null )
	{
		global $_PLUGINS;

		if ( in_array( false, $_PLUGINS->trigger( 'activity_onBeforeDeleteHidden', array( &$this ) ), true ) ) {
			return false;
		}

		if ( ! parent::delete( $id ) ) {
			return false;
		}

		$_PLUGINS->trigger( 'activity_onAfterDeleteHidden', array( $this ) );

		return true;
	}
}