<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\Activity\Table;

use CBLib\Database\Table\OrderedTable;
use CBLib\Language\CBTxt;
use CBLib\Registry\Registry;
use CBLib\Application\Application;
use CB\Plugin\Activity\CBActivity;

defined('CBLIB') or die();

// Stored Language Strings:
// CBTxt::T( 'Feeling' )
// CBTxt::T( 'How are you feeling?' )
// CBTxt::T( 'Watching' )
// CBTxt::T( 'What are you watching?' )
// CBTxt::T( 'Reading' )
// CBTxt::T( 'What are you reading?' )
// CBTxt::T( 'Listening To' )
// CBTxt::T( 'What are you listening to?' )
// CBTxt::T( 'Drinking' )
// CBTxt::T( 'What are you drinking?' )
// CBTxt::T( 'Eating' )
// CBTxt::T( 'What are you eating?' )
// CBTxt::T( 'Playing' )
// CBTxt::T( 'What are you playing?' )
// CBTxt::T( 'Traveling To' )
// CBTxt::T( 'Where are you going?' )
// CBTxt::T( 'Looking For' )
// CBTxt::T( 'What are you looking for?' )
// CBTxt::T( 'Celebrating' )
// CBTxt::T( 'What are you celebrating?' )
// Feeling
// CBTxt::T( 'happy' )
// CBTxt::T( 'blessed' )
// CBTxt::T( 'loved' )
// CBTxt::T( 'sad' )
// CBTxt::T( 'thankful' )
// CBTxt::T( 'excited' )
// CBTxt::T( 'scared' )
// CBTxt::T( 'confident' )
// CBTxt::T( 'cool' )
// CBTxt::T( 'tired' )
// CBTxt::T( 'annoyed' )
// CBTxt::T( 'embarassed' )
// CBTxt::T( 'silly' )
// CBTxt::T( 'shocked' )
// CBTxt::T( 'frustrated' )
// CBTxt::T( 'meh' )
// Drinking
// CBTxt::T( 'tea' )
// Eating
// CBTxt::T( 'lunch' )
// CBTxt::T( 'dinner' )
// CBTxt::T( 'breakfast' )
// Celebrating
// CBTxt::T( 'a birthday' )
// CBTxt::T( 'my birthday' )
// CBTxt::T( 'an anniversary' )
// CBTxt::T( 'my anniversary' )
// CBTxt::T( 'an engagement' )
// CBTxt::T( 'my engagement' )
// CBTxt::T( 'a wedding' )
// CBTxt::T( 'my wedding' )
// CBTxt::T( 'life' )
// CBTxt::T( 'love' )
// CBTxt::T( 'graduation' )
// CBTxt::T( 'the holidays' )
// CBTxt::T( 'victory' )
// CBTxt::T( 'food' )

class ActionTable extends OrderedTable
{
	/** @var int  */
	public $id				=	null;
	/** @var string  */
	public $value			=	null;
	/** @var string  */
	public $title			=	null;
	/** @var string  */
	public $description		=	null;
	/** @var string  */
	public $icon			=	null;
	/** @var string  */
	public $class			=	null;
	/** @var int  */
	public $access			=	null;
	/** @var int  */
	public $published		=	null;
	/** @var int  */
	public $ordering		=	null;
	/** @var string  */
	public $params			=	null;

	/** @var Registry  */
	protected $_params		=	null;

	/**
	 * Table name in database
	 *
	 * @var string
	 */
	protected $_tbl			=	'#__comprofiler_plugin_activity_actions';

	/**
	 * Primary key(s) of table
	 *
	 * @var string
	 */
	protected $_tbl_key		=	'id';

	/**
	 * Ordering keys and for each their ordering groups.
	 * E.g.; array( 'ordering' => array( 'tab' ), 'ordering_registration' => array() )
	 * @var array
	 */
	protected $_orderings	=	array( 'ordering' => array() );

	/**
	 * @return bool
	 */
	public function check()
	{
		if ( ! $this->getString( 'value' ) ) {
			$this->setError( CBTxt::T( 'Action not specified!' ) );

			return false;
		}

		return true;
	}

	/**
	 * @param bool $updateNulls
	 * @return bool
	 */
	public function store( $updateNulls = false )
	{
		global $_PLUGINS;

		$new	=	( ! $this->getInt( 'id', 0 ) );
		$old	=	new self();

		if ( ! $new ) {
			$old->load( $this->getInt( 'id', 0 ) );

			if ( in_array( false, $_PLUGINS->trigger( 'activity_onBeforeUpdateAction', array( &$this, $old ) ), true ) ) {
				return false;
			}
		} elseif ( in_array( false, $_PLUGINS->trigger( 'activity_onBeforeCreateAction', array( &$this ) ), true ) ) {
			return false;
		}

		if ( ! parent::store( $updateNulls ) ) {
			return false;
		}

		if ( ! $new ) {
			$_PLUGINS->trigger( 'activity_onAfterUpdateAction', array( $this, $old ) );
		} else {
			$_PLUGINS->trigger( 'activity_onAfterCreateAction', array( $this ) );
		}

		return true;
	}

	/**
	 * @param null|int $id
	 * @return bool
	 */
	public function delete( $id = null )
	{
		global $_PLUGINS;

		if ( in_array( false, $_PLUGINS->trigger( 'activity_onBeforeDeleteAction', array( &$this ) ), true ) ) {
			return false;
		}

		if ( ! parent::delete( $id ) ) {
			return false;
		}

		$_PLUGINS->trigger( 'activity_onAfterDeleteAction', array( $this ) );

		return true;
	}

	/**
	 * @return Registry
	 */
	public function params()
	{
		if ( ! ( $this->getRaw( '_params' ) instanceof Registry ) ) {
			$this->set( '_params', new Registry( $this->getRaw( 'params' ) ) );
		}

		return $this->getRaw( '_params' );
	}

	/**
	 * @return string
	 */
	public function icon()
	{
		global $_CB_framework;

		if ( Application::Application()->isClient( 'administrator' ) ) {
			CBActivity::getTemplate();
		}

		$actionClass			=	'streamIconAction streamIconAction' . ucfirst( strtolower( preg_replace( '/[^-a-zA-Z0-9_]/', '', $this->getString( 'value' ) ) ) );

		if ( $this->getString( 'class' ) ) {
			$actionClass		.=	' ' . $this->getString( 'class' );
		}

		if ( $this->getString( 'icon' ) ) {
			$template			=	CBActivity::getGlobalParams()->getString( 'general_template', 'default' );

			if ( ! $template ) {
				$template		=	'default';
			}

			$icon				=	'/components/com_comprofiler/plugin/user/plug_cbactivity/templates/' . $template . '/images/' . $this->getString( 'icon' );

			if ( ( $template !== 'default' ) && ( ! file_exists( $_CB_framework->getCfg( 'absolute_path' ) . $icon ) ) ) {
				$icon			=	'/components/com_comprofiler/plugin/user/plug_cbactivity/templates/default/images/' . $this->getString( 'icon' );
			}

			if ( ! file_exists( $_CB_framework->getCfg( 'absolute_path' ) . $icon ) ) {
				// Joomla images root fallback for B/C:
				$icon			=	'/images/' . $this->getString( 'icon' );
			}

			return '<img src="' . htmlspecialchars( $_CB_framework->getCfg( 'live_site' ) . $icon ) . '" loading="lazy" alt="' . htmlspecialchars( $this->getString( 'value' ) ) . '" class="img-fluid-inline align-text-bottom ' . htmlspecialchars( $actionClass ) . '" />';
		}

		return '<span class="' . htmlspecialchars( $actionClass ) . '"></span>';
	}
}