<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\Activity\Field;

use CB\Plugin\Activity\CBActivity;
use CBLib\Application\Application;
use CB\Database\Table\UserTable;
use CB\Database\Table\FieldTable;
use CB\Plugin\Activity\Notifications;

defined('CBLIB') or die();

class NotificationsField extends \cbFieldHandler
{

	/**
	 * Accessor:
	 * Returns a field in specified format
	 *
	 * @param  FieldTable  $field
	 * @param  UserTable   $user
	 * @param  string      $output               'html', 'xml', 'json', 'php', 'csvheader', 'csv', 'rss', 'fieldslist', 'htmledit'
	 * @param  string      $reason               'profile' for user profile view, 'edit' for profile edit, 'register' for registration, 'search' for searches
	 * @param  int         $list_compare_types   IF reason == 'search' : 0 : simple 'is' search, 1 : advanced search with modes, 2 : simple 'any' search
	 * @return mixed
	 */
	public function getField( &$field, &$user, $output, $reason, $list_compare_types )
	{
		if ( ( $output === 'htmledit' ) || ( Application::MyUser()->getUserId() !== $user->getInt( 'id', 0 ) ) ) {
			return null;
		}

		$notifications			=	new Notifications( str_replace( '[field_id]', $field->getInt( 'fieldid', 0 ), $field->params->getString( 'notifications_asset' ) ), $user );

		$notifications->parse( $field->getRaw( 'params' ), 'notifications_' );

		$notifications->set( 'field', $field->getInt( 'fieldid', 0 ) );

		$layout					=	$field->params->getString( 'notifications_layout', 'button' );

		switch ( $field->params->getString( 'notifications_state', 'unread' ) ) {
			case 'read':
				if ( in_array( $layout, array( 'button', 'toggle' ), true ) ) {
					$notifications->set( 'read', 'read' );
				} else {
					$notifications->set( 'read', 'readonly' );
				}
				break;
			case 'unread':
				if ( in_array( $layout, array( 'button', 'toggle' ), true ) ) {
					$notifications->set( 'read', 'unread' );
				} else {
					$notifications->set( 'read', 'unreadonly' );
				}
				break;
			case 'all':
				$notifications->set( 'read', 'status' );
				break;
		}

		if ( ( $output === 'html' ) && ( ( ( $reason === 'list' ) && ( $layout === 'button' ) ) || ( $reason !== 'list' ) ) && ( $layout !== 'count' ) ) {
			if ( in_array( $layout, array( 'button', 'toggle' ), true ) ) {
				$return			=	$notifications->notifications( 'button' );
			} else {
				if ( ( ! Application::Config()->getInt( 'showEmptyFields', 1 ) ) && ( ! $notifications->rows() ) ) {
					return null;
				}

				$return			=	$notifications->notifications();
			}

			if ( ! $return ) {
				return null;
			}

			return $this->formatFieldValueLayout( $this->_formatFieldOutput( $field->getString( 'name' ), $return, $output, false ), $reason, $field, $user );
		}

		$return				=	$this->_formatFieldOutput( $field->getString( 'name' ), CBActivity::prefetchAssets( 'notifications', array(), $notifications ), $output, false );

		if ( $output === 'html' ) {
			$return			=	$this->formatFieldValueLayout( $return, $reason, $field, $user );
		}

		return $return;
	}
}