<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Core\AutoLoader;
use CBLib\Application\Application;
use CB\Database\Table\UserTable;
use CB\Database\Table\TabTable;
use CBLib\Registry\Registry;
use CBLib\Registry\ParamsInterface;
use CB\Plugin\Activity\CBActivity;
use CB\Plugin\Activity\Activity;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

global $_PLUGINS;

AutoLoader::registerExactMap( '%^CB/Plugin/Activity/(.+)%i', __DIR__ . '/library/$1.php' );

$_PLUGINS->loadPluginGroup( 'user' );

$_PLUGINS->registerFunction( 'onAfterDeleteUser', 'deleteActivity', '\CB\Plugin\Activity\Trigger\UserTrigger' );

$_PLUGINS->registerFunction( 'mod_onCBAdminMenu', 'adminMenu', '\CB\Plugin\Activity\Trigger\AdminTrigger' );

$_PLUGINS->registerFunction( 'onAfterMenu', 'getNotifications','\CB\Plugin\Activity\Trigger\MenuTrigger' );

$_PLUGINS->registerFunction( 'activity_onLoadActivityStream', 'activityLoad', '\CB\Plugin\Activity\Trigger\ActivityTrigger' );
$_PLUGINS->registerFunction( 'activity_onLoadNotificationsStream', 'activityLoad', '\CB\Plugin\Activity\Trigger\ActivityTrigger' );
$_PLUGINS->registerFunction( 'activity_onAssetSource', 'assetSource', '\CB\Plugin\Activity\Trigger\ActivityTrigger' );

$_PLUGINS->registerUserFieldParams();
$_PLUGINS->registerUserFieldTypes( array(	'activity'			=>	'\CB\Plugin\Activity\Field\ActivityField',
											'notifications'		=>	'\CB\Plugin\Activity\Field\NotificationsField',
											'comments'			=>	'\CB\Plugin\Activity\Field\CommentsField',
											'follow'			=>	'\CB\Plugin\Activity\Field\FollowField',
											'like'				=>	'\CB\Plugin\Activity\Field\LikeField'
										));

class cbactivityTab extends cbTabHandler
{

	/**
	 * @param TabTable  $tab
	 * @param UserTable $user
	 * @param int       $ui
	 * @return null|string
	 */
	public function getDisplayTab( $tab, $user, $ui )
	{
		if ( ! ( $tab->getRaw( 'params' ) instanceof ParamsInterface ) ) {
			$tab->set( 'params', new Registry( $tab->getRaw( 'params' ) ) );
		}

		$asset				=	$tab->params->getString( 'activity_asset' );

		if ( ! $asset ) {
			if ( $user->getInt( 'id', 0 ) !== Application::MyUser()->getUserId() ) {
				$asset		=	array( 'user' );
			} else {
				$asset		=	null;
			}
		}

		$activity			=	new Activity( $asset, $user );

		$activity->parse( $tab->getRaw( 'params' ), 'activity_' );

		$activity->set( 'tab', $tab->getInt( 'tabid', 0 ) );

		$layout				=	$tab->params->getString( 'activity_layout', 'stream' );

		if ( $layout === 'button' ) {
			return $activity->activity( 'button' );
		}

		if ( ( ! Application::Config()->getInt( 'showEmptyTabs', 1 ) ) && ( ! CBActivity::canCreate( 'activity', $activity ) ) && ( ! $activity->rows() ) ) {
			return null;
		}

		return $this->_writeTabDescription( $tab, $user ) . $activity->activity();
	}
}