<?php
/**
 * Community Builder (TM)
 * @version $Id: $
 * @package CommunityBuilder
 * @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
 * @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
 */

namespace CB\Plugin\GroupJivePhoto\Trigger;

use CB\Plugin\GroupJivePhoto\Table\PhotoTable;
use CB\Database\Table\UserTable;

defined('CBLIB') or die();

class UserTrigger extends \cbPluginHandler
{

	/**
	 * Deletes data when a user is deleted
	 *
	 * @param  UserTable $user
	 * @param  int       $status
	 */
	public function deletePhotos( $user, $status )
	{
		global $_CB_database;

		if ( $this->params->getBool( 'groups_photo_delete', true ) ) {
			$query		=	'SELECT *'
						.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_plugin_photo' )
						.	"\n WHERE " . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 );
			$_CB_database->setQuery( $query );
			$photos		=	$_CB_database->loadObjectList( null, '\CB\Plugin\GroupJivePhoto\Table\PhotoTable', array( $_CB_database ) );

			/** @var PhotoTable[] $photos */
			foreach ( $photos as $photo ) {
				$photo->delete();
			}
		}
	}
}