<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Database\Table\TabTable;
use CB\Plugin\GroupJive\CBGroupJive;
use CB\Plugin\GroupJivePhoto\CBGroupJivePhoto;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

global $_PLUGINS;

$_PLUGINS->loadPluginGroup( 'user' );

class CBplug_cbgroupjivephoto extends cbPluginHandler
{

	/**
	 * @param  TabTable   $tab       Current tab
	 * @param  UserTable  $user      Current user
	 * @param  int        $ui        1 front, 2 admin UI
	 * @param  array      $postdata  Raw unfiltred POST data
	 */
	public function getCBpluginComponent( $tab, $user, $ui, $postdata )
	{
		$format					=	$this->getInput()->getString( 'format' );

		if ( $format !== 'raw' ) {
			outputCbJs();
			outputCbTemplate();
		}

		$action					=	$this->getInput()->getString( 'action' );
		$function				=	$this->getInput()->getString( 'func' );
		$id						=	$this->getInput()->getInt( 'id', 0 );

		if ( $user === null ) {
			$user				=	CBuser::getMyUserDataInstance();
		}

		if ( $format !== 'raw' ) {
			ob_start();
		}

		if ( $action === 'photo' ) {
			switch ( $function ) {
				case 'preview':
					$this->outputPhoto( true, true, $id, $user );
					break;
				case 'download':
					$this->outputPhoto( false, false, $id, $user );
					break;
				case 'publish':
					$this->statePhoto( 1, $id, $user );
					break;
				case 'unpublish':
					$this->statePhoto( 0, $id, $user );
					break;
				case 'delete':
					$this->deletePhoto( $id, $user );
					break;
				case 'new':
					$this->showPhotoEdit( null, $user );
					break;
				case 'edit':
					$this->showPhotoEdit( $id, $user );
					break;
				case 'save':
					cbSpoofCheck( 'plugin' );
					$this->savePhotoEdit( $id, $user );
					break;
				case 'show':
				default:
					$this->outputPhoto( true, false, $id, $user );
					break;
			}
		}

		if ( $format !== 'raw' ) {
			$html				=	ob_get_clean();

			$gjClass			=	CBGroupJive::getGlobalParams()->getString( 'general_class' );

			$return				=	'<div class="cbGroupJive' . ( $gjClass ? ' ' . htmlspecialchars( $gjClass ) : null ) . '">'
								.		$html
								.	'</div>';

			echo $return;
		}
	}

	/**
	 * prepare frontend photo edit render
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function showPhotoEdit( $id, $user )
	{
		global $_CB_framework;

		$row							=	CBGroupJivePhoto::getPhoto( (int) $id );
		$isModerator					=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$groupId						=	$this->getInput()->getInt( 'group' );

		if ( $groupId === null ) {
			$group						=	$row->group();
		} else {
			$group						=	CBGroupJive::getGroup( $groupId );
		}

		$returnUrl						=	$_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) );

		if ( ! CBGroupJive::canAccessGroup( $group, $user ) ) {
			cbRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
		} elseif ( ! $isModerator ) {
			if ( ( ! $row->getInt( 'id', 0 ) ) && ( ! CBGroupJive::canCreateGroupContent( $user, $group, 'photo' ) ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to upload a photo in this group.' ), 'error' );
			} elseif ( $row->getInt( 'id', 0 )
					   && ( CBGroupJive::getGroupStatus( $user, $group ) < 2 )
					   && ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) )
			) {
				cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to edit this photo.' ), 'error' );
			}
		}

		CBGroupJive::getTemplate( 'photo_edit', true, true, $this->element );

		$minFileSize					=	$this->params->getInt( 'groups_photo_min_size', 0 );
		$maxFileSize					=	$this->params->getInt( 'groups_photo_max_size', 1024 );
		$extensions						=	array( 'jpg', 'jpeg', 'gif', 'png' );

		$imageValidation				=	array();

		if ( $minFileSize || $maxFileSize ) {
			$imageValidation[]			=	cbValidator::getRuleHtmlAttributes( 'filesize', array( $minFileSize, $maxFileSize, 'KB' ) );
		}

		if ( $extensions ) {
			$imageValidation[]			=	cbValidator::getRuleHtmlAttributes( 'extension', implode( ',', $extensions ) );
		}

		$input							=	array();

		$publishedTooltip				=	cbTooltip( null, CBTxt::T( 'Select publish state of this photo. Unpublished photos will not be visible to the public.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['published']				=	moscomprofilerHTML::yesnoButtonList( 'published', $publishedTooltip, $this->getInput()->getInt( 'post/published', $row->getInt( 'published', 1 ) ) );

		$titleTooltup					=	cbTooltip( null, CBTxt::T( 'Optionally input a photo title to display instead of filename.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['title']					=	'<input type="text" id="title" name="title" value="' . htmlspecialchars( $this->getInput()->getString( 'post/title', $row->getString( 'title' ) ) ) . '" class="form-control" size="35"' . $titleTooltup . ' />';

		$imageTooltip					=	cbTooltip( null, CBTxt::T( 'Select the photo to upload.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['image']					=	'<input type="file" id="image" name="image" value="" class="form-control' . ( ! $row->getInt( 'id', 0 ) ? ' required' : null ) . '"' . $imageTooltip . ( $imageValidation ? implode( ' ', $imageValidation ) : null ) . ' />';

		$input['image_limits']			=	array();

		if ( $extensions ) {
			$input['image_limits'][]	=	CBTxt::T( 'GROUP_PHOTO_LIMITS_EXT', 'Your photo must be of [ext] type.', array( '[ext]' => implode( ', ', $extensions ) ) );
		}

		if ( $minFileSize ) {
			$input['image_limits'][]	=	CBTxt::T( 'GROUP_PHOTO_LIMITS_MIN', 'Your photo should exceed [size].', array( '[size]' => CBGroupJive::getFormattedFileSize( $minFileSize * 1024 ) ) );
		}

		if ( $maxFileSize ) {
			$input['image_limits'][]	=	CBTxt::T( 'GROUP_PHOTO_LIMITS_MAX', 'Your photo should not exceed [size].', array( '[size]' => CBGroupJive::getFormattedFileSize( $maxFileSize * 1024 ) ) );
		}

		$descriptionTooltip				=	cbTooltip( null, CBTxt::T( 'Optionally input a photo description.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['description']			=	'<textarea id="description" name="description" class="form-control" cols="40" rows="5"' . $descriptionTooltip . '>' . htmlspecialchars( $this->getInput()->getString( 'post/description', $row->getString( 'description' ) ) ) . '</textarea>';

		$ownerTooltip					=	cbTooltip( null, CBTxt::T( 'Input the photo owner id. Photo owner determines the creator of the photo specified as User ID.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['user_id']				=	'<input type="text" id="user_id" name="user_id" value="' . $this->getInput()->getInt( 'post/user_id', $this->getInput()->getInt( 'user', $row->getInt( 'user_id', $user->getInt( 'id', 0 ) ) ) ) . '" class="digits required form-control" size="6"' . $ownerTooltip . ' />';

		HTML_groupjivePhotoEdit::showPhotoEdit( $row, $input, $group, $user, $this );
	}

	/**
	 * save photo
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function savePhotoEdit( $id, $user )
	{
		global $_CB_framework, $_PLUGINS;

		$row					=	CBGroupJivePhoto::getPhoto( (int) $id );
		$isModerator			=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$groupId				=	$this->getInput()->getInt( 'group' );

		if ( $groupId === null ) {
			$group				=	$row->group();
		} else {
			$group				=	CBGroupJive::getGroup( $groupId );
		}

		$returnUrl				=	$_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) );

		if ( ! CBGroupJive::canAccessGroup( $group, $user ) ) {
			cbRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
		} elseif ( ! $isModerator ) {
			if ( ( ! $row->getInt( 'id', 0 ) ) && ( ! CBGroupJive::canCreateGroupContent( $user, $group, 'photo' ) ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to upload a photo in this group.' ), 'error' );
			} elseif ( $row->getInt( 'id', 0 )
					   && ( CBGroupJive::getGroupStatus( $user, $group ) < 2 )
					   && ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) )
			) {
				cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to edit this photo.' ), 'error' );
			}
		}

		if ( $isModerator ) {
			$row->set( 'user_id', $this->getInput()->getInt( 'post/user_id', $row->getInt( 'user_id', $user->getInt( 'id', 0 ) ) ) );
		} else {
			$row->set( 'user_id', $row->getInt( 'user_id', $user->getInt( 'id', 0 ) ) );
		}

		$canModerate			=	( CBGroupJive::getGroupStatus( $user, $group ) >= 2 );

		$row->set( 'published', ( $isModerator || $canModerate || ( $row->getInt( 'id', 0 ) && ( $row->getInt( 'published', 0 ) !== -1 ) ) || ( $group->params()->getInt( 'photo', 1 ) !== 2 ) ? $this->getInput()->getInt( 'post/published', $row->getInt( 'published', 1 ) ) : -1 ) );
		$row->set( 'group', $group->getInt( 'id', 0 ) );
		$row->set( 'title', $this->getInput()->getString( 'post/title', $row->getString( 'title' ) ) );
		$row->set( 'description', $this->getInput()->getString( 'post/description', $row->getString( 'description' ) ) );

		if ( ( ! $isModerator ) && $this->params->getInt( 'groups_photo_captcha', 0 ) ) {
			$_PLUGINS->loadPluginGroup( 'user' );

			$_PLUGINS->trigger( 'onCheckCaptchaHtmlElements', array() );

			if ( $_PLUGINS->is_errors() ) {
				$row->setError( $_PLUGINS->getErrorMSG() );
			}
		}

		$new					=	( ! $row->getInt( 'id', 0 ) );

		if ( $row->getError() || ( ! $row->check() ) ) {
			$_CB_framework->enqueueMessage( CBTxt::T( 'GROUP_PHOTO_FAILED_TO_SAVE', 'Photo failed to save! Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );

			$this->showPhotoEdit( $id, $user );
			return;
		}

		if ( $row->getError() || ( ! $row->store() ) ) {
			$_CB_framework->enqueueMessage( CBTxt::T( 'GROUP_PHOTO_FAILED_TO_SAVE', 'Photo failed to save! Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );

			$this->showPhotoEdit( $id, $user );
			return;
		}

		if ( $new ) {
			$extras				=	array(	'photo_id'			=>	$row->getInt( 'id', 0 ),
											'photo_title'		=>	htmlspecialchars( ( $row->getString( 'title' ) ? $row->getString( 'title' ) : $row->name() ) ),
											'photo_description'	=>	htmlspecialchars( $row->getString( 'description' ) ),
											'photo_size'		=>	$row->size(),
											'photo_type'		=>	$row->mimeType(),
											'photo_extension'	=>	$row->extension(),
											'photo_url'			=>	$_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'photo', 'func' => 'show', 'id' => $row->getInt( 'id', 0 ) ), 'raw', 0, true ),
											'photo_date'		=>	cbFormatDate( $row->getString( 'date' ), true, false, CBTxt::T( 'GROUP_PHOTO_DATE_FORMAT', 'M j, Y' ) ),
											'photo'				=>	'<a href="' . $_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->getInt( 'group', 0 ), 'tab' => 'grouptabphoto' ) ) . '">' . htmlspecialchars( ( $row->getString( 'title' ) ? $row->getString( 'title' ) : $row->name() ) ) . '</a>' );

			if ( $row->getInt( 'published', 0 ) === 1 ) {
				CBGroupJive::sendNotifications( 'photo_new', CBTxt::T( 'New group photo' ), CBTxt::T( '[user] has uploaded the photo [photo] in the group [group]!' ), $row->group(), $row->getInt( 'user_id', 0 ), null, array( $user->getInt( 'id', 0 ) ), 1, $extras );
			} elseif ( ( $row->getInt( 'published', 0 ) === -1 ) && ( $row->group()->params()->getInt( 'photo', 1 ) === 2 ) ) {
				CBGroupJive::sendNotifications( 'photo_approve', CBTxt::T( 'New group photo awaiting approval' ), CBTxt::T( '[user] has uploaded the photo [photo] in the group [group] and is awaiting approval!' ), $row->group(), $row->getInt( 'user_id', 0 ), null, array( $user->getInt( 'id', 0 ) ), 2, $extras );

				cbRedirect( $returnUrl, CBTxt::T( 'Photo uploaded successfully and awaiting approval!' ) );
			}

			cbRedirect( $returnUrl, CBTxt::T( 'Photo uploaded successfully!' ) );
		} else {
			cbRedirect( $returnUrl, CBTxt::T( 'Photo saved successfully!' ) );
		}
	}

	/**
	 * set photo publish state status
	 *
	 * @param int       $state
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function statePhoto( $state, $id, $user )
	{
		global $_CB_framework;

		$row				=	CBGroupJivePhoto::getPhoto( (int) $id );
		$returnUrl			=	$_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->getInt( 'group', 0 ) ) );

		if ( $row->getInt( 'id', 0 ) ) {
			if ( ! CBGroupJive::canAccessGroup( $row->group(), $user ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
			} elseif ( ! CBGroupJive::isModerator( $user->getInt( 'id', 0 ) ) ) {
				if ( CBGroupJive::getGroupStatus( $user, $row->group() ) < 2 ) {
					if ( ( $row->getInt( 'published', 0 ) === -1 )
						 && ( $user->getInt( 'id', 0 ) === $row->getInt( 'user_id', 0 ) )
						 && ( $row->group()->params()->getInt( 'photo', 1 ) === 2 )
					) {
						cbRedirect( $returnUrl, CBTxt::T( 'Your photo is awaiting approval.' ), 'error' );
					} elseif ( ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) ) ) {
						cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to publish or unpublish this photo.' ), 'error' );
					}
				}
			}
		} else {
			cbRedirect( $returnUrl, CBTxt::T( 'Photo does not exist.' ), 'error' );
		}

		$currentState		=	$row->getInt( 'published', 0 );

		$row->set( 'published', (int) $state );

		if ( $row->getError() || ( ! $row->store() ) ) {
			cbRedirect( $returnUrl, CBTxt::T( 'GROUP_PHOTO_STATE_FAILED_TO_SAVE', 'Photo state failed to saved. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		if ( $state && ( $currentState === -1 ) ) {
			$extras			=	array(	'photo_id'			=>	$row->getInt( 'id', 0 ),
										'photo_title'		=>	htmlspecialchars( ( $row->getString( 'title' ) ? $row->getString( 'title' ) : $row->name() ) ),
										'photo_description'	=>	htmlspecialchars( $row->getString( 'description' ) ),
										'photo_size'		=>	$row->size(),
										'photo_type'		=>	$row->mimeType(),
										'photo_extension'	=>	$row->extension(),
										'photo_url'			=>	$_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'photo', 'func' => 'show', 'id' => $row->getInt( 'id', 0 ) ), 'raw', 0, true ),
										'photo_date'		=>	cbFormatDate( $row->getString( 'date' ), true, false, CBTxt::T( 'GROUP_PHOTO_DATE_FORMAT', 'M j, Y' ) ),
										'photo'				=>	'<a href="' . $_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->getInt( 'group', 0 ), 'tab' => 'grouptabphoto' ) ) . '">' . htmlspecialchars( ( $row->getString( 'title' ) ? $row->getString( 'title' ) : $row->name() ) ) . '</a>' );

			if ( $row->getInt( 'user_id', 0 ) !== $user->getInt( 'id', 0 ) ) {
				CBGroupJive::sendNotification( 'photo_approved', 4, $user, $row->getInt( 'user_id', 0 ), CBTxt::T( 'Photo upload request accepted' ), CBTxt::T( 'Your photo [photo] upload request in the group [group] has been accepted!' ), $row->group(), $extras );
			}

			CBGroupJive::sendNotifications( 'photo_new', CBTxt::T( 'New group photo' ), CBTxt::T( '[user] has uploaded the photo [photo] in the group [group]!' ), $row->group(), $row->getInt( 'user_id', 0 ), null, array( $user->getInt( 'id', 0 ) ), 1, $extras );
		}

		cbRedirect( $returnUrl, CBTxt::T( 'Photo state saved successfully!' ) );
	}

	/**
	 * delete photo
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function deletePhoto( $id, $user )
	{
		global $_CB_framework;

		$row			=	CBGroupJivePhoto::getPhoto( (int) $id );
		$returnUrl		=	$_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->getInt( 'group', 0 ) ) );

		if ( $row->getInt( 'id', 0 ) ) {
			if ( ! CBGroupJive::canAccessGroup( $row->group(), $user ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
			} elseif ( ! CBGroupJive::isModerator( $user->getInt( 'id', 0 ) ) ) {
				if ( ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) ) && ( CBGroupJive::getGroupStatus( $user, $row->group() ) < 2 ) ) {
					cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to delete this photo.' ), 'error' );
				}
			}
		} else {
			cbRedirect( $returnUrl, CBTxt::T( 'Photo does not exist.' ), 'error' );
		}

		if ( ! $row->canDelete() ) {
			cbRedirect( $returnUrl, CBTxt::T( 'GROUP_PHOTO_FAILED_TO_DELETE', 'Photo failed to delete. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		if ( ! $row->delete() ) {
			cbRedirect( $returnUrl, CBTxt::T( 'GROUP_PHOTO_FAILED_TO_DELETE', 'Photo failed to delete. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		cbRedirect( $returnUrl, CBTxt::T( 'Photo deleted successfully!' ) );
	}

	/**
	 * output photo
	 *
	 * @param bool      $preview
	 * @param bool      $thumbnail
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function outputPhoto( $preview, $thumbnail, $id, $user )
	{
		$row	=	CBGroupJivePhoto::getPhoto( (int) $id );

		if ( $row->getInt( 'id', 0 ) ) {
			if ( ! CBGroupJive::canAccessGroup( $row->group(), $user ) ) {
				header( 'HTTP/1.0 404 Not Found' );
				exit();
			}

			if ( ( $row->getInt( 'published', 0 ) !== 1 )
				 && ( ! CBGroupJive::isModerator( $user->getInt( 'id', 0 ) ) )
				 && ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) )
				 && ( CBGroupJive::getGroupStatus( $user, $row->group() ) < 2 )
			) {
				header( 'HTTP/1.0 404 Not Found' );
				exit();
			}
		} else {
			header( 'HTTP/1.0 404 Not Found' );
			exit();
		}

		if ( $preview ) {
			$row->preview( $thumbnail );
		} else {
			$row->download();
		}
	}
}