<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C)2005-2015 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\UserTable;
use CB\Database\Table\TabTable;
use CB\Plugin\ProfileBook\Table\EntryTable;
use CBLib\Language\CBTxt;
use CBLib\Registry\GetterInterface;
use CB\Plugin\ProfileBook\CBProfileBook;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var bool         $isOwner
 * @var bool         $isModerator
 * @var bool         $canModerate
 * @var bool         $requireApproval
 * @var UserTable    $user
 * @var UserTable    $viewer
 * @var TabTable     $tab
 * @var EntryTable[] $rows
 * @var cbPageNav    $pageNav
 */

global $_CB_framework, $_PLUGINS;

cbValidator::loadValidation();
initToolTip();

$js					=	"$( '.pbGuestbookNew:not(.pbGuestbookNewOpen)' ).on( 'click', function() {"
					.		"$( this ).find( '.pbGuestbookNewFooter,.pbGuestbookInputGroup' ).removeClass( 'hidden' );"
					.		"$( this ).addClass( 'pbGuestbookNewOpen' );"
					.		"$( this ).find( 'textarea' ).attr( 'rows', 3 ).autosize({"
					.			"append: '',"
					.			"resizeDelay: 0,"
					.			"placeholder: false"
					.		"});"
					.	"});"
					.	"$( '.pbGuestbookNewFeedback:not(.pbGuestbookNewFeedbackOpen)' ).on( 'click', function() {"
					.		"$( this ).find( '.pbGuestbookNewFeedbackFooter,.pbGuestbookInputGroup' ).removeClass( 'hidden' );"
					.		"$( this ).addClass( 'pbGuestbookNewFeedbackOpen' );"
					.		"$( this ).find( 'textarea' ).autosize({"
					.			"append: '',"
					.			"resizeDelay: 0,"
					.			"placeholder: false"
					.		"});"
					.	"});"
					.	"$( '.pbGuestbook .cbMoreLess' ).cbmoreless({ height: 400, tolerance: 400 });"
					.	"$( '.pbGuestbook .rateit' ).rateit();";

$_CB_framework->outputCbJQuery( $js, array( 'cbmoreless', 'autosize', 'rateit' ) );

$showCaptcha		=	$tab->params->get( 'pbCaptcha', 1, GetterInterface::INT );

if ( $isModerator || ( ( $showCaptcha == 1 ) && $viewer->get( 'id', 0, GetterInterface::INT ) ) ) {
	$showCaptcha	=	0;
}

if ( $showCaptcha ) {
	$showCaptcha	=	implode( '', $_PLUGINS->trigger( 'onGetCaptchaHtmlElements', array( true ) ) );
}

$showRatings		=	$tab->params->get( 'pbEnableRating', 2, GetterInterface::INT );
$cbUserOwner		=	CBuser::getInstance( $user->get( 'id', 0, GetterInterface::INT ), false );
?>
<div class="pbGuestbook">
	<?php echo implode( '', $_PLUGINS->trigger( 'pb_onBeforeDisplayGuestbook', array( &$rows, &$pageNav, $viewer, $user, $tab ) ) ); ?>
	<div class="pbGuestbookRows">
		<?php if ( ( ! $isOwner ) && ( $isModerator || $viewer->get( 'id', 0, GetterInterface::INT ) || ( ( ! $viewer->get( 'id', 0, GetterInterface::INT ) ) && $tab->params->get( 'pbAllowAnony', false, GetterInterface::BOOLEAN ) ) ) ) { ?>
		<div class="card mb-3 pbGuestbookRow pbGuestbookNew">
			<form action="<?php echo $_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'entry', 'func' => 'save' ) ); ?>" method="post" name="pbGuestbookFormNew" class="m-0 pbGuestbookForm cbValidation">
				<div class="card-body p-0 pbGuestbookNewBody">
					<div class="cb_form_line pbGuestbookInputGroup pbGuestbookInputMessageContainer">
						<textarea name="postercomment" rows="1" class="form-control shadow-none border-0 pbGuestbookInput pbGuestbookInputMessage required" placeholder="<?php echo htmlspecialchars( CBTxt::T( 'Would you like to sign this guestbook?' ) ); ?>"></textarea>
					</div>
					<?php if ( ! $viewer->get( 'id', 0, GetterInterface::INT ) ) { ?>
					<div class="border-top d-flex cb_form_line pbGuestbookInputGroup pbGuestbookInputNameContainer hidden">
						<div class="d-none d-sm-block col-form-label flex-shrink-1 p-2 border-right pbGuestbookInputGroupLabel"><?php echo CBTxt::T( 'Name' ); ?></div>
						<div class="flex-grow-1 pbGuestbookInputGroupInput">
							<input type="text" name="postername" class="form-control shadow-none border-0 h-100 w-100 pbGuestbookInput pbGuestbookInputName required" placeholder="<?php echo htmlspecialchars( CBTxt::T( 'Please provide your name.' ) ); ?>" />
						</div>
					</div>
					<div class="border-top d-flex cb_form_line pbGuestbookInputGroup pbGuestbookInputNameContainer hidden">
						<div class="d-none d-sm-block col-form-label flex-shrink-1 p-2 border-right pbGuestbookInputGroupLabel"><?php echo CBTxt::T( 'Email' ); ?></div>
						<div class="flex-grow-1 pbGuestbookInputGroupInput">
							<input type="text" name="posteremail" class="form-control shadow-none border-0 h-100 w-100 pbGuestbookInput pbGuestbookInputEmail required email" placeholder="<?php echo htmlspecialchars( CBTxt::T( 'Please provide your email address.' ) ); ?>" />
						</div>
					</div>
					<?php } ?>
					<?php if ( $showRatings ) { ?>
					<div class="border-top d-flex cb_form_line pbGuestbookInputGroup pbGuestbookInputNameContainer hidden">
						<div class="col-form-label flex-shrink-1 p-2 border-right pbGuestbookInputGroupLabel"><?php echo CBTxt::T( 'Rate' ); ?></div>
						<div class="flex-grow-1 p-2 pbGuestbookInputGroupInput">
							<input type="text" id="pbGuestbookRatingNew" name="postervote" value="0"<?php echo ( $showRatings == 3 ? ' class="required"' . cbValidator::getRuleHtmlAttributes( 'range', array( 1, 5 ) ) : null ); ?> />
							<div class="rateit pbGuestbookInput pbGuestbookInputRating" data-rateit-backingfld="#pbGuestbookRatingNew" data-rateit-step="1" data-rateit-value="0" data-rateit-ispreset="true" data-rateit-resetable="<?php echo ( $showRatings == 3 ? 'false' : 'true' ); ?>" data-rateit-min="0" data-rateit-max="5" data-rateit-mode="font"></div>
						</div>
					</div>
					<?php } ?>
					<?php if ( $showCaptcha ) { ?>
					<div class="border-top d-flex cb_form_line pbGuestbookInputGroup pbGuestbookInputNameContainer hidden">
						<div class="col-form-label flex-shrink-1 p-2 border-right pbGuestbookInputGroupLabel"><?php echo CBTxt::T( 'Captcha' ); ?></div>
						<div class="flex-grow-1 p-2 pbGuestbookInputGroupInput">
							<?php echo $showCaptcha; ?>
						</div>
					</div>
					<?php } ?>
				</div>
				<div class="card-footer p-2 text-right pbGuestbookNewFooter hidden">
					<button type="submit" class="btn btn-primary btn-sm btn-sm-block pbButton pbButtonSubmit" <?php echo cbValidator::getSubmitBtnHtmlAttributes(); ?>><?php echo CBTxt::T( 'Sign Guestbook' ); ?></button>
				</div>
				<input type="hidden" name="mode" value="g" />
				<input type="hidden" name="userid" value="<?php echo $user->get( 'id', 0, GetterInterface::INT ); ?>" />
				<?php echo cbGetSpoofInputTag( 'plugin' ); ?>
			</form>
		</div>
		<?php } ?>
		<?php
		if ( $rows ) foreach ( $rows as $row ) {
			$integrations					=	implode( '', $_PLUGINS->trigger( 'pb_onDisplayGuestbook', array( &$row, $viewer, $user, $tab ) ) );
			$rowOwner						=	( $viewer->get( 'id', 0, GetterInterface::INT ) && ( $viewer->get( 'id', 0, GetterInterface::INT ) == $row->get( 'posterid', 0, GetterInterface::INT ) ) );
			$needsApproval					=	( ( $row->getInt( 'published' ) === -1 ) && $requireApproval );
			$cbUser							=	CBuser::getInstance( $row->get( 'posterid', 0, GetterInterface::INT ), false );
			$feedback						=	$row->get( 'feedback', null, GetterInterface::HTML );
			$menu							=	null;

			if ( $isModerator || ( $isOwner && ( $canModerate || $needsApproval ) ) || $rowOwner ) {
				$menuItems					=	'<ul class="list-unstyled dropdown-menu d-block position-relative m-0 pbGuestbookMenuItems">';

				if ( $isModerator || ( $isOwner && $canModerate ) || $rowOwner ) {
					$menuItems				.=		'<li class="pbGuestbookMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'entry', 'func' => 'edit', 'id' => $row->get( 'id', 0, GetterInterface::INT ) ) ) . '" class="dropdown-item"><span class="fa fa-edit"></span> ' . CBTxt::T( 'Edit' ) . '</a></li>';
				}

				if ( $isModerator || ( $isOwner && ( $canModerate || $needsApproval ) ) ) {
					if ( $row->get( 'published' ) == -1 ) {
						$menuItems			.=		'<li class="pbGuestbookMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'entry', 'func' => 'publish', 'id' => $row->get( 'id', 0, GetterInterface::INT ) ) ) . '" class="dropdown-item"><span class="fa fa-check"></span> ' . CBTxt::T( 'Approve' ) . '</a></li>';
					} elseif ( $row->get( 'published' ) == 1 ) {
						$menuItems			.=		'<li class="pbGuestbookMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to unpublish this guestbook signature?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'entry', 'func' => 'unpublish', 'id' => $row->get( 'id', 0, GetterInterface::INT ) ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-times-circle"></span> ' . CBTxt::T( 'Unpublish' ) . '</a></li>';
					} else {
						$menuItems			.=		'<li class="pbGuestbookMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'entry', 'func' => 'publish', 'id' => $row->get( 'id', 0, GetterInterface::INT ) ) ) . '" class="dropdown-item"><span class="fa fa-check"></span> ' . CBTxt::T( 'Publish' ) . '</a></li>';
					}
				}

				if ( $isModerator || ( $isOwner && $canModerate ) || $rowOwner ) {
					$menuItems				.=		'<li class="pbGuestbookMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to delete this guestbook signature?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'entry', 'func' => 'delete', 'id' => $row->get( 'id', 0, GetterInterface::INT ) ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-trash-o"></span> ' . CBTxt::T( 'Delete' ) . '</a></li>';
				}

				$menuItems					.=	'</ul>';

				$menu						=	cbTooltip( null, $menuItems, null, 'auto', null, '<span class="pt-1 pb-1 pl-3 pr-3 text-large fa fa-ellipsis-v"></span>', 'javascript:void(0);', 'class="text-body cbDropdownMenu pbGuestbookMenuToggle" data-cbtooltip-menu="true" data-cbtooltip-classes="qtip-nostyle" data-cbtooltip-open-classes="active"' );
			}

			$feedbackMenu					=	null;

			if ( $feedback && ( $isOwner || $isModerator ) ) {
				$menuItems					=	'<ul class="list-unstyled dropdown-menu d-block position-relative m-0 pbGuestbookMenuItems">'
											.		'<li class="pbGuestbookMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'feedback', 'func' => 'edit', 'id' => $row->get( 'id', 0, GetterInterface::INT ) ) ) . '" class="dropdown-item"><span class="fa fa-edit"></span> ' . CBTxt::T( 'Edit' ) . '</a></li>'
											.		'<li class="pbGuestbookMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to delete this feedback?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'feedback', 'func' => 'delete', 'id' => $row->get( 'id', 0, GetterInterface::INT ) ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-trash-o"></span> ' . CBTxt::T( 'Delete' ) . '</a></li>'
											.	'</ul>';

				$feedbackMenu				=	cbTooltip( null, $menuItems, null, 'auto', null, '<span class="pt-1 pb-1 pl-3 pr-3 text-large fa fa-ellipsis-v"></span>', 'javascript:void(0);', 'class="text-body cbDropdownMenu pbGuestbookMenuToggle" data-cbtooltip-menu="true" data-cbtooltip-classes="qtip-nostyle" data-cbtooltip-open-classes="active"' );
			}
		?>
		<div class="card mb-3 pbGuestbookRow">
			<div class="media card-header p-2 bg-transparent border-0 pbGuestbookRowHeader">
				<div class="media-left pbGuestbookRowAvatar">
				<?php
				if ( ! $row->get( 'posterid', 0, GetterInterface::INT ) ) {
					echo CBProfileBook::getAnonAvatar( $row->get( 'postername', CBTxt::T( 'Anonymous' ), GetterInterface::STRING ) );
				} else {
					echo $cbUser->getField( 'avatar', null, 'html', 'none', 'list', 0, true );
				}
				?>
				</div>
				<div class="media-body pl-2 pr-5 pbGuestbookRowDetails">
					<div class="text-muted pbGuestbookRowAuthor">
						<strong>
						<?php
						if ( ! $row->get( 'posterid', 0, GetterInterface::INT ) ) {
							echo $row->get( 'postername', CBTxt::T( 'Anonymous' ), GetterInterface::STRING );
						} else {
							echo $cbUser->getField( 'formatname', null, 'html', 'none', 'list', 0, true );
						}
						?>
						</strong>
					</div>
					<div class="text-small text-muted pbGuestbookRowDate">
						<?php echo cbFormatDate( $row->get( 'date', null, GetterInterface::STRING ), true, 'timeago' ); ?>
						<?php if ( $row->get( 'editdate', null, GetterInterface::STRING ) && ( $row->get( 'editdate', null, GetterInterface::STRING ) != '0000-00-00 00:00:00' ) ) { ?>
							<span class="fa fa-edit align-middle pbGuestbookRowEdited" title="<?php echo htmlspecialchars( cbFormatDate( $row->get( 'editdate', null, GetterInterface::STRING ) ) ); ?>"></span>
						<?php } ?>
					</div>
				</div>
			</div>
			<div class="card-body pt-0 pl-2 pr-2 pb-2 pbGuestbookRowMessage">
				<div class="cbMoreLess">
					<div class="cbMoreLessContent">
						<?php echo CBProfileBook::parseMessage( $row->get( 'postercomment', null, GetterInterface::HTML ), $tab ); ?>
					</div>
					<div class="fade-edge cbMoreLessOpen hidden">
						<a href="javascript: void(0);" class="pl-1 cbMoreLessButton"><?php echo CBTxt::T( 'See More' ); ?></a>
					</div>
				</div>
			</div>
			<?php if ( ( ( ! $rowOwner ) && ( $isOwner || $isModerator ) ) || $feedback ) { ?>
			<div class="card-footer p-2 pbGuestbookRowFooter">
				<div class="pbGuestbookFeedback">
					<div class="pbGuestbookRows">
						<?php if ( $feedback ) { ?>
						<div class="position-relative pbGuestbookRow">
							<div class="media pbGuestbookRowHeader">
								<div class="media-left pbGuestbookRowAvatar">
									<?php echo $cbUserOwner->getField( 'avatar', null, 'html', 'none', 'list', 0, true ); ?>
								</div>
								<div class="media-body pl-2 pr-5 pbGuestbookRowDetails">
									<div class="cbMoreLess">
										<div class="cbMoreLessContent">
											<strong> <?php echo $cbUserOwner->getField( 'formatname', null, 'html', 'none', 'list', 0, true ); ?> </strong>
											<?php echo CBProfileBook::parseMessage( $feedback, $tab ); ?>
										</div>
										<div class="fade-edge cbMoreLessOpen hidden">
											<a href="javascript: void(0);" class="pl-1 cbMoreLessButton"><?php echo CBTxt::T( 'See More' ); ?></a>
										</div>
									</div>
								</div>
							</div>
							<?php if ( ( ! $rowOwner ) && ( $isOwner || $isModerator ) ) { ?>
							<div class="mr-n2 pbGuestbookMenu">
								<?php echo $feedbackMenu; ?>
							</div>
							<?php } ?>
						</div>
						<?php } else { ?>
						<div class="pbGuestbookRow pbGuestbookNewFeedback<?php echo ( $feedback ? ' hidden' : null ); ?>">
							<form action="<?php echo $_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'feedback', 'func' => 'save', 'id' => $row->get( 'id', 0, GetterInterface::INT ) ) ); ?>" method="post" name="pbGuestbookFormNew" class="m-0 pbGuestbookForm cbValidation">
								<div class="cb_form_line pbGuestbookInputGroup pbGuestbookInputFeedbackContainer">
									<textarea name="feedback" rows="1" class="form-control shadow-none pbGuestbookInput pbGuestbookInputFeedback required" placeholder="<?php echo htmlspecialchars( CBTxt::T( 'Write feedback...' ) ); ?>"><?php echo htmlspecialchars( $feedback ); ?></textarea>
								</div>
								<div class="text-right mt-2 pbGuestbookNewFeedbackFooter hidden">
									<button type="submit" class="btn btn-primary btn-sm btn-sm-block pbButton pbButtonSubmit" <?php echo cbValidator::getSubmitBtnHtmlAttributes(); ?>><?php echo CBTxt::T( 'Save Feedback' ); ?></button>
								</div>
								<?php echo cbGetSpoofInputTag( 'plugin' ); ?>
							</form>
						</div>
						<?php } ?>
					</div>
				</div>
			</div>
			<?php } ?>
			<?php if ( $integrations ) { ?>
			<div class="card-footer p-2 pbGuestbookRowIntegrations">
				<?php echo $integrations; ?>
			</div>
			<?php } ?>
			<?php if ( $menu || ( $row->get( 'postervote', 0, GetterInterface::INT ) && $showRatings ) || ( ( ! $row->get( 'status', 0, GetterInterface::INT ) ) && $isOwner ) ) { ?>
			<div class="pt-2 text-right pbGuestbookMenu">
				<?php if ( ( ! $row->get( 'status', 0, GetterInterface::INT ) ) && $isOwner ) { ?>
					<span class="pr-2 d-none d-sm-inline-block badge badge-success text-normal pbGuestbookRowNew"><?php echo CBTxt::T( 'New' ); ?></span>
				<?php } ?>
				<?php if ( $row->get( 'postervote', 0, GetterInterface::INT ) && $showRatings ) { ?>
				<div class="pr-2 d-inline-block pbGuestbookRowRating">
					<div class="rateit" data-rateit-step="1" data-rateit-value="<?php echo $row->get( 'postervote', 0, GetterInterface::INT ); ?>" data-rateit-ispreset="true" data-rateit-readonly="true" data-rateit-min="0" data-rateit-max="5" data-rateit-mode="font"></div>
				</div>
				<?php } ?>
				<?php if ( $menu ) { ?>
				<div class="d-inline-block pbGuestbookRowMenu">
					<?php echo $menu; ?>
				</div>
				<?php } ?>
			</div>
			<?php } ?>
		</div>
		<?php } else { ?>
		<div class="pbGuestbookRow pbGuestbookEmpty">
			<?php echo ( $isOwner ? CBTxt::T( 'Your guestbook currently has no signatures.' ) : CBTxt::T( 'This users guestbook currently has no signatures.' ) ); ?>
		</div>
		<?php } ?>
	</div>
	<?php if ( $tab->params->get( 'pbPagingEngabbled', true, GetterInterface::BOOLEAN ) && ( $pageNav->total > $pageNav->limit ) ) { ?>
	<div class="text-center mt-3 pbGuestbookPaging">
		<?php echo $pageNav->getListLinks(); ?>
	</div>
	<?php } ?>
	<?php echo implode( '', $_PLUGINS->trigger( 'pb_onAfterDisplayGuestbook', array( $rows, $pageNav, $viewer, $user, $tab ) ) ); ?>
</div>