<?php
/**
 * Community Builder (TM)
 * @version $Id: $
 * @package CommunityBuilder
 * @copyright (C) 2004-2022 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
 * @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
 */

use CB\Database\Table\FieldTable;
use CBLib\Language\CBTxt;
use Joomla\CMS\Factory;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

JFormHelper::loadFieldClass( 'list' );

class JFormFieldcbcontentmodfields extends JFormFieldList
{
	/** @var string  */
	protected $type = 'cbcontentmodfields';

	/**
	 * @return array
	 */
	protected function getOptions(): array
	{
		global $_CB_database;

		$options				=	[];

		if ( ( ! file_exists( JPATH_SITE . '/libraries/CBLib/CBLib/Core/CBLib.php' ) ) || ( ! file_exists( JPATH_ADMINISTRATOR . '/components/com_comprofiler/plugin.foundation.php' ) ) ) {
			// Joomla Fields
			Factory::getApplication()->getLanguage()->load( 'com_users', JPATH_ADMINISTRATOR );

			$db					=	JFactory::getDbo();

			$query				=	$db->getQuery( true )
										->select( 'name, title' )
										->from( '#__fields' )
										->where( 'context = ' . $db->quote( 'com_users.user' ) );
			$db->setQuery( $query );
			$fields				=	$db->loadAssocList();

			// The above won't give core user fields so lets add them here
			$coreFields			=	[	[ 'name' => 'name', 'title' => 'COM_USERS_USER_FIELD_NAME_LABEL' ],
										[ 'name' => 'username', 'title' => 'COM_USERS_USER_FIELD_USERNAME_LABEL' ],
										[ 'name' => 'email', 'title' => 'JGLOBAL_EMAIL' ],
										[ 'name' => 'registerDate', 'title' => 'COM_USERS_USER_FIELD_REGISTERDATE_LABEL' ],
										[ 'name' => 'lastvisitDate', 'title' => 'COM_USERS_USER_FIELD_LASTVISIT_LABEL' ],
										[ 'name' => 'lastResetTime', 'title' => 'COM_USERS_USER_FIELD_LASTRESET_LABEL' ],
									];

			foreach ( array_merge( $coreFields, $fields ) as $field ) {
				$title			=	JText::_( $field['title'] );

				$options[]		=	JHtml::_( 'select.option', $field['name'], ( $title ? $title . ' (' . $field['name'] . ')' : $field['name'] ) );
			}

			return $options;
		}

		// CB Fields
		include_once( JPATH_ADMINISTRATOR . '/components/com_comprofiler/plugin.foundation.php' );

		cbimport( 'cb.html' );
		cbimport( 'language.front' );

		$query					=	'SELECT f.*'
								. 	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_fields' ) . " AS f"
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__comprofiler_tabs' ) . " AS t"
								.	' ON t.' . $_CB_database->NameQuote( 'tabid' ) . ' = f.' . $_CB_database->NameQuote( 'tabid' )
								.	"\n WHERE f." . $_CB_database->NameQuote( 'published' ) . " = 1"
								.	"\n AND f." . $_CB_database->NameQuote( 'name' ) . " != " . $_CB_database->Quote( 'NA' )
								.	"\n ORDER BY t." . $_CB_database->NameQuote( 'ordering' ) . ", f." . $_CB_database->NameQuote( 'ordering' );
		$_CB_database->setQuery( $query );
		$fields					=	$_CB_database->loadObjectList( null, FieldTable::class, [ &$_CB_database ] );

		/** @var FieldTable[] $fields */
		foreach ( $fields as $field ) {
			if ( count( $field->getTableColumns() ) ) {
				$title			=	CBTxt::T( $field->getString( 'title', '' ) );

				$options[]		=	JHtml::_( 'select.option', $field->getString( 'name', '' ), ( $title ? $title . ' (' . $field->getString( 'name', '' ) . ')' : $field->getString( 'name', '' ) ) );
			}
		}

		return $options;
	}
}
