<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\GroupJive\Table\GroupTable;
use CB\Plugin\GroupJiveForums\Forum\ForumInterface;
use CB\Plugin\GroupJive\CBGroupJive;
use CB\Plugin\GroupJiveForums\Table\PostTableInterface;
use CB\Plugin\GroupJiveForums\CBGroupJiveForums;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_groupjiveForums
{

	/**
	 * render frontend forums
	 *
	 * @param PostTableInterface[]  $rows
	 * @param cbPageNav             $pageNav
	 * @param bool                  $searching
	 * @param array                 $input
	 * @param array                 $counters
	 * @param GroupTable            $group
	 * @param UserTable             $user
	 * @param ForumInterface        $forum
	 * @return string
	 */
	public static function showForums( $rows, $pageNav, $searching, $input, &$counters, $group, $user, $forum )
	{
		global $_CB_framework, $_PLUGINS;

		if ( $pageNav->total ) {
			$counters[]						=	'<span class="gjGroupForumsIcon fa-before fa-comments-o"> ' . CBTxt::T( 'GROUP_FORUMS_COUNT', '%%COUNT%% Discussion|%%COUNT%% Discussions', array( '%%COUNT%%' => (int) $pageNav->total ) ) . '</span>';
		}

		$canCreate							=	CBGroupJive::canCreateGroupContent( $user, $group, 'forums' );
		$canSearch							=	( CBGroupJiveForums::getGlobalParams()->getInt( 'groups_forums_search', 1 ) && ( $searching || $pageNav->total ) );
		$return								=	null;

		$_PLUGINS->trigger( 'gj_onBeforeDisplayForums', array( &$return, &$rows, $group, $user ) );

		$return								.=	'<div class="gjGroupForums">';

		if ( $canCreate || $canSearch ) {
			$return							.=		'<div class="row no-gutters mb-3 gjHeader gjGroupForumsHeader">';

			if ( $canCreate ) {
				$return						.=			'<div class="col-12 ' . ( $canSearch ? 'col-sm-6 mb-2 mb-sm-0' : null ) . '">'
											.				'<a href="' . $forum->getCategory( $group->params()->getInt( 'forum_id', 0 ) )->url() . '" class="btn btn-success btn-sm-block gjButton gjButtonNewPost"><span class="fa fa-plus-circle"></span> ' . CBTxt::T( 'Create New Post' ) . '</a>'
											.			'</div>';
			}

			if ( $canSearch ) {
				$return						.=			'<div class="col-12 ' . ( ! $canCreate ? 'offset-sm-6 ' : null ) . 'col-sm-6 text-sm-right">'
											.				'<form action="' . $_CB_framework->pluginClassUrl( 'cbgroupjive', true, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) ) . '" method="post" name="gjGroupForumsSearchForm" class="m-0 gjGroupForumsSearchForm">'
											.					'<div class="input-group">'
											.						$input['search']
											.						'<div class="input-group-append">'
											.							'<button type="submit" class="btn btn-light border" aria-label="' . htmlspecialchars( CBTxt::T( 'Search' ) ) . '"><span class="fa fa-search"></span></button>'
											.						'</div>'
											.					'</div>'
											.				'</form>'
											.			'</div>';
			}

			$return							.=		'</div>';
		}

		$return								.=		'<div class="table-responsive gjGroupForumsRows">'
											.			'<table class="table table-hover">'
											.				'<thead>'
											.					'<tr>'
											.						'<th>' . CBTxt::T( 'Subject' ) . '</th>'
											.						'<th style="width: 25%;" class="d-none d-sm-table-cell">' . CBTxt::T( 'By' ) . '</th>'
											.						'<th style="width: 25%;" class="d-none d-sm-table-cell">' . CBTxt::T( 'Date' ) . '</th>'
											.					'</tr>'
											.				'</thead>'
											.				'<tbody>';

		if ( $rows ) {
			foreach ( $rows as $row ) {
				$return						.=					'<tr>'
											.						'<td class="text-wrap"><a href="' . $row->url() . '">' . $row->getString( 'subject' ) . '</a></td>'
											.						'<td style="width: 25%;" class="d-none d-sm-table-cell">' . CBuser::getInstance( $row->getInt( 'user_id', 0 ), false )->getField( 'formatname', null, 'html', 'none', 'list', 0, true ) . '</td>'
											.						'<td style="width: 25%;" class="d-none d-sm-table-cell">' . cbFormatDate( $row->getString( 'date' ) ) . '</td>'
											.					'</tr>';
			}
		} else {
			$return							.=					'<tr>'
											.						'<td colspan="3" class="gjGroupForumsEmpty">';

			if ( $searching ) {
				$return						.=							CBTxt::T( 'No group post search results found.' );
			} else {
				$return						.=							CBTxt::T( 'This group currently has no posts.' );
			}

			$return							.=						'</td>'
											.					'</tr>';
		}

		$return								.=				'</tbody>';

		if ( CBGroupJiveForums::getGlobalParams()->getInt( 'groups_forums_paging', 1 ) && ( $pageNav->total > $pageNav->limit ) ) {
			$return							.=				'<tfoot>'
											.					'<tr>'
											.						'<td colspan="3" class="gjGroupForumsPaging">'
											.							$pageNav->getListLinks()
											.						'</td>'
											.					'</tr>'
											.				'</tfoot>';
		}

		$return								.=			'</table>'
											.		'</div>'
											.	'</div>';

		$_PLUGINS->trigger( 'gj_onAfterDisplayForums', array( &$return, $rows, $group, $user ) );

		return $return;
	}
}