<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C)2005-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Core\AutoLoader;
use CB\Database\Table\PluginTable;
use CBLib\Registry\Registry;
use CB\Plugin\GroupJive\Table\CategoryTable;
use CB\Plugin\GroupJive\Table\GroupTable;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

AutoLoader::registerExactMap( '%^CB/Plugin/GroupJiveForums/(.+)%i', __DIR__ . '/library/$1.php' );

function plug_cbgroupjiveforums_install()
{
	global $_CB_database, $_PLUGINS;

	// Grab GJ params to migrate the legacy params:
	$plugin				=	new PluginTable();

	$plugin->load( array( 'element' => 'cbgroupjive' ) );

	$pluginParams		=	new Registry( $plugin->getRaw( 'params', array() ) );

	if ( ( ! $pluginParams->has( 'forum_id' ) ) || ( $pluginParams->getInt( 'forum_id' ) === null ) ) {
		return;
	}

	// Migrate forums integration parameters:
	$forums				=	new PluginTable();

	$forums->load( array( 'element' => 'cbgroupjiveforums' ) );

	$forumsParams		=	new Registry( $forums->getRaw( 'params', array() ) );

	if ( $forumsParams->getBool( 'migrated', false ) ) {
		return;
	}

	$forumsParams->set( 'groups_forums_category', $pluginParams->getInt( 'forum_id', 0 ) );
	$forumsParams->set( 'groups_forums_paging', $pluginParams->getInt( 'forum_paging', 0 ) );
	$forumsParams->set( 'groups_forums_limit', $pluginParams->getInt( 'forum_limit' ) );
	$forumsParams->set( 'groups_forums_search', $pluginParams->getInt( 'forum_search', 0 ) );
	$forumsParams->set( 'migrated', true );

	$forums->set( 'params', $forumsParams->asJson() );

	$forums->store();

	// If GJ Forums is being used correct the ACL of the categories:
	if ( $forums->getInt( 'published', 0 ) ) {
		$query				=	'SELECT *'
							.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_categories' )
							.	"\n WHERE " . $_CB_database->NameQuote( 'published' ) . " = 1";
		$_CB_database->setQuery( $query );
		$categories			=	$_CB_database->loadObjectList( null, '\CB\Plugin\GroupJive\Table\CategoryTable', array( $_CB_database ) );

		/** @var $categories CategoryTable[] */
		foreach ( $categories as $category ) {
			if ( $category->params()->getInt( 'forum_id', 0 ) ) {
				// Run the update trigger if there's a forum id to force GJ Forums to update it:
				$_PLUGINS->trigger( 'gj_onAfterUpdateCategory', array( $category, $category ) );
			}
		}

		$query				=	'SELECT *'
							.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_groups' )
							.	"\n WHERE " . $_CB_database->NameQuote( 'published' ) . " = 1";
		$_CB_database->setQuery( $query );
		$groups				=	$_CB_database->loadObjectList( null, '\CB\Plugin\GroupJive\Table\GroupTable', array( $_CB_database ) );

		/** @var $groups GroupTable[] */
		foreach ( $groups as $group ) {
			if ( $group->params()->getInt( 'forum_id', 0 ) ) {
				// Run the update trigger if there's a forum id to force GJ Forums to update it:
				$_PLUGINS->trigger( 'gj_onAfterUpdateGroup', array( $group, $group ) );
			}
		}
	}
}