<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\UserTable;
use CB\Database\Table\FieldTable;
use CBLib\Language\CBTxt;
use CB\Plugin\Query\CBQueryField;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var FieldTable                          $field
 * @var UserTable                           $user
 * @var string                              $query
 * @var array                               $cache
 * @var string                              $cacheId
 */

if ( ! isset( $cache[$cacheId] ) ) {
	$_SQL_database		=	CBQueryField::getDatabase( $field );

	$_SQL_database->setQuery( $query );

	$cache[$cacheId]	=	$_SQL_database->loadResult();
}

$return					=	$cache[$cacheId];

if ( ( ! is_numeric( $return ) ) && ( ! is_bool( $return ) ) ) {
	$return				=	CBTxt::T( (string) $return );
}

echo $return;