(function($) {
	var instances = [];
	var cache = {};
	var methods = {
		init: function( options ) {
			return this.each( function () {
				var $this = this;
				var cbqueryautocomplete = $( $this ).data( 'cbqueryautocomplete' );

				if ( cbqueryautocomplete ) {
					return; // cbqueryautocomplete is already bound; so no need to rebind below
				}

				cbqueryautocomplete = {};
				cbqueryautocomplete.options = options;
				cbqueryautocomplete.defaults = $.fn.cbqueryautocomplete.defaults;
				cbqueryautocomplete.settings = $.extend( true, {}, cbqueryautocomplete.defaults, cbqueryautocomplete.options );
				cbqueryautocomplete.element = $( $this );

				if ( cbqueryautocomplete.settings.useData ) {
					$.each( cbqueryautocomplete.defaults, function( key, value ) {
						if ( ( key != 'init' ) && ( key != 'useData' ) ) {
							// Dash Separated:
							var dataValue = cbqueryautocomplete.element.data( 'cbqueryautocomplete' + key.charAt( 0 ).toUpperCase() + key.slice( 1 ) );

							if ( typeof dataValue != 'undefined' ) {
								cbqueryautocomplete.settings[key] = dataValue;
							} else {
								// No Separater:
								dataValue = cbqueryautocomplete.element.data( 'cbqueryautocomplete' + key.charAt( 0 ).toUpperCase() + key.slice( 1 ).toLowerCase() );

								if ( typeof dataValue != 'undefined' ) {
									cbqueryautocomplete.settings[key] = dataValue;
								}
							}
						}
					});
				}

				cbqueryautocomplete.element.trigger( 'cbqueryautocomplete.init.before', [cbqueryautocomplete] );

				if ( ! cbqueryautocomplete.settings.init ) {
					return;
				}

				if ( ( cbqueryautocomplete.settings.fields === null ) || ( ! $.isArray( cbqueryautocomplete.settings.fields ) ) ) {
					cbqueryautocomplete.settings.fields = [];
				}

				cbqueryautocomplete.repeat = cbqueryautocomplete.element.closest( '.cbRepeatRow' ).length;

				var target = findTarget.call( cbqueryautocomplete.element );
				var targetName = target.attr( 'name' );

				cache[targetName] = {};

				target.autocomplete({
					appendTo: cbqueryautocomplete.element,
					classes: {
						'ui-autocomplete': 'm-0 p-0 list-unstyled bg-white border border-top-0 rounded-top-0 rounded-bottom auto-overflow cbQueryAutoCompleteResults'
					},
					minLength: cbqueryautocomplete.settings.length,
					change: function( event, ui ) {
						if ( ! cbqueryautocomplete.settings.strict )  {
							return;
						}

						if ( ui.item == null ) {
							var currentData = target.data( 'cbqueryfield-source' );
							var currentMatched = false;

							if ( currentData ) {
								var currentValue = target.val();

								if ( currentValue ) {
									$.each( currentData, function( key, value ) {
										if ( currentValue == value.value ) {
											currentMatched = true;
											return false;
										} else if ( currentValue == value.label ) {
											currentMatched = true;

											target.val( value.value );

											return false;
										}
									});
								}
							}

							if ( ! currentMatched ) {
								target.val( '' ).focus();
							}
						}
					},
					source: function( request, response ) {
						var term = request.term;

						if ( term in cache[targetName] ) {
							response( cache[targetName][term] );
							return;
						}

						if ( cbqueryautocomplete.element.hasClass( 'cbQueryAutoCompleteRequesting' ) ) {
							response();
							return;
						}

						var post = { value: term };

						if ( cbqueryautocomplete.repeat ) {
							post['field'] = target.attr( 'name' );
						}

						if ( cbqueryautocomplete.settings.fields ) {
							$.each( cbqueryautocomplete.settings.fields, function( index, fieldId ) {
								var fieldTarget = null;

								if ( cbqueryautocomplete.repeat ) {
									fieldTarget = findTarget.call( cbqueryautocomplete.element.closest( '.cbRepeatRow' ).find( fieldId ) );

									if ( ! fieldTarget.length ) {
										fieldTarget = findTarget.call( $( fieldId ) );
									}
								} else {
									fieldTarget = findTarget.call( $( fieldId ) );
								}

								if ( ! fieldTarget.length ) {
									return true;
								}

								var fieldName = fieldTarget.attr( 'name' );

								if ( cbqueryautocomplete.repeat ) {
									fieldName = fieldName.replace( /^.+__\d+__/g, '' );
								}

								if ( fieldName == targetName ) {
									return true;
								}

								if ( fieldName.length ) {
									post[fieldName] = getValue.call( fieldTarget );
								}
							});
						}

						cbqueryautocomplete.element.addClass( 'cbQueryAutoCompleteRequesting' );

						$.ajax({
							url: cbqueryautocomplete.settings.url,
							type: 'POST',
							dataType: 'json',
							data: post,
							converters: {
								'text json': function( result ) {
									try {
										return JSON.parse( result );
									} catch( e ) {
										return null;
									}
								}
							}
						}).done( function( data ) {
							cache[targetName][term] = data;

							target.data( 'cbqueryfield-source', data );

							response( data );
						}).fail( function() {
							response();
						}).always( function() {
							cbqueryautocomplete.element.removeClass( 'cbQueryAutoCompleteRequesting' );
						});
					}
				}).autocomplete( 'widget' ).css({
					fontFamily: 'inherit',
					fontSize: 'inherit',
					maxHeight: cbqueryautocomplete.settings.height
				}).menu( 'option', {
					classes: {
						'ui-menu-item': 'cbQueryAutoCompleteResult',
						'ui-menu-item-wrapper': 'm-0 p-2 bg-none border-0 text-inherit cbQueryAutoCompleteOption'
					},
					blur: function( event, ui ) {
						ui.item.removeClass( 'bg-primary cbQueryAutoCompleteActive' );
						ui.item.children( '.ui-menu-item-wrapper' ).removeClass( 'text-white' );
					},
					focus: function( event, ui ) {
						ui.item.addClass( 'bg-primary cbQueryAutoCompleteActive' );
						ui.item.children( '.ui-menu-item-wrapper' ).addClass( 'text-white' );
					}
				});

				// Destroy the cbqueryautocomplete element:
				cbqueryautocomplete.element.on( 'remove.cbqueryautocomplete destroy.cbqueryautocomplete', function() {
					cbqueryautocomplete.element.cbqueryautocomplete( 'destroy' );
				});

				// Rebind the cbqueryautocomplete element to pick up any data attribute modifications:
				cbqueryautocomplete.element.on( 'rebind.cbqueryautocomplete', function() {
					cbqueryautocomplete.element.cbqueryautocomplete( 'rebind' );
				});

				// If the cbqueryautocomplete element is modified we need to rebuild it to ensure all our bindings are still ok:
				cbqueryautocomplete.element.on( 'modified.cbqueryautocomplete', function( e, oldId, newId, index ) {
					if ( oldId != newId ) {
						var urlAttr = cbqueryautocomplete.element.attr( 'data-cbqueryautocomplete-url' );

						if ( typeof urlAttr != 'undefined' ) {
							cbqueryautocomplete.element.attr( 'data-cbqueryautocomplete-url', urlAttr.replace( oldId, newId ) );
						}

						var urlData = cbqueryautocomplete.element.data( 'cbqueryautocomplete-url' );

						if ( typeof urlData != 'undefined' ) {
							cbqueryautocomplete.element.data( 'cbqueryautocomplete-url', urlData.replace( oldId, newId ) );
						}

						cbqueryautocomplete.element.cbajaxfield( 'rebind' );
					}
				});

				// If the cbajaxfield is cloned we need to rebind it back:
				cbqueryautocomplete.element.on( 'cloned.cbqueryautocomplete', function() {
					$( this ).off( '.cbqueryautocomplete' );
					$( this ).removeData( 'cbqueryautocomplete' );
					$( this ).children( '.ui-autocomplete' ).remove();

					var target = findTarget.call( this );

					target.removeClass( 'ui-autocomplete-input' );
					target.removeAttr( 'autocomplete' );
					target.off( target.data( 'ui-autocomplete' ).eventNamespace );
					target.off( target.data( 'ui-autocomplete' ).menu.eventNamespace );
					target.removeData( 'ui-autocomplete' );

					$( this ).cbqueryautocomplete( cbqueryautocomplete.options );
				});

				cbqueryautocomplete.element.trigger( 'cbqueryautocomplete.init.after', [cbqueryautocomplete] );

				// Bind the cbqueryautocomplete to the element so it's reusable and chainable:
				cbqueryautocomplete.element.data( 'cbqueryautocomplete', cbqueryautocomplete );

				// Add this instance to our instance array so we can keep track of our cbqueryautocomplete instances:
				instances.push( cbqueryautocomplete );
			});
		},
		rebind: function() {
			var cbqueryautocomplete = $( this ).data( 'cbqueryautocomplete' );

			if ( ! cbqueryautocomplete ) {
				return this;
			}

			cbqueryautocomplete.element.cbqueryautocomplete( 'destroy' );
			cbqueryautocomplete.element.cbqueryautocomplete( cbqueryautocomplete.options );

			return this;
		},
		destroy: function() {
			var cbqueryautocomplete = $( this ).data( 'cbqueryautocomplete' );

			if ( ! cbqueryautocomplete ) {
				return false;
			}

			$.each( instances, function( i, instance ) {
				if ( instance.element == cbqueryautocomplete.element ) {
					instances.splice( i, 1 );

					return false;
				}

				return true;
			});

			cbqueryautocomplete.element.off( '.cbqueryautocomplete' );

			findTarget.call( cbqueryautocomplete.element ).autocomplete( 'destroy' );

			cbqueryautocomplete.element.removeData( 'cbqueryautocomplete' );
			cbqueryautocomplete.element.trigger( 'cbqueryautocomplete.destroyed', [cbqueryautocomplete] );

			return true;
		},
		instances: function() {
			return instances;
		}
	};

	function findTarget() {
		var element = ( this.jquery ? this : $( this ) );
		var target = null;

		if ( element.is( 'input' ) || element.is( 'select' ) || element.is( 'textarea' ) ) {
			target = element;
		} else {
			target = element.find( 'input,select,textarea' ).not( '[name$="__srmch"]' ).first();

			if ( target.is( ':checkbox' ) || target.is( ':radio' ) ) {
				target = element.find( 'input[name="' + target.attr( 'name' ) + '"]' );
			}
		}

		return target;
	}

	function getValue() {
		var element = ( this.jquery ? this : $( this ) );
		var value = null;

		if ( element.is( 'input' ) || element.is( 'select' ) || element.is( 'textarea' ) ) {
			if ( element.is( 'input[type="checkbox"]' ) || element.is( 'input[type="radio"]' ) ) {
				value = [];

				element.each( function() {
					if ( $( this ).is( ':checked' ) ) {
						value.push( $( this ).val() );
					}
				});
			} else if ( element.is( 'select[multiple]' ) ) {
				value = element.val();

				if ( value && ( ! $.isArray( value ) ) ) {
					value = value.split( ',' );
				}
			} else {
				value = element.val();
			}
		}

		return value;
	}

	$.fn.cbqueryautocomplete = function( options ) {
		if ( methods[options] ) {
			return methods[ options ].apply( this, Array.prototype.slice.call( arguments, 1 ) );
		} else if ( ( typeof options === 'object' ) || ( ! options ) ) {
			return methods.init.apply( this, arguments );
		}

		return this;
	};

	$.fn.cbqueryautocomplete.defaults = {
		init: true,
		useData: true,
		url: null,
		fields: [],
		length: null,
		strict: false,
		height: '200px'
	};
})(jQuery);