<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C)2005-2017 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\UserTable;
use CB\Database\Table\TabTable;
use CBLib\Language\CBTxt;
use CB\Plugin\ProfileUpdateLogger\Table\UpdateLogTable;
use CB\Plugin\ProfileUpdateLogger\Tab\UpdateLogTab;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var UpdateLogTab     $this
 * @var UpdateLogTable[] $rows
 * @var array            $input
 * @var UserTable        $user
 * @var TabTable         $tab
 *
 * @var bool             $canSearch
 */
?>
<?php if ( $canSearch ) { ?>
<div class="mb-3 puLogHeader">
	<div class="col-12 offset-sm-6 col-sm-6 text-sm-right">
		<form action="<?php echo $input['search_url']; ?>" method="post" name="puLogSearchForm" class="m-0 puLogSearchForm">
			<div class="input-group">
				<?php echo $input['search']; ?>
				<div class="input-group-append">
					<button type="submit" class="btn btn-light border" aria-label="<?php echo htmlspecialchars( CBTxt::T( 'Search' ) ); ?>"><span class="fa fa-search"></span></button>
				</div>
			</div>
		</form>
	</div>
</div>
<?php } ?>
<div class="table-responsive puLogFrontend">
	<table class="puLogRows table table-hover">
		<thead>
			<tr>
				<th style="width: 25%;"><?php echo CBTxt::T( 'Field' ); ?></th>
				<th style="width: 30%;"><?php echo CBTxt::T( 'Old Value' ); ?></th>
				<th style="width: 30%;"><?php echo CBTxt::T( 'New Value' ); ?></th>
				<th class="text-center d-none d-sm-table-cell" style="width: 15%;"><?php echo CBTxt::T( 'Date' ); ?></th>
			</tr>
		</thead>
		<tbody>
			<?php if ( $rows ) { ?>
				<?php foreach ( $rows as $row ) { ?>
				<tr class="puLogRow">
					<td class="text-wrapall" style="width: 25%;"><?php echo $row->getFieldName(); ?></td>
					<td class="text-wrapall" style="width: 30%;">
						<?php if ( $row->isCompare() ) { ?>
							<button type="button" class="btn btn-sm btn-light border cbTooltip" data-cbtooltip-tooltip-target=".puLogCompare<?php echo $row->getInt( 'id', 0 ) ?>" data-cbtooltip-modal="true" data-cbtooltip-width="90%" data-cbtooltip-height="90%">
								<?php echo CBTxt::T( 'Compare' ); ?>
							</button>
						<?php } else { ?>
							<?php echo $row->getOldValue(); ?>
						<?php } ?>
					</td>
					<td class="text-wrapall" style="width: 30%;">
						<?php if ( $row->isCompare() ) { ?>
							<button type="button" class="btn btn-sm btn-light border cbTooltip" data-cbtooltip-tooltip-target=".puLogCompare<?php echo $row->getInt( 'id', 0 ) ?>" data-cbtooltip-modal="true" data-cbtooltip-width="90%" data-cbtooltip-height="90%">
								<?php echo CBTxt::T( 'Compare' ); ?>
							</button>
							<div class="h-100 puLogCompare<?php echo $row->getInt( 'id', 0 ) ?>" style="display: none;">
								<div class="h-100 row no-gutters">
									<div class="h-100 col-12 col-md-6 pr-0 pr-md-1">
										<div class="h-100 card">
											<h5 class="card-header text-center"><?php echo CBTxt::T( 'Old Value' ); ?></h5>
											<div class="card-body overflow-auto">
												<?php echo $row->getOldValue(); ?>
											</div>
										</div>
									</div>
									<div class="h-100 col-12 col-md-6 pl-0 pl-md-1">
										<div class="h-100 card">
											<h5 class="card-header text-center"><?php echo CBTxt::T( 'New Value' ); ?></h5>
											<div class="card-body overflow-auto">
												<?php echo $row->getNewValue(); ?>
											</div>
										</div>
									</div>
								</div>
							</div>
						<?php } else { ?>
							<?php echo $row->getNewValue(); ?>
						<?php } ?>
					</td>
					<td class="text-center d-none d-sm-table-cell" style="width: 15%;"><?php echo cbFormatDate( $row->getString( 'changedate' ), true, false ); ?></td>
				</tr>
				<?php } ?>
			<?php } else { ?>
			<tr class="puLogRow puLogRowEmpty">
				<td colspan="4"><?php echo $input['results']; ?></td>
			</tr>
			<?php } ?>
		</tbody>
		<?php if ( $input['paging'] ) { ?>
		<tfoot>
			<tr>
				<td colspan="4" class="text-center"><?php echo $input['paging']; ?></td>
			</tr>
		</tfoot>
		<?php } ?>
	</table>
</div>