<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use Joomla\CMS\Factory;
use Joomla\CMS\Installer\InstallerAdapter;
use Joomla\CMS\Table\Table;
use Joomla\Registry\Registry;

defined( '_JEXEC' ) or die;

class plgcontentcbreplacerbotInstallerScript
{
	/**
	 * @var null|string
	 */
	protected $element;
	/**
	 * @var null|string
	 */
	protected $version;

	/**
	 * Set install requirements
	 */
	public function __construct()
	{
		$this->db		=	Factory::getDbo();
	}

	/**
	 * @param string           $type
	 * @param InstallerAdapter $parent
	 * @return bool
	 */
	public function preflight( $type, $parent )
	{
		$this->element			=	$parent->getElement();

		$extension				=	Table::getInstance( 'extension' );

		if ( $extension->load( [ 'element' => $this->element ] ) ) {
			$this->version		=	( json_decode( $extension->get( 'manifest_cache' ), true )['version'] ?? null );
		}

		return true;
	}

	/**
	 * @param InstallerAdapter $parent
	 * @return bool
	 */
	public function update( $parent )
	{
		if ( $this->version && version_compare( $this->version, '2.0.0', '<' ) ) {
			$extension						=	Table::getInstance( 'extension' );

			if ( ! $extension->load( [ 'element' => $this->element ] ) ) {
				return true;
			}

			$params							=	new Registry();

			$params->loadString( $extension->get( 'params' ) );

			$replacers						=	$params->get( 'replacers' );

			if ( ( ! $replacers ) || ( ! is_string( $replacers ) ) ) {
				return true;
			}

			$replacers						=	json_decode( $replacers, true );

			if ( ( ! $replacers ) || ( ! isset( $replacers['from'] ) ) ) {
				return true;
			}

			$newReplacers					=	[];

			foreach ( $replacers['from'] as $k => $from ) {
				if ( ! $from ) {
					continue;
				}

				$newReplacers["__field$k"]	=	[	'from'			=>	$from,
													'to'			=>	( $replacers['to'][$k] ?? 0 ),
													'regexp'		=>	( $replacers['regexp'][$k] ?? 0 ),
													'translate'		=>	( $replacers['translate'][$k] ?? 0 ),
													'substitutions'	=>	( $replacers['substitutions'][$k] ?? 0 ),
													'casesensitive'	=>	( $replacers['casesensitive'][$k] ?? 0 ),
												];
			}

			$params->set( 'replacers', $newReplacers );

			$extension->set( 'params', $params->toString() );

			$extension->store();
		}

		return true;
	}
}
