<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\AntiSpam\Table\WhitelistTable;
use CBLib\Registry\GetterInterface;
use CB\Plugin\AntiSpam\CBAntiSpam;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var CBplug_cbantispam $this
 * @var WhitelistTable    $row
 * @var array             $input
 * @var string            $type
 * @var UserTable         $whitelistUser
 * @var UserTable         $user
 * @var string            $pageTitle
 * @var string            $returnUrl
 */
?>
<div class="whitelistEdit">
	<form action="<?php echo $_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'whitelist', 'func' => 'save', 'id' => $row->get( 'id', 0, GetterInterface::INT ), 'user' => $whitelistUser->get( 'id', 0, GetterInterface::INT ), 'return' => CBAntiSpam::getReturn( true ) ) ); ?>" method="post" enctype="multipart/form-data" name="whitelistForm" id="whitelistForm" class="m-0 form-auto cb_form whitelistForm cbValidation">
		<?php if ( $pageTitle ) { ?>
		<div class="mb-3 border-bottom cb-page-header whitelistTitle">
			<h3 class="m-0 p-0 mb-2 cb-page-header-title"><?php echo $pageTitle; ?></h3>
		</div>
		<?php } ?>
		<div class="cbft_select cbtt_select form-group row no-gutters cb_form_line">
			<label for="type" class="col-form-label col-sm-3 pr-sm-2"><?php echo CBTxt::T( 'Type' ); ?></label>
			<div class="cb_field col-sm-9">
				<?php echo $input['type']; ?>
				<?php echo getFieldIcons( 1, 1, null, CBTxt::T( 'Select the whitelist type. Type determines what value should be supplied.' ) ); ?>
			</div>
		</div>
		<div class="cbft_text cbtt_input form-group row no-gutters cb_form_line">
			<label for="value" class="col-form-label col-sm-3 pr-sm-2"><?php echo CBTxt::T( 'Value' ); ?></label>
			<div class="cb_field col-sm-9">
				<?php echo $input['value']; ?>
				<?php echo getFieldIcons( 1, 1, null, CBTxt::T( 'Input whitelist value in relation to the type. User type use the users user_id (e.g. 42). IP Address type use a full valid IP Address (e.g. 192.168.0.1). IP Address Range type use two full valid IP Addresses separated by a colon (e.g. 192.168.0.1:192.168.0.100). Email type use a fill valid email address (e.g. invalid@cb.invalid). Email Domain type use a full email address domain after @ (e.g. example.com). Additionally IP Address, Email Address, and Email Domain types support % wildcard.' ) ); ?>
			</div>
		</div>
		<div class="cbft_textarea cbtt_textarea form-group row no-gutters cb_form_line">
			<label for="reason" class="col-form-label col-sm-3 pr-sm-2"><?php echo CBTxt::T( 'Reason' ); ?></label>
			<div class="cb_field col-sm-9">
				<?php echo $input['reason']; ?>
				<?php echo getFieldIcons( 1, 0, null, CBTxt::T( 'Optionally input whitelist reason. Note this is for administrative purposes only.' ) ); ?>
			</div>
		</div>
		<div class="row no-gutters">
			<div class="offset-sm-3 col-sm-9">
				<input type="submit" value="<?php echo htmlspecialchars( ( $row->get( 'id' ) ? CBTxt::T( 'Update Whitelist' ) : CBTxt::T( 'Create Whitelist' ) ) ); ?>" class="btn btn-primary whitelistButton whitelistButtonSubmit"<?php echo cbValidator::getSubmitBtnHtmlAttributes(); ?> />
				 <input type="button" value="<?php echo htmlspecialchars( CBTxt::T( 'Cancel' ) ); ?>" class="btn btn-secondary whitelistButton whitelistButtonCancel" onclick="cbjQuery.cbconfirm( '<?php echo addslashes( CBTxt::T( 'Are you sure you want to cancel? All unsaved data will be lost!' ) ); ?>' ).done( function() { window.location.href = '<?php echo addslashes( htmlspecialchars( $returnUrl ) ); ?>'; })" />
			</div>
		</div>
		<?php echo cbGetSpoofInputTag( 'plugin' ); ?>
	</form>
</div>