<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\AntiSpam\Table\BlockTable;
use CBLib\Registry\GetterInterface;
use CB\Plugin\AntiSpam\CBAntiSpam;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var CBplug_cbantispam $this
 * @var BlockTable        $row
 * @var array             $input
 * @var string            $type
 * @var UserTable         $blockUser
 * @var UserTable         $user
 * @var string            $pageTitle
 * @var string            $returnUrl
 */
?>
<div class="blockEdit">
	<form action="<?php echo $_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'block', 'func' => 'save', 'id' => $row->get( 'id', 0, GetterInterface::INT ), 'user' => $blockUser->get( 'id', 0, GetterInterface::INT ), 'return' => CBAntiSpam::getReturn( true ) ) ); ?>" method="post" enctype="multipart/form-data" name="blockForm" id="blockForm" class="m-0 form-auto cb_form blockForm cbValidation">
		<?php if ( $pageTitle ) { ?>
		<div class="mb-3 border-bottom cb-page-header blockTitle">
			<h3 class="m-0 p-0 mb-2 cb-page-header-title"><?php echo $pageTitle; ?></h3>
		</div>
		<?php } ?>
		<div class="cbft_select cbtt_select form-group row no-gutters cb_form_line blockEditType">
			<label for="type" class="col-form-label col-sm-3 pr-sm-2"><?php echo CBTxt::T( 'Type' ); ?></label>
			<div class="cb_field col-sm-9">
				<?php echo $input['type']; ?>
				<?php echo getFieldIcons( 1, 1, null, CBTxt::T( 'Select the block type. Type determines what value should be supplied.' ) ); ?>
			</div>
		</div>
		<div class="cbft_text cbtt_input form-group row no-gutters cb_form_line blockEditValue">
			<label for="value" class="col-form-label col-sm-3 pr-sm-2"><?php echo CBTxt::T( 'Value' ); ?></label>
			<div class="cb_field col-sm-9">
				<?php echo $input['value']; ?>
				<?php echo getFieldIcons( 1, 1, null, CBTxt::T( 'Input block value in relation to the type. User type use the users user_id (e.g. 42). IP Address type use a full valid IP Address (e.g. 192.168.0.1). IP Address Range type use two full valid IP Addresses separated by a colon (e.g. 192.168.0.1:192.168.0.100). Email type use a fill valid email address (e.g. invalid@cb.invalid). Email Domain type use a full email address domain after @ (e.g. example.com). Additionally IP Address, Email Address, and Email Domain types support % wildcard.' ) ); ?>
			</div>
		</div>
		<div class="cbft_date cbtt_input form-group row no-gutters cb_form_line blockEditDate">
			<label for="date" class="col-form-label col-sm-3 pr-sm-2"><?php echo CBTxt::T( 'Date' ); ?></label>
			<div class="cb_field col-sm-9">
				<?php echo $input['date']; ?>
				<?php echo getFieldIcons( 1, 1, null, CBTxt::T( 'Select the date and time the block should go in affect. Note date and time always functions in UTC.' ) ); ?>
			</div>
		</div>
		<div class="cbft_text cbtt_input form-group row no-gutters cb_form_line blockEditDuration">
			<label for="duration" class="col-form-label col-sm-3 pr-sm-2"><?php echo CBTxt::T( 'Duration' ); ?></label>
			<div class="cb_field col-sm-9">
				<div class="input-group d-inline-flex w-auto">
					<?php echo $input['duration']; ?>
					<?php echo $input['durations']; ?>
				</div>
				<?php echo getFieldIcons( 1, 0, null, CBTxt::T( 'Input the strtotime relative date (e.g. +1 Day). This duration will be added to the datetime specified above. Leave blank for a forever duration.' ) ); ?>
			</div>
		</div>
		<div class="cbft_textarea cbtt_textarea form-group row no-gutters cb_form_line blockEditReason">
			<label for="reason" class="col-form-label col-sm-3 pr-sm-2"><?php echo CBTxt::T( 'Reason' ); ?></label>
			<div class="cb_field col-sm-9">
				<?php echo $input['reason']; ?>
				<?php echo getFieldIcons( 1, 0, null, CBTxt::T( 'Optionally input block reason. If left blank will default to spam.' ) ); ?>
			</div>
		</div>
		<?php if ( isset( $ueConfig['allowUserBanning'] ) && $ueConfig['allowUserBanning'] ) { ?>
		<div class="cbft_select cbtt_select form-group row no-gutters cb_form_line blockEditBan hidden">
			<label for="ban_user" class="col-form-label col-sm-3 pr-sm-2"><?php echo CBTxt::T( 'Ban Profile' ); ?></label>
			<div class="cb_field col-sm-9">
				<?php echo $input['ban_user']; ?>
				<?php echo getFieldIcons( 1, 0, null, CBTxt::T( 'Ban the users profile using Community Builder moderator ban feature. Note normal ban notification will be sent with the ban.' ) ); ?>
			</div>
		</div>
		<div class="cbft_textarea cbtt_textarea form-group row no-gutters cb_form_line blockEditBanReason hidden">
			<label for="ban_reason" class="col-form-label col-sm-3 pr-sm-2"><?php echo CBTxt::T( 'Ban Reason' ); ?></label>
			<div class="cb_field col-sm-9">
				<?php echo $input['ban_reason']; ?>
				<?php echo getFieldIcons( 1, 0, null, CBTxt::T( 'Optionally input reason for profile ban.' ) ); ?>
			</div>
		</div>
		<?php } ?>
		<div class="cbft_select cbtt_select form-group row no-gutters cb_form_line blockEditBlock hidden">
			<label for="block_user" class="col-form-label col-sm-3 pr-sm-2"><?php echo CBTxt::T( 'Block Profile' ); ?></label>
			<div class="cb_field col-sm-9">
				<?php echo $input['block_user']; ?>
				<?php echo getFieldIcons( 1, 0, null, CBTxt::T( 'Block the users profile using Joomla block state.' ) ); ?>
			</div>
		</div>
		<div class="cbft_delimiter form-group row no-gutters cb_form_line blockEditBlockAccount hidden">
			<label for="block_user" class="col-form-label col-sm-3 pr-sm-2"><?php echo CBTxt::T( 'Block Profile' ); ?></label>
			<div class="cb_field col-sm-9">
				<div class="form-control-plaintext">
					<?php echo CBTxt::T( 'The specified user id will have their profile blocked using Joomla block state.' ); ?>
				</div>
			</div>
		</div>
		<div class="row no-gutters">
			<div class="offset-sm-3 col-sm-9">
				<input type="submit" value="<?php echo htmlspecialchars( ( $row->get( 'id', 0, GetterInterface::INT ) ? CBTxt::T( 'Update Block' ) : CBTxt::T( 'Create Block' ) ) ); ?>" class="btn btn-primary blockButton blockButtonSubmit"<?php echo cbValidator::getSubmitBtnHtmlAttributes(); ?> />&nbsp;
				 <input type="button" value="<?php echo htmlspecialchars( CBTxt::T( 'Cancel' ) ); ?>" class="btn btn-secondary blockButton blockButtonCancel" onclick="cbjQuery.cbconfirm( '<?php echo addslashes( CBTxt::T( 'Are you sure you want to cancel? All unsaved data will be lost!' ) ); ?>' ).done( function() { window.location.href = '<?php echo addslashes( htmlspecialchars( $returnUrl ) ); ?>'; })" />
			</div>
		</div>
		<?php echo cbGetSpoofInputTag( 'plugin' ); ?>
	</form>
</div>