<?php
/**
 * Community Builder (TM)
 * @version $Id: $
 * @package CommunityBuilder
 * @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
 * @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
 */

use CB\Database\Table\UserTable;
use CB\Database\Table\FieldTable;
use CBLib\Registry\GetterInterface;
use CBLib\Language\CBTxt;
use CB\Plugin\FieldGroups\CBFieldGroups;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var array      $fieldGroups
 * @var string     $repeatLabel
 * @var bool       $repeatOrdering
 * @var bool       $repeatCount
 * @var int        $repeatMax
 * @var array      $rows
 * @var array      $rowsTitles
 * @var array      $rowsDescriptions
 * @var array      $rowsFields
 *
 * @var FieldTable $field
 * @var UserTable  $user
 * @var string     $output
 * @var string     $reason
 * @var int        $list_compare_types
 */
?>
<div class="form-group mb-0 table-responsive cbFieldGroup cbFieldGroupTable">
	<table class="m-0 table table-bordered cbRepeat" data-cbrepeat-fallback-for="<?php echo htmlspecialchars( $field->get( 'name', null, GetterInterface::STRING ) ); ?>" data-cbrepeat-fallback-name="<?php echo htmlspecialchars( $field->get( 'name', null, GetterInterface::STRING ) ); ?>" <?php echo ( ! $repeatOrdering ? ' data-cbrepeat-sortable="false"' : null ) . ( $repeatMax ? ' data-cbrepeat-max="' . (int) $repeatMax . '"' : null ); ?>>
		<thead>
			<tr>
				<th class="text-center">#</th>
				<th><?php echo implode( '</th><th>', $rowsTitles[0] ); ?></th>
			</tr>
		</thead>
		<tbody>
			<?php echo implode( '', $rows ); ?>
		</tbody>
		<tfoot>
			<tr class="cbRepeatRowIncrement">
				<td colspan="<?php echo ( count( $rowsTitles[0] ) + 1 ); ?>">
					<?php if ( $repeatCount ) { ?>
					<div class="form-inline">
						<div class="input-group">
							<input type="text" class="form-control form-control-sm text-center cbRepeatRowAddCount" size="2" placeholder="1" />
							<span class="input-group-append">
								<div class="btn btn-sm btn-success cbRepeatRowAdd" title="<?php echo htmlspecialchars( CBTxt::T( 'Click to add new rows.' ) ); ?>"><span class="fa fa-plus"></span> <?php echo $repeatLabel; ?></div>
							</span>
						</div>
						</div>
					<?php } else { ?>
					<div class="btn btn-sm btn-success cbRepeatRowAdd" title="<?php echo htmlspecialchars( CBTxt::T( 'Click to add new row.' ) ); ?>"><span class="fa fa-plus"></span> <?php echo $repeatLabel; ?></div>
					<?php } ?>
				</td>
			</tr>
		</tfoot>
	</table>
	<input type="hidden" name="<?php echo CBFieldGroups::getGroupedName( $field->get( 'name', null, GetterInterface::STRING ), null, 'count' ); ?>" class="cbRepeatCount" />
</div>