<?php
/**
 * Community Builder (TM)
 * @version $Id: $
 * @package CommunityBuilder
 * @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
 * @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
 */

use CB\Database\Table\UserTable;
use CB\Database\Table\FieldTable;
use CBLib\Registry\GetterInterface;
use CB\Plugin\FieldGroups\CBFieldGroups;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var array      $fieldGroups
 * @var string     $repeatLabel
 * @var bool       $repeatOrdering
 * @var bool       $repeatCount
 * @var int        $repeatMax
 * @var array      $rows
 * @var array      $rowsTitles
 * @var array      $rowsDescriptions
 * @var array      $rowsFields
 *
 * @var FieldTable $field
 * @var UserTable  $user
 * @var string     $output
 * @var string     $reason
 * @var int        $list_compare_types
 */
?>
<div class="form-group mb-0 mw-100 cbRepeat cbFieldGroup cbFieldGroupCompact" data-cbrepeat-fallback-for="<?php echo htmlspecialchars( $field->get( 'name', null, GetterInterface::STRING ) ); ?>" data-cbrepeat-fallback-name="<?php echo htmlspecialchars( $field->get( 'name', null, GetterInterface::STRING ) ); ?>" <?php echo ( ! $repeatOrdering ? ' data-cbrepeat-sortable="false"' : null ) . ( $repeatMax ? ' data-cbrepeat-max="' . (int) $repeatMax . '"' : null ); ?>>
	<?php echo implode( '', $rows ); ?>
	<input type="hidden" name="<?php echo CBFieldGroups::getGroupedName( $field->get( 'name', null, GetterInterface::STRING ), null, 'count' ); ?>" class="cbRepeatCount" />
</div>
