<?php
/**
 * Community Builder (TM)
 * @version $Id: $
 * @package CommunityBuilder
 * @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
 * @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
 */

namespace CB\Plugin\FieldGroups\Trigger;

use CB\Database\Table\FieldTable;
use CB\Database\Table\UserTable;
use CB\Plugin\FieldGroups\CBFieldGroups;
use CBLib\Registry\GetterInterface;
use CBLib\Registry\Registry;

defined('CBLIB') or die();

class FieldTrigger extends \cbPluginHandler
{

	/**
	 * @param FieldTable[] $fields
	 * @param UserTable    $user
	 * @param string       $reason
	 * @param int          $tabid
	 * @param int|string   $fieldIdOrName
	 * @param bool         $fullAccess
	 */
	public function fieldsFetch( &$fields, &$user, $reason, $tabid, $fieldIdOrName, $fullAccess )
	{
		global $_CB_database;

		if ( ! $user instanceof UserTable ) {
			// fieldClass can result in a NULL value for $user so lets replace it with an actual user object like it should be:
			$user						=	new UserTable();
		}

		static $fieldGroupNames			=	array();
		static $groupedFields			=	null;

		if ( $groupedFields === null ) {
			$groupedFields				=	array();

			$query						=	"SELECT f." . $_CB_database->NameQuote( 'name' )
										.	", f." . $_CB_database->NameQuote( 'params' )
										.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_fields' ) . " AS f"
										.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__comprofiler_tabs' ) . " AS t"
										.	" ON t." . $_CB_database->NameQuote( 'tabid' ) . " = f." . $_CB_database->NameQuote( 'tabid' )
										.	"\n WHERE f." . $_CB_database->NameQuote( 'type' ) . " = " . $_CB_database->Quote( 'fieldgroup' )
										.	"\n AND f." . $_CB_database->NameQuote( 'published' ) . " = 1"
										.	"\n AND t." . $_CB_database->NameQuote( 'enabled' ) . " = 1";
			$_CB_database->setQuery( $query );
			$fieldGroups				=	$_CB_database->loadAssocList( 'name', 'params' );

			foreach ( $fieldGroups as $fieldGroupName => $fieldGroupParams ) {
				$fieldGroupNames[]		=	$fieldGroupName;

				if ( ! $fieldGroupParams ) {
					continue;
				}

				$fieldGroupParams		=	new Registry( $fieldGroupParams );
				$fieldGroupFields		=	explode( '|*|', $fieldGroupParams->get( 'repeat_fields', null, GetterInterface::STRING ) );

				if ( ! $fieldGroupFields ) {
					continue;
				}

				$groupedFields			=	array_merge( $groupedFields, $fieldGroupFields );
			}

			$groupedFields				=	array_unique( cbToArrayOfInt( $groupedFields ) );
		}

		if ( ( ! $fieldGroupNames ) || ( ! $groupedFields ) ) {
			return;
		}

		// We're trying to directly get a field, a field wasn't found, it isn't a field id, and it isn't a field group field so lets see if it's a grouped field:
		if ( $fieldIdOrName && ( ! isset( $fields[0] ) ) && ( ! is_int( $fieldIdOrName ) ) && ( ! in_array( $fieldIdOrName, $fieldGroupNames ) ) ) {
			foreach ( $fieldGroupNames as $fieldGroupName ) {
				$substitution			=	false;

				// Lets support the [FIELD_NAME_INDEX_FIELD_NAME] syntax first:
				if ( strpos( $fieldIdOrName, $fieldGroupName ) === 0 ) {
					$substitution		=	true;
				} elseif ( strpos( $fieldIdOrName, '_' . $fieldGroupName ) !== 0 ) {
					// This is the raw syntax of [_FIELD_NAME__INDEX__FIELD_NAME] but we failed to find it so lets just stop here:
					continue;
				}

				list( $i, $name )		=	array_pad( explode( '__', str_replace( ( ! $substitution ? '_' : null ) . $fieldGroupName . '__', '', $fieldIdOrName ), 2 ), 2, null );

				if ( ! $name ) {
					list( $i, $name )	=	array_pad( explode( '_', str_replace( ( ! $substitution ? '_' : null ) . $fieldGroupName . '_', '', $fieldIdOrName ), 2 ), 2, null );
				}

				if ( ! $name ) {
					continue;
				}

				// Get the field group field using normal field fetch behavior to ensure they can access it:
				$fieldGroupFields		=	\CBuser::getInstance( $user->get( 'id', 0, GetterInterface::INT ), false )->_getCbTabs( false )->_getTabFieldsDb( $tabid, $user, $reason, $fieldGroupName, true, $fullAccess );

				if ( ! $fieldGroupFields ) {
					continue;
				}

				// Now lets grab the repeated fields for this group since we found a field group field:
				$fieldGroupField		=	CBFieldGroups::getGroupedFields( $fieldGroupFields[0], $user, $reason, null, $i );

				if ( ! isset( $fieldGroupField[$name] ) ) {
					continue;
				}

				// The field attempting to be called is available so lets load it into the fields array (note $fieldIdOrName usage does not use fieldid index):
				$fields[0]				=	$fieldGroupField[$name];
			}
		}

		// We need to be sure the original grouped field is removed and no longer accessible as we're just using it as a base:
		if ( $fullAccess ) {
			return;
		}

		foreach ( $fields as $k => $field ) {
			if ( ! in_array( $field->get( 'fieldid', 0, GetterInterface::INT ), $groupedFields ) ) {
				continue;
			}

			if ( $field->get( '_isGrouped', false, GetterInterface::BOOLEAN ) || $user->get( '_isFieldGroup', false, GetterInterface::BOOLEAN ) ) {
				// The field is grouped so we still need to shut off certain features that don't work with grouped fields, but we don't want to remove it so it can still substitute in:
				if ( ! in_array( $reason, array( 'register', 'edit', 'search' ) ) ) {
					$field->set( '_noAjax', true ); // CB Core Fields Ajax
				}

				continue;
			}

			if ( $fieldIdOrName ) {
				continue;
			}

			// We only want to remove the field if it's being output outside of a field group and only if it's not being directly called:
			unset( $fields[$k] );
		}
	}
}