<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Database\Table\TabTable;
use CB\Plugin\GroupJive\CBGroupJive;
use CB\Plugin\GroupJiveWall\CBGroupJiveWall;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

global $_PLUGINS;

$_PLUGINS->loadPluginGroup( 'user' );

class CBplug_cbgroupjivewall extends cbPluginHandler
{

	/**
	 * @param  TabTable   $tab       Current tab
	 * @param  UserTable  $user      Current user
	 * @param  int        $ui        1 front, 2 admin UI
	 * @param  array      $postdata  Raw unfiltred POST data
	 */
	public function getCBpluginComponent( $tab, $user, $ui, $postdata )
	{
		$format					=	$this->getInput()->getString( 'format' );

		if ( $format !== 'raw' ) {
			outputCbJs();
			outputCbTemplate();
		}

		$action					=	$this->getInput()->getString( 'action' );
		$function				=	$this->getInput()->getString( 'func' );
		$id						=	$this->getInput()->getInt( 'id', 0 );

		if ( $user === null ) {
			$user				=	CBuser::getMyUserDataInstance();
		}

		if ( $format !== 'raw' ) {
			ob_start();
		}

		if ( $action === 'wall' ) {
			switch ( $function ) {
				case 'publish':
					$this->stateWall( 1, $id, $user );
					break;
				case 'unpublish':
					$this->stateWall( 0, $id, $user );
					break;
				case 'delete':
					$this->deleteWall( $id, $user );
					break;
				case 'new':
					$this->showWallEdit( null, $user );
					break;
				case 'edit':
					$this->showWallEdit( $id, $user );
					break;
				case 'save':
					cbSpoofCheck( 'plugin' );
					$this->saveWallEdit( $id, $user );
					break;
			}
		}

		if ( $format !== 'raw' ) {
			$html				=	ob_get_clean();

			$gjClass			=	CBGroupJive::getGlobalParams()->getString( 'general_class' );

			$return				=	'<div class="cbGroupJive' . ( $gjClass ? ' ' . htmlspecialchars( $gjClass ) : null ) . '">'
								.		$html
								.	'</div>';

			echo $return;
		}
	}

	/**
	 * prepare frontend wall edit render
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function showWallEdit( $id, $user )
	{
		global $_CB_framework;

		$row					=	CBGroupJiveWall::getPost( (int) $id );
		$isModerator			=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$groupId				=	$this->getInput()->getInt( 'group' );

		if ( $groupId === null ) {
			$group				=	$row->group();
		} else {
			$group				=	CBGroupJive::getGroup( $groupId );
		}

		$returnUrl				=	$_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) );

		if ( ! CBGroupJive::canAccessGroup( $group, $user ) ) {
			cbRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
		} elseif ( ! $isModerator ) {
			if ( ( ! $row->getInt( 'id', 0 ) ) && ( ! CBGroupJive::canCreateGroupContent( $user, $group, 'wall' ) ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to post in this group.' ), 'error' );
			} elseif ( $row->getInt( 'id', 0 )
					   && ( CBGroupJive::getGroupStatus( $user, $group ) < 2 )
					   && ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) )
			) {
				cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to edit this post.' ), 'error' );
			}
		}

		CBGroupJive::getTemplate( 'wall_edit', true, true, $this->element );

		$input					=	array();

		$publishedTooltip		=	cbTooltip( null, CBTxt::T( 'Select publish state of this post. Unpublished posts will not be visible to the public.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['published']		=	moscomprofilerHTML::yesnoButtonList( 'published', $publishedTooltip, $this->getInput()->getInt( 'post/published', $row->getInt( 'published', 1 ) ) );

		$postTooltip			=	cbTooltip( null, CBTxt::T( 'Input the post to share.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['post']			=	'<textarea id="post" name="post" class="form-control required" cols="55" rows="8"' . $postTooltip . '>' . htmlspecialchars( $this->getInput()->getHtml( 'post/post', $row->getHtml( 'post' ) ) ) . '</textarea>';

		$ownerTooltip			=	cbTooltip( null, CBTxt::T( 'Input the post owner id. Post owner determines the creator of the post specified as User ID.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['user_id']		=	'<input type="text" id="user_id" name="user_id" value="' . $this->getInput()->getInt( 'post/user_id', $this->getInput()->getInt( 'user', $row->getInt( 'user_id', $user->getInt( 'id', 0 ) ) ) ) . '" class="digits required form-control" size="6"' . $ownerTooltip . ' />';

		HTML_groupjiveWallEdit::showWallEdit( $row, $input, $group, $user, $this );
	}

	/**
	 * save wall
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function saveWallEdit( $id, $user )
	{
		global $_CB_framework;

		$row					=	CBGroupJiveWall::getPost( (int) $id );
		$isModerator			=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$groupId				=	$this->getInput()->getInt( 'group' );

		if ( $groupId === null ) {
			$group				=	$row->group();
		} else {
			$group				=	CBGroupJive::getGroup( $groupId );
		}

		$returnUrl				=	$_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) );

		if ( ! CBGroupJive::canAccessGroup( $group, $user ) ) {
			cbRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
		} elseif ( ! $isModerator ) {
			if ( ( ! $row->getInt( 'id', 0 ) ) && ( ! CBGroupJive::canCreateGroupContent( $user, $group, 'wall' ) ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to post in this group.' ), 'error' );
			} elseif ( $row->getInt( 'id', 0 )
					   && ( CBGroupJive::getGroupStatus( $user, $group ) < 2 )
					   && ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) )
			) {
				cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to edit this post.' ), 'error' );
			}
		}

		$replyId				=	$this->getInput()->getInt( 'reply', 0 );

		if ( $replyId ) {
			$reply				=	CBGroupJiveWall::getPost( $replyId );

			if ( ! $reply->getInt( 'id', 0 ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'Reply does not exist.' ), 'error' );
			}

			$row->set( 'reply', $reply->getInt( 'id', 0 ) );
		}

		$canModerate			=	( CBGroupJive::getGroupStatus( $user, $group ) >= 2 );

		if ( $isModerator ) {
			$row->set( 'user_id', $this->getInput()->getInt( 'post/user_id', $row->getInt( 'user_id', $user->getInt( 'id', 0 ) ) ) );
		} else {
			$row->set( 'user_id', $row->getInt( 'user_id', $user->getInt( 'id', 0 ) ) );
		}

		$row->set( 'published', ( $isModerator || $canModerate || ( $row->getInt( 'id', 0 ) && ( $row->getInt( 'published', 0 ) !== -1 ) ) || ( $group->params()->getInt( 'wall', 1 ) !== 2 ) ? $this->getInput()->getInt( 'post/published', $row->getInt( 'published', 1 ) ) : -1 ) );
		$row->set( 'group', $group->getInt( 'id', 0 ) );

		$postLimit				=	( $isModerator ? 0 : $this->params->getInt( 'groups_wall_character_limit', 400 ) );
		$post					=	trim( $this->getInput()->getHtml( 'post', $row->getHtml( 'post' ) ) );

		// Remove duplicate spaces:
		$post					=	preg_replace( '/ {2,}/i', ' ', $post );
		// Remove duplicate tabs:
		$post					=	preg_replace( '/\t{2,}/i', "\t", $post );
		// Remove duplicate linebreaks:
		$post					=	preg_replace( '/((?:\r\n|\r|\n){2})(?:\r\n|\r|\n)*/i', '$1', $post );
		// Remove trailing spaces:
		$post					=	trim( $post );

		if ( $postLimit && ( cbutf8_strlen( $post ) > $postLimit ) ) {
			$_CB_framework->enqueueMessage( CBTxt::T( 'GROUP_POST_FAILED_TO_SAVE', 'Post failed to save! Error: [error]', array( '[error]' => CBTxt::T( 'Message too long!' ) ) ), 'error' );

			$this->showWallEdit( $id, $user );
			return;
		}

		$row->set( 'post', $post );

		$new					=	( ! $row->getInt( 'id', 0 ) );

		if ( $row->getError() || ( ! $row->check() ) ) {
			$_CB_framework->enqueueMessage( CBTxt::T( 'GROUP_POST_FAILED_TO_SAVE', 'Post failed to save! Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );

			$this->showWallEdit( $id, $user );
			return;
		}

		if ( $row->getError() || ( ! $row->store() ) ) {
			$_CB_framework->enqueueMessage( CBTxt::T( 'GROUP_POST_FAILED_TO_SAVE', 'Post failed to save! Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );

			$this->showWallEdit( $id, $user );
			return;
		}

		if ( $new ) {
			$extra				=	array(	'wall_id'	=>	$row->getInt( 'id', 0 ),
											'wall_post'	=>	$row->post()
										);

			if ( $row->getInt( 'published', 0 ) === 1 ) {
				if ( $row->reply()->getInt( 'id', 0 ) ) {
					CBGroupJive::sendNotifications( 'wall_reply', CBTxt::T( 'New group post reply' ), CBTxt::T( '[user] has posted a reply on the wall in the group [group]!' ), $row->group(), $row->getInt( 'user_id', 0 ), $row->reply()->getInt( 'user_id', 0 ), array( $user->getInt( 'id', 0 ) ), 1, $extra );
				} else {
					CBGroupJive::sendNotifications( 'wall_new', CBTxt::T( 'New group post' ), CBTxt::T( '[user] has posted on the wall in the group [group]!' ), $row->group(), $row->getInt( 'user_id', 0 ), null, array( $user->getInt( 'id', 0 ) ), 1, $extra );
				}
			} elseif ( ( $row->getInt( 'published', 0 ) === -1 ) && ( $row->group()->params()->getInt( 'wall', 1 ) === 2 ) ) {
				CBGroupJive::sendNotifications( 'wall_approve', CBTxt::T( 'New group post awaiting approval' ), CBTxt::T( '[user] has posted on the wall in the group [group] and is awaiting approval!' ), $row->group(), $row->getInt( 'user_id', 0 ), null, array( $user->getInt( 'id', 0 ) ), 2, $extra );

				cbRedirect( $returnUrl, CBTxt::T( 'Posted successfully and awaiting approval!' ) );
			}

			cbRedirect( $returnUrl, CBTxt::T( 'Posted successfully!' ) );
		} else {
			cbRedirect( $returnUrl, CBTxt::T( 'Post saved successfully!' ) );
		}
	}

	/**
	 * set wall publish state status
	 *
	 * @param int       $state
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function stateWall( $state, $id, $user )
	{
		global $_CB_framework;

		$row				=	CBGroupJiveWall::getPost( (int) $id );
		$returnUrl			=	$_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->getInt( 'group', 0 ) ) );

		if ( $row->getInt( 'id', 0 ) ) {
			if ( ! CBGroupJive::canAccessGroup( $row->group(), $user ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
			} elseif ( ! CBGroupJive::isModerator( $user->getInt( 'id', 0 ) ) ) {
				if ( CBGroupJive::getGroupStatus( $user, $row->group() ) < 2 ) {
					if ( ( $row->getInt( 'published', 0 ) === -1 )
						 && ( $user->getInt( 'id', 0 ) === $row->getInt( 'user_id', 0 ) )
						 && ( $row->group()->params()->getInt( 'wall', 1 ) === 2 )
					) {
						cbRedirect( $returnUrl, CBTxt::T( 'Your post is awaiting approval.' ), 'error' );
					} elseif ( ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) ) ) {
						cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to publish or unpublish this post.' ), 'error' );
					}
				}
			}
		} else {
			cbRedirect( $returnUrl, CBTxt::T( 'Post does not exist.' ), 'error' );
		}

		$currentState		=	$row->getInt( 'published', 0 );

		$row->set( 'published', (int) $state );

		if ( $row->getError() || ( ! $row->store() ) ) {
			cbRedirect( $returnUrl, CBTxt::T( 'GROUP_POST_STATE_FAILED_TO_SAVE', 'Post state failed to saved. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		if ( $state && ( $currentState === -1 ) ) {
			$extra			=	array(	'wall_id'	=>	$row->getInt( 'id', 0 ),
										'wall_post'	=>	$row->post()
									);

			if ( $row->getInt( 'user_id', 0 ) !== $user->getInt( 'id', 0 ) ) {
				CBGroupJive::sendNotification( 'wall_approved', 4, $user, $row->getInt( 'user_id', 0 ), CBTxt::T( 'Wall post request accepted' ), CBTxt::T( 'Your wall post request in the group [group] has been accepted!' ), $row->group() );
			}

			if ( $row->reply()->getInt( 'id', 0 ) ) {
				CBGroupJive::sendNotifications( 'wall_reply', CBTxt::T( 'New group post reply' ), CBTxt::T( '[user] has posted a reply on the wall in the group [group]!' ), $row->group(), $row->getInt( 'user_id', 0 ), $row->reply()->getInt( 'user_id', 0 ), array( $user->getInt( 'id', 0 ) ), 1, $extra );
			} else {
				CBGroupJive::sendNotifications( 'wall_new', CBTxt::T( 'New group post' ), CBTxt::T( '[user] has posted on the wall in the group [group]!' ), $row->group(), $row->getInt( 'user_id', 0 ), null, array( $user->getInt( 'id', 0 ) ), 1, $extra );
			}
		}

		cbRedirect( $returnUrl, CBTxt::T( 'Post state saved successfully!' ) );
	}

	/**
	 * delete wall
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function deleteWall( $id, $user )
	{
		global $_CB_framework;

		$row			=	CBGroupJiveWall::getPost( (int) $id );
		$returnUrl		=	$_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->getInt( 'group', 0 ) ) );

		if ( $row->getInt( 'id', 0 ) ) {
			if ( ! CBGroupJive::canAccessGroup( $row->group(), $user ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
			} elseif ( ! CBGroupJive::isModerator( $user->getInt( 'id', 0 ) ) ) {
				if ( ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) ) && ( CBGroupJive::getGroupStatus( $user, $row->group() ) < 2 ) ) {
					cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to delete this post.' ), 'error' );
				}
			}
		} else {
			cbRedirect( $returnUrl, CBTxt::T( 'Post does not exist.' ), 'error' );
		}

		if ( ! $row->canDelete() ) {
			cbRedirect( $returnUrl, CBTxt::T( 'GROUP_POST_FAILED_TO_DELETE', 'Post failed to delete. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		if ( ! $row->delete() ) {
			cbRedirect( $returnUrl, CBTxt::T( 'GROUP_POST_FAILED_TO_DELETE', 'Post failed to delete. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		cbRedirect( $returnUrl, CBTxt::T( 'Post deleted successfully!' ) );
	}

}