<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\Gallery\CBGallery;
use CB\Plugin\Gallery\Table\ItemTable;
use CB\Plugin\Gallery\Gallery;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_cbgalleryItemEditMicro
{

	/**
	 * @param ItemTable       $row
	 * @param UserTable       $viewer
	 * @param Gallery         $gallery
	 * @param cbPluginHandler $plugin
	 * @param string          $output
	 * @return string
	 */
	public static function showItemEditMicro( $row, $viewer, $gallery, $plugin, $output = null )
	{
		global $_CB_framework;

		static $JS_LOADED	=	0;

		if ( ! $JS_LOADED++ ) {
			$_CB_framework->outputCbJQuery( "$( '.galleryItemEditMicro' ).cbgallery({ mode: 'edit' });", 'cbgallery' );
		}

		$type				=	$row->getString( 'type' );

		$return				=	'<div class="position-relative col-6 col-sm-4 col-lg-3 galleryEdit galleryItemEditMicro">'
							.		HTML_cbgalleryItemContainer::showItemContainer( $row, $viewer, $gallery, $plugin, 'preview' )
							.		'<div class="position-absolute w-100 p-1 bg-white border galleryItemEditMicroActions">'
										// CBTxt::T( 'ARE_YOU_SURE_DELETE_TYPE', 'Are you sure you want to delete this [type]?', array( '[type]' => CBGallery::translateType( $type, false, true ) ) )
							.			'<button type="button" class="btn btn-sm btn-danger btn-block galleryEditDelete galleryButton galleryButtonDelete" data-cbgallery-delete-message="' . htmlspecialchars( CBTxt::T( 'ARE_YOU_SURE_DELETE_' . strtoupper( $type ) . ' ARE_YOU_SURE_DELETE_TYPE', 'Are you sure you want to delete this [type]?', array( '[type]' => CBGallery::translateType( $type, false, true ) ) ) ) . '" data-cbgallery-delete-url="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'item', 'func' => 'delete', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id() ), 'raw', 0, true ) . '" ' . cbValidator::getSubmitBtnHtmlAttributes() . '>' . CBTxt::T( 'Delete' ) . '</button>'
							.		'</div>'
							.		'<input type="hidden" name="items[]" value="' . $row->getInt( 'id', 0 ) . '" />'
							.		'<div class="position-absolute d-flex flex-column justify-content-center align-items-center w-100 h-100 bg-dark text-white galleryEditLoading hidden"><div class="spinner-border spinner-border-sm text-secondary"></div></div>'
							.		( $output === 'ajax' ? CBGallery::reloadHeaders() : null )
							.	'</div>';

		return $return;
	}
}