<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Application\Application;
use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\Gallery\CBGallery;
use CB\Plugin\Gallery\Table\ItemTable;
use CB\Plugin\Gallery\Gallery;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_cbgalleryItemEdit
{

	/**
	 * @param ItemTable        $row
	 * @param array            $input
	 * @param UserTable        $viewer
	 * @param Gallery          $gallery
	 * @param CBplug_cbgallery $plugin
	 */
	public static function showItemEdit( $row, $input, $viewer, $gallery, $plugin )
	{
		global $_CB_framework, $_PLUGINS;

		$canModerate				=	CBGallery::canModerate( $gallery );
		$canUpload					=	CBGallery::canCreateItems( 'all', 'upload', $gallery );
		$canLink					=	CBGallery::canCreateItems( 'all', 'link', $gallery );
		$type						=	$row->getString( 'type' );

		if ( $row->getInt( 'id', 0 ) ) {
			// CBTxt::T( 'EDIT_TYPE_NAME', 'Edit [type]: [name]', array( '[type]' => CBGallery::translateType( $type ), '[name]' => ( $row->getString( 'title' ) ? $row->getString( 'title' ) : $row->name() ) ) )
			$pageTitle				=	CBTxt::T( 'EDIT_' . strtoupper( $type ) . '_NAME EDIT_TYPE_NAME', 'Edit [type]: [name]', array( '[type]' => CBGallery::translateType( $type ), '[name]' => ( $row->getString( 'title' ) ? $row->getString( 'title' ) : $row->name() ) ) );
		} else {
			if ( $canUpload && $canLink ) {
				$pageTitle			=	CBTxt::T( 'Upload / Link New Media' );
			} elseif ( $canLink ) {
				$pageTitle			=	CBTxt::T( 'Link New Media' );
			} else {
				$pageTitle			=	CBTxt::T( 'Upload New Media' );
			}
		}

		$returnUrl					=	CBGallery::getReturn( true, true );

		if ( ! $returnUrl ) {
			$returnUrl				=	$gallery->location();
		}

		if ( $pageTitle ) {
			if ( $row->getInt( 'folder', 0 ) ) {
				$folder				=	$row->folder( $gallery );

				if ( $folder->getInt( 'id', 0 ) && ( ( $folder->getInt( 'published', 1 ) ) || ( ( $viewer->getInt( 'id', 0 ) === $folder->getInt( 'user_id', 0 ) ) || $canModerate ) ) ) {
					$pageTitle		.=	' ' . CBTxt::T( 'IN_FOLDER', 'in [folder]', array( '[folder]' => ( $folder->getString( 'title' ) ? $folder->getString( 'title' ) : cbFormatDate( $folder->getString( 'date' ), true, false, CBTxt::T( 'GALLERY_LONG_DATE_FORMAT', 'F j, Y' ) ) ) ) );
				}
			}

			$_CB_framework->setPageTitle( $pageTitle );
		}

		$integrations				=	$_PLUGINS->trigger( 'gallery_onBeforeItemEdit', array( &$row, &$input, $viewer, $gallery ) );

		static $JS_LOADED			=	0;

		if ( ! $JS_LOADED++ ) {
			initToolTip();
			cbValidator::loadValidation();

			$_CB_framework->outputCbJQuery( "$( '.galleryItemEdit select.galleryCBSelect' ).cbselect();", 'cbselect' );
		}

		$return						=	'<div class="galleryItemEdit">'
									.		'<form action="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'item', 'func' => 'save', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id(), 'return' => CBGallery::getReturn( true ) ) ) . '" method="post" enctype="multipart/form-data" name="galleryItemForm" id="galleryItemForm" class="form-auto m-0 cb_form galleryItemForm cbValidation">'
									.			( $pageTitle ? '<div class="mb-3 border-bottom cb-page-header galleryItemTitle"><h3 class="m-0 p-0 mb-2 cb-page-header-title">' . $pageTitle . '</h3></div>' : null )
									.			HTML_cbgalleryIntegrationEdit::showIntegrationEdit( $integrations );

		if ( $canModerate || ( ! $gallery->getBool( $type . '_create_approval', false ) ) || ( $row->getInt( 'id', 0 ) && ( $row->getInt( 'published', 0 ) !== -1 ) ) ) {
			$return					.=			'<div class="cbft_select cbtt_select form-group row no-gutters cb_form_line">'
									.				'<label for="published" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Published' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['published']
									.					getFieldIcons( null, 0, null, CBTxt::T( 'Select publish status of the file. If unpublished the file will not be visible to the public.' ) )
									.				'</div>'
									.			'</div>';
		}

		$return						.=			'<div class="cbft_text cbtt_input form-group row no-gutters cb_form_line">'
									.				'<label for="title" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Title' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['title']
									.					getFieldIcons( null, 0, null, CBTxt::T( 'Optionally input a title. If no title is provided the filename will be displayed as the title.' ) )
									.				'</div>'
									.			'</div>';

		if ( $gallery->getBool( 'folders', true ) && $input['folder'] ) {
			$return					.=			'<div class="cbft_select cbtt_select form-group row no-gutters cb_form_line">'
									.				'<label for="folder" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Album' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['folder']
									.					getFieldIcons( null, 0, null, CBTxt::T( 'Select the album for this file.' ) )
									.				'</div>'
									.			'</div>';
		}

		$return						.=			'<div class="cbft_textarea cbtt_textarea form-group row no-gutters cb_form_line">'
									.				'<label for="description" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Description' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['description']
									.					getFieldIcons( null, 0, null, CBTxt::T( 'Optionally input a description.' ) )
									.				'</div>'
									.			'</div>';

		if ( $row->getInt( 'id', 0 ) ) {
			$return					.=			'<div class="cbft_delimiter form-group row no-gutters cb_form_line">'
									.				'<label for="method" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'File' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					'<div class="form-control-plaintext">'
									.						HTML_cbgalleryEmbed::showEmbed( $row, $viewer, $gallery, $plugin, false, true )
									.					'</div>'
									.				'</div>'
									.			'</div>';
		}

		if ( $input['method'] ) {
			$return					.=			'<div id="itemMethod" class="cbft_select cbtt_select form-group row no-gutters cb_form_line">'
									.				( ! $row->getInt( 'id', 0 ) ? '<label for="method" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'File' ) . '</label>' : null )
									.				'<div class="cb_field' . ( $row->getInt( 'id', 0 ) ? ' offset-sm-3' : null ) . ' col-sm-9">'
									.					$input['method']
									.				'</div>'
									.			'</div>';
		}

		if ( $input['upload'] ) {
			$return					.=			'<div id="itemUpload" class="cbft_file cbtt_input form-group row no-gutters cb_form_line' . ( $input['method'] ? ' hidden' : null ) . '">'
									.				( ( ! $row->getInt( 'id', 0 ) ) && ( ! $input['method'] ) ? '<label for="upload" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'File' ) . '</label>' : null )
									.				'<div class="cb_field' . ( $row->getInt( 'id', 0 ) || $input['method'] ? ' offset-sm-3' : null ) . ' col-sm-9">'
									.					$input['upload']
									.					getFieldIcons( null, ( ! $row->getInt( 'id', 0 ) ? 1 : 0 ), null, CBTxt::T( 'Select the file to upload.' ) )
									.					( $input['upload_limits'] ? '<div class="form-text">' . implode( ' ', $input['upload_limits'] ) . '</div>' : null )
									.				'</div>'
									.			'</div>';
		}

		if ( $input['link'] ) {
			$return					.=			'<div id="itemLink" class="cbft_text cbtt_input form-group row no-gutters cb_form_line' . ( $input['method'] ? ' hidden' : null ) . '">'
									.				( ( ! $row->getInt( 'id', 0 ) ) && ( ! $input['method'] ) ? '<label for="link" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'File' ) . '</label>' : null )
									.				'<div class="cb_field' . ( $row->getInt( 'id', 0 ) || $input['method'] ? ' offset-sm-3' : null ) . ' col-sm-9">'
									.					$input['link']
									.					getFieldIcons( null, ( ! $row->getInt( 'id', 0 ) ? 1 : 0 ), null, CBTxt::T( 'Input the URL to the file to link.' ) )
									.					( $input['link_limits'] ? '<div class="form-text">' . implode( ' ', $input['link_limits'] ) . '</div>' : null )
									.				'</div>'
									.			'</div>';
		}

		if ( $input['thumbnail_upload'] || $input['thumbnail_link'] ) {
			if ( $input['thumbnail_preview'] ) {
				$return				.=			'<div class="cbft_delimiter form-group row no-gutters cb_form_line">'
									.				'<label for="' . ( $input['thumbnail_method'] ? 'thumbnail_method' : ( $input['thumbnail_upload'] ? 'thumbnail_upload' : ( $input['thumbnail_link'] ? 'thumbnail_link' : '' ) ) ) . '" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Thumbnail' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					'<div class="form-control-plaintext">'
									.						$input['thumbnail_preview']
									.					'</div>'
									.				'</div>'
									.			'</div>';
			}

			if ( $input['thumbnail_method'] ) {
				$return				.=			'<div id="itemThumbnailMethod" class="cbft_select cbtt_select form-group row no-gutters cb_form_line">'
									.				( ! $input['thumbnail_preview'] ? '<label for="thumbnail_method" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Thumbnail' ) . '</label>' : null )
									.				'<div class="cb_field' . ( $input['thumbnail_preview'] ? ' offset-sm-3' : null ) . ' col-sm-9">'
									.					$input['thumbnail_method']
									.				'</div>'
									.			'</div>';
			}

			if ( $input['thumbnail_upload'] ) {
				$return				.=			'<div id="itemThumbnailUpload" class="cbft_file cbtt_input form-group row no-gutters cb_form_line' . ( $input['thumbnail_method'] ? ' hidden' : null ) . '">'
									.				( ( ! $input['thumbnail_preview'] ) && ( ! $input['thumbnail_method'] ) ? '<label for="thumbnail_upload" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Thumbnail' ) . '</label>' : null )
									.				'<div class="cb_field' . ( ( $input['thumbnail_preview'] ) || ( $input['thumbnail_method'] ) ? ' offset-sm-3' : null ) . ' col-sm-9">'
									.					$input['thumbnail_upload']
									.					getFieldIcons( null, 0, null, CBTxt::T( 'Optionally select the thumbnail file to upload.' ) )
									.					( $input['thumbnail_upload_limits'] ? '<div class="form-text">' . implode( ' ', $input['thumbnail_upload_limits'] ) . '</div>' : null )
									.				'</div>'
									.			'</div>';
			}

			if ( $input['thumbnail_link'] ) {
				$return				.=			'<div id="itemThumbnailLink" class="cbft_text cbtt_input form-group row no-gutters cb_form_line' . ( $input['thumbnail_method'] ? ' hidden' : null ) . '">'
									.				( ( ! $input['thumbnail_preview'] ) && ( ! $input['thumbnail_method'] ) ? '<label for="thumbnail_link" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Thumbnail' ) . '</label>' : null )
									.				'<div class="cb_field' . ( ( $input['thumbnail_preview'] ) || ( $input['thumbnail_method'] ) ? ' offset-sm-3' : null ) . ' col-sm-9">'
									.					$input['thumbnail_link']
									.					getFieldIcons( null, 0, null, CBTxt::T( 'Optionally input the URL to the thumbnail file to link.' ) )
									.					( $input['thumbnail_link_limits'] ? '<div class="form-text">' . implode( ' ', $input['thumbnail_link_limits'] ) . '</div>' : null )
									.				'</div>'
									.			'</div>';
			}
		}

		$return						.=	HTML_cbgalleryIntegrationEdit::showIntegrationEdit( $_PLUGINS->trigger( 'gallery_onAfterItemEdit', array( $row, $input, $viewer, $gallery ) ) );

		if ( Application::MyUser()->isGlobalModerator() ) {
			$return					.=			'<div class="cbft_text cbtt_input form-group row no-gutters cb_form_line">'
									.				'<label for="user_id" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Owner' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['user_id']
									.					getFieldIcons( null, 1, null, CBTxt::T( 'Input owner as single integer user_id.' ) )
									.				'</div>'
									.			'</div>';
		}

		if ( $gallery->getBool( 'items_create_captcha', false ) && ( ! $canModerate ) ) {
			$_PLUGINS->loadPluginGroup( 'user' );

			$captcha				=	$_PLUGINS->trigger( 'onGetCaptchaHtmlElements', array( false ) );

			if ( ! empty( $captcha ) ) {
				$captcha			=	$captcha[0];

				$return				.=			'<div class="cbft_delimiter form-group row no-gutters cb_form_line">'
									.				'<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Captcha' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					( isset( $captcha[0] ) ? $captcha[0] : null )
									.				'</div>'
									.			'</div>'
									.			'<div class="cbft_text cbtt_input form-group row no-gutters cb_form_line">'
									.				'<div class="cb_field offset-sm-3 col-sm-9">'
									.					str_replace( 'inputbox', 'form-control', ( isset( $captcha[1] ) ? $captcha[1] : null ) )
									.					getFieldIcons( null, 1, null )
									.				'</div>'
									.			'</div>';
			}
		}

		$return						.=			'<div class="row no-gutters">'
									.				'<div class="offset-sm-3 col-sm-9">'
									.					'<button type="submit" class="btn btn-primary btn-sm-block galleryButton galleryButtonSubmit" ' . cbValidator::getSubmitBtnHtmlAttributes() . '>' . ( $row->getInt( 'id', 0 ) ? CBTxt::T( 'UPDATE_TYPE', 'Update [type]', array( '[type]' => CBGallery::translateType( $type ) ) ) : ( $canUpload && $canLink ? CBTxt::T( 'Create Upload / Link' ) : ( $canUpload ? CBTxt::T( 'Create Upload' ) : CBTxt::T( 'Create Link' ) ) ) ) . '</button>'
									.					' <button type="button" class="btn btn-secondary btn-sm-block galleryButton galleryButtonCancel" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to cancel? All unsaved data will be lost!' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( htmlspecialchars( $returnUrl ) ) . '\'; })">' . CBTxt::T( 'Cancel' ) . '</button>'
									.				'</div>'
									.			'</div>'
									.			cbGetSpoofInputTag( 'plugin' )
									.		'</form>'
									.	'</div>';

		echo $return;
	}
}