<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_cbgalleryIntegrationEdit
{

	/**
	 * Converts trigger output to edit rows
	 *
	 * @param array $integrations
	 * @return string
	 */
	public static function showIntegrationEdit( $integrations )
	{
		$return						=	null;

		foreach ( $integrations as $integration ) {
			if ( is_array( $integration ) ) {
				if ( isset( $integration[1] ) ) {
					$intLabel		=	( isset( $integration[0] ) ? $integration[0] : null );
					$intInput		=	( isset( $integration[1] ) ? $integration[1] : null );
					$intFor			=	( isset( $integration[2] ) ? $integration[2] : null );
				} else {
					$intLabel		=	null;
					$intInput		=	( isset( $integration[1] ) ? $integration[1] : null );
					$intFor			=	null;
				}

				if ( ! $intInput ) {
					continue;
				}

				if ( preg_match( '/^(?:<(select|input|textarea|button)|(?:<[^<]+form-(group)[^>]+>))/i', trim( $intInput ), $matches ) ) {
					$intTag			=	( isset( $matches[2] ) ? $matches[2] : ( isset( $matches[1] ) ? $matches[1] : null ) );
				} else {
					$intTag			=	null;
				}

				$return				.=	'<div class="' . ( $intTag ? 'cbtt_' . $intTag . ' ' : null ) . 'form-group row no-gutters cb_form_line">'
									.		( $intLabel ? '<label' . ( $intFor ? ' for="' . htmlspecialchars( $intFor ) . '"' : null ) . ' class="col-form-label col-sm-3 pr-sm-2">' . $intLabel . '</label>' : null )
									.		'<div class="cb_field col-sm-9">'
									.			( ! $intTag ? '<div class="form-control-plaintext">' . $intInput . '</div>' : $intInput )
									.		'</div>'
									.	'</div>';
			} else {
				$return				.=	$integration;
			}
		}

		return $return;
	}
}