<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\UserTable;
use CB\Plugin\Gallery\Table\FolderTable;
use CB\Plugin\Gallery\Gallery;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_cbgalleryFolders
{

	/**
	 * @param FolderTable[]    $rows
	 * @param cbPageNav        $pageNav
	 * @param UserTable        $viewer
	 * @param Gallery          $gallery
	 * @param CBplug_cbgallery $plugin
	 * @param string           $output
	 * @return string
	 */
	public static function showFolders( $rows, $pageNav, $viewer, $gallery, $plugin, $output = null )
	{
		$return				=	'<div class="galleryFoldersContainer">';

		if ( $rows ) {
			$return			.=		'<div class="d-flex flex-wrap no-gutters galleryFoldersRows">';

			foreach ( $rows as $row ) {
				$return		.=			HTML_cbgalleryFolderContainer::showFolderContainer( $row, $viewer, $gallery, $plugin, $output );
			}

			$return			.=		'</div>';

			if ( $gallery->getBool( 'folders_paging', true ) && ( $pageNav->total > $pageNav->limit ) ) {
				$return		.=		'<div class="mt-3 galleryFoldersPaging">'
							.			$pageNav->getListLinks()
							.		'</div>';
			}
		}

		$return				.=		$pageNav->getLimitBox( false )
							.	'</div>';

		return $return;
	}
}