<?php
/**
 * Community Builder (TM)
 * @version $Id: $
 * @package CommunityBuilder
 * @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
 * @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
 */

use CB\Plugin\Gallery\CBGallery;
use CBLib\Language\CBTxt;
use CB\Plugin\Gallery\Table\ItemTable;
use CB\Plugin\Gallery\Gallery;
use CB\Database\Table\UserTable;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_cbgalleryEmbed
{

	/**
	 * render frontend gallery activity
	 *
	 * @param ItemTable       $row
	 * @param UserTable       $viewer
	 * @param Gallery         $gallery
	 * @param cbPluginHandler $plugin
	 * @param bool            $thumbnail
	 * @param bool            $asRaw
	 * @return string
	 */
	static function showEmbed( &$row, $viewer, $gallery, $plugin, $thumbnail = false, $asRaw = false )
	{
		global $_CB_framework;

		static $JS_LOADED			=	0;

		if ( ! $JS_LOADED++ ) {
			$js						=	"$( '.galleryToggleMedia' ).on( 'click', function () {"
									.		"if ( $( this ).hasClass( 'galleryToggleMediaOpen' ) ) {"
									.			"return;"
									.		"}"
									.		"if ( $( this ).hasClass( 'galleryToggleMediaMusic' ) ) {"
									.			"$( this ).find( '.galleryToggleMediaPlay' ).addClass( 'hidden' );"
									.		"} else {"
									.			"$( this ).find( '.galleryToggleMediaPreview' ).addClass( 'hidden' );"
									.		"}"
									.		"$( this ).addClass( 'galleryToggleMediaOpen' );"
									.		"$( this ).find( 'iframe,video,audio' ).attr( 'src', $( this ).data( 'cbgallery-video' ) ).removeClass( 'hidden' );"
									.		"$( this ).find( 'video,audio' ).attr( 'autoplay', 'autoplay' );"
									.	"})";

			$_CB_framework->outputCbJQuery( $js );
		}

		$isFileImage				=	false;
		$isFileVideo				=	false;
		$isFileMusic				=	false;

		if ( $row->getString( 'type' ) === 'files' ) {
			$fileExtensionType		=	CBGallery::getExtensionType( $row->extension() );

			$isFileImage			=	( ( $row->extension() === 'svg' ) || ( $fileExtensionType === 'photos' ) );
			$isFileVideo			=	( $fileExtensionType === 'videos' );
			$isFileMusic			=	( $fileExtensionType === 'music' );
		}

		$return						=	null;

		if ( $row->domain() ) {
			$showPath				=	htmlspecialchars( $row->path() );
			$downloadPath			=	null;
		} else {
			$showPath				=	$_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'item', 'func' => ( $thumbnail ? 'preview' : 'show' ), 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id(), 'v' => ( ( $row->getString( 'type' ) === 'photos' ) || $isFileImage ? $row->modified( false, true ) : null ) ), 'raw', 0, true );
			$downloadPath			=	$_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'item', 'func' => 'download', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id() ), 'raw', 0, true );
		}

		switch ( ( $isFileImage ? 'photos' : ( $isFileVideo ? 'videos' : ( $isFileMusic ? 'music' : $row->getString( 'type' ) ) ) ) ) {
			case 'photos':
				$title				=	( $row->getString( 'title' ) ? $row->getString( 'title' ) : $row->name() );
				$width				=	$row->width( $thumbnail, true );
				$height				=	$row->height( $thumbnail, true );

				$return				.=	'<img alt="' . htmlspecialchars( $title ) . '" src="' . $showPath . '" loading="lazy" class="img-fluid cbImgPict cbFullPict"' . ( $width && $height ? ' width="' . $width . '" height="' . $height . '"' : null ) . ' />';
				break;
			case 'files':
				$return				.=	'<div class="table-responsive galleryMediaFile">'
									.		'<table class="table table-sm table-bordered w-100 m-0 galleryMediaFileTable">'
									.			'<tbody>'
									.				'<tr>'
									.					'<th style="width: 150px;" class="d-block d-md-table-cell w-md-100">' . CBTxt::T( 'File' ) . '</th>'
									.					'<td class="d-block d-md-table-cell w-md-100 text-wrap"><a href="' . $showPath . '" target="_blank" rel="nofollow noopener">' . $row->name() . '</a></td>'
									.				'</tr>'
									.				'<tr>'
									.					'<th style="width: 150px;" class="d-block d-md-table-cell w-md-100">' . CBTxt::T( 'Extension' ) . '</th>'
									.					'<td class="d-block d-md-table-cell w-md-100 text-wrap">' . $row->extension() . '</td>'
									.				'</tr>'
									.				'<tr>'
									.					'<th style="width: 150px;" class="d-block d-md-table-cell w-md-100">' . CBTxt::T( 'Size' ) . '</th>'
									.					'<td class="d-block d-md-table-cell w-md-100 text-wrap">' . $row->size() . '</td>'
									.				'</tr>'
									.				'<tr>'
									.					'<th style="width: 150px;" class="d-block d-md-table-cell w-md-100">' . CBTxt::T( 'Modified' ) . '</th>'
									.					'<td class="d-block d-md-table-cell w-md-100 text-wrap">' . cbFormatDate( $row->modified() ) . '</td>'
									.				'</tr>';

				if ( $gallery->getBool( 'files_md5', false ) && $row->params()->getString( 'checksum.md5' ) ) {
					$return			.=				'<tr>'
									.					'<th style="width: 150px;" class="d-block d-md-table-cell w-md-100">' . CBTxt::T( 'MD5 Checksum' ) . '</th>'
									.					'<td class="d-block d-md-table-cell w-md-100 text-wrap">' . $row->params()->getString( 'checksum.md5' ) . '</td>'
									.				'</tr>';
				}

				if ( $gallery->getBool( 'files_sha1', false ) && $row->params()->getString( 'checksum.sha1' ) ) {
					$return			.=				'<tr>'
									.					'<th style="width: 150px;" class="d-block d-md-table-cell w-md-100">' . CBTxt::T( 'SHA1 Checksum' ) . '</th>'
									.					'<td class="d-block d-md-table-cell w-md-100 text-wrap">' . $row->params()->getString( 'checksum.sha1' ) . '</td>'
									.				'</tr>';
				}

				if ( $downloadPath ) {
					$return			.=				'<tr>'
									.					'<td colspan="2" class="d-block d-md-table-cell w-md-100 text-right"><a href="' . $downloadPath . '" class="btn btn-sm btn-primary">' . CBTxt::T( 'Download' ) . '</a></td>'
									.				'</tr>';
				}

				$return				.=			'</tbody>'
									.		'</table>'
									.	'</div>';
				break;
			case 'videos':
				if ( $row->mimeType() === 'video/x-youtube' ) {
					if ( preg_match( '%(?:(?:watch\?v=)|(?:embed/)|(?:shorts/)|(?:be/))([A-Za-z0-9_-]+)%', $showPath, $matches ) ) {
						if ( ! $asRaw ) {
							$return	.=	'<div class="position-relative w-100 mh-100 galleryMediaVideo galleryToggleMedia galleryToggleMediaVideo" data-cbgallery-video="https://www.youtube.com/embed/' . htmlspecialchars( $matches[1] ) . '?autoplay=1">'
									.		'<div class="d-flex flex-column justify-content-center position-absolute w-100 h-100 galleryToggleMediaPreview">'
									.			'<div class="position-absolute display-1 align-middle text-white text-center w-100 galleryToggleMediaPlay">'
									.				'<span class="fa fa-play galleryToggleMediaIcon"></span>'
									.			'</div>'
									.			$row->thumbnail( $gallery )
									.		'</div>'
									.		'<iframe loading="lazy" width="100%" height="100%" style="width: 100%; height: 100%;" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" class="position-absolute galleryVideoPlayer"></iframe>'
									.	'</div>';
						} else {
							$return	.=	'<div class="position-relative w-100 mh-100 galleryMediaVideo">'
									.		'<iframe loading="lazy" width="100%" height="100%" style="width: 100%; height: 100%;" src="https://www.youtube.com/embed/' . htmlspecialchars( $matches[1] ) . '" frameborder="0" allow="fullscreen; picture-in-picture" class="position-absolute galleryVideoPlayer"></iframe>'
									.	'</div>';
						}
					}
				} elseif ( $row->mimeType() === 'video/x-vimeo' ) {
					if ( preg_match( '%/(\d+)$%i', $showPath, $matches ) ) {
						if ( ( ! $asRaw ) && ( $row->getString( 'thumbnail' ) || ( $row->domain() && $row->params()->getString( 'link_thumbnail' ) ) ) ) {
							$return	.=	'<div class="position-relative w-100 mh-100 galleryMediaVideo galleryToggleMedia galleryToggleMediaVideo" data-cbgallery-video="https://player.vimeo.com/video/' . htmlspecialchars( $matches[1] ) . '?autoplay=1">'
									.		'<div class="d-flex flex-column justify-content-center position-absolute w-100 h-100 galleryToggleMediaPreview">'
									.			'<div class="position-absolute display-1 align-middle text-white text-center w-100 galleryToggleMediaPlay">'
									.				'<span class="fa fa-play galleryToggleMediaIcon"></span>'
									.			'</div>'
									.			$row->thumbnail( $gallery )
									.		'</div>'
									.		'<iframe loading="lazy" width="100%" height="100%" style="width: 100%; height: 100%;" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" class="position-absolute galleryVideoPlayer"></iframe>'
									.	'</div>';
						} else {
							$return	.=	'<div class="position-relative w-100 mh-100 galleryMediaVideo">'
									.		'<iframe loading="lazy" width="100%" height="100%" style="width: 100%; height: 100%;" src="https://player.vimeo.com/video/' . htmlspecialchars( $matches[1] ) . '" frameborder="0" allow="fullscreen; picture-in-picture" class="position-absolute galleryVideoPlayer"></iframe>'
									.	'</div>';
						}
					}
				} elseif ( $row->mimeType() === 'video/x-facebook' ) {
					if ( ( ! $asRaw ) && ( $row->getString( 'thumbnail' ) || ( $row->domain() && $row->params()->getString( 'link_thumbnail' ) ) ) ) {
						$return		.=	'<div class="position-relative w-100 mh-100 galleryMediaVideo galleryToggleMedia galleryToggleMediaVideo" data-cbgallery-video="https://www.facebook.com/plugins/video.php?href=' . htmlspecialchars( $showPath ) . '&show_text=false&autoplay=true">'
									.		'<div class="d-flex flex-column justify-content-center position-absolute w-100 h-100 galleryToggleMediaPreview">'
									.			'<div class="position-absolute display-1 align-middle text-white text-center w-100 galleryToggleMediaPlay">'
									.				'<span class="fa fa-play galleryToggleMediaIcon"></span>'
									.			'</div>'
									.			$row->thumbnail( $gallery )
									.		'</div>'
									.		'<iframe loading="lazy" width="100%" height="100%" style="width: 100%; height: 100%;" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" class="position-absolute galleryVideoPlayer"></iframe>'
									.	'</div>';
					} else {
						$return		.=	'<div class="position-relative w-100 mh-100 galleryMediaVideo">'
									.		'<iframe loading="lazy" width="100%" height="100%" style="width: 100%; height: 100%;" src="https://www.facebook.com/plugins/video.php?href=' . htmlspecialchars( $showPath ) . '&show_text=false" frameborder="0" allow="fullscreen; picture-in-picture" class="position-absolute galleryVideoPlayer"></iframe>'
									.	'</div>';
					}
				} else {
					if ( ( ! $asRaw ) && ( $row->getString( 'thumbnail' ) || ( $row->domain() && $row->params()->getString( 'link_thumbnail' ) ) ) ) {
						$return		.=	'<div class="position-relative w-100 mh-100 galleryMediaVideo galleryToggleMedia galleryToggleMediaVideo" data-cbgallery-video="' . $showPath . '">'
									.		'<div class="d-flex flex-column justify-content-center position-absolute w-100 h-100 galleryToggleMediaPreview">'
									.			'<div class="position-absolute display-1 align-middle text-white text-center w-100 galleryToggleMediaPlay">'
									.				'<span class="fa fa-play galleryToggleMediaIcon"></span>'
									.			'</div>'
									.			$row->thumbnail( $gallery )
									.		'</div>'
									.		'<video width="100%" height="100%" style="width: 100%; height: 100%;" type="' . htmlspecialchars( $row->mimeType() ) . '" controls="controls" controlsList="nodownload" preload="auto" class="position-absolute galleryVideoPlayer"></video>'
									.	'</div>';
					} else {
						$return		.=	'<div class="position-relative w-100 mh-100 galleryMediaVideo">'
									.		'<video width="100%" height="100%" style="width: 100%; height: 100%;" src="' . $showPath . '" type="' . htmlspecialchars( $row->mimeType() ) . '" controls="controls" controlsList="nodownload" preload="auto" class="position-absolute galleryVideoPlayer"></video>'
									.	'</div>';
					}
				}
				break;
			case 'music':
				if ( ( ! $asRaw ) && ( $row->getString( 'thumbnail' ) || ( $row->domain() && $row->params()->getString( 'link_thumbnail' ) ) ) ) {
					$return			.=	'<div class="d-flex flex-column justify-content-center position-relative w-100 mh-100 galleryToggleMedia galleryToggleMediaMusic" data-cbgallery-video="' . $showPath . '">'
									.		'<div class="d-flex flex-column justify-content-center w-100 h-100 galleryToggleMediaPreview">'
									.			'<div class="position-absolute display-1 align-middle text-white text-center w-100 galleryToggleMediaPlay">'
									.				'<span class="fa fa-play galleryToggleMediaIcon"></span>'
									.			'</div>'
									.			$row->thumbnail( $gallery )
									.		'</div>'
									.		'<div class="position-absolute p-3 w-100 galleryToggleMediaPlayer">'
									.			'<audio style="width: 100%;" type="' . htmlspecialchars( $row->mimeType() ) . '" controls="controls" controlsList="nodownload" preload="auto" class="galleryAudioPlayer hidden"></audio>'
									.		'</div>'
									.	'</div>';
				} else {
					$return			.=	'<audio style="width: 100%;" src="' . $showPath . '" type="' . htmlspecialchars( $row->mimeType() ) . '" controls="controls" controlsList="nodownload" preload="auto" class="galleryAudioPlayer"></audio>';
				}
				break;
		}

		return $return;
	}
}