<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Plugin\Gallery\CBGallery;
use CB\Plugin\Gallery\Gallery;
use CB\Plugin\Activity\Activity;
use CB\Plugin\Activity\Comments;
use CB\Database\Table\UserTable;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_cbgalleryActivityNew
{

	/**
	 * render frontend activity gallery upload
	 *
	 * @param array             $buttons
	 * @param UserTable         $viewer
	 * @param Activity|Comments $stream
	 * @param Gallery           $gallery
	 * @param cbPluginHandler   $plugin
	 * @param string            $output
	 * @return mixed
	 */
	static function showActivityNew( &$buttons, $viewer, $stream, $gallery, $plugin, $output = null )
	{
		global $_CB_framework;

		$canUpload					=	CBGallery::canCreateItems( 'all', 'upload', $gallery );
		$canLink					=	CBGallery::canCreateItems( 'all', 'link', $gallery );

		if ( ( ! $canUpload ) && ( ! $canLink ) ) {
			return null;
		}

		$icon					=	null;
		$types					=	array();

		if ( CBGallery::canCreateItems( 'photos', 'upload', $gallery ) || CBGallery::canCreateItems( 'photos', 'link', $gallery ) ) {
			$types[]			=	CBGallery::translateType( 'photos', true, true );
			$icon				=	CBGallery::getTypeIcon( 'photos' );
		}

		if ( CBGallery::canCreateItems( 'videos', 'upload', $gallery ) || CBGallery::canCreateItems( 'videos', 'link', $gallery ) ) {
			$types[]			=	CBGallery::translateType( 'videos', true, true );

			if ( ! $icon ) {
				$icon			=	CBGallery::getTypeIcon( 'videos' );
			}
		}

		if ( CBGallery::canCreateItems( 'files', 'upload', $gallery ) || CBGallery::canCreateItems( 'files', 'link', $gallery ) ) {
			$types[]			=	CBGallery::translateType( 'files', true, true );

			if ( ! $icon ) {
				$icon			=	CBGallery::getTypeIcon( 'files' );
			}
		}

		if ( CBGallery::canCreateItems( 'music', 'upload', $gallery ) || CBGallery::canCreateItems( 'music', 'link', $gallery ) ) {
			$types[]			=	CBGallery::translateType( 'music', false, true );

			if ( ! $icon ) {
				$icon			=	CBGallery::getTypeIcon( 'music' );
			}
		}

		if ( ! $types ) {
			return null;
		}

		static $JS_LOADED		=	0;

		if ( ( $canUpload || $canLink ) && ( ! $JS_LOADED++ ) ) {
			$uploadRow			=	'<div class="mt-2 d-flex flex-wrap no-gutters border align-items-center galleryShareUploadProgressFile galleryItemsNewUploadFile">'
								.		"<div class=\"p-1 col-12 col-md text-center text-md-left text-wrap galleryItemsNewUploadFileName\">' + ( typeof file.name != 'undefined' ? file.name : Date.now() ) + '</div>"
								.		'<div class="p-1 col-12 col-md galleryItemsNewUploadFileProgress">'
								.			'<div class="m-0 p-0 progress">'
								.				'<div class="progress-bar progress-bar-striped progress-bar-animated"></div>'
								.			'</div>'
								.		'</div>'
								.		'<div class="p-1 col-12 col-md-auto galleryItemsNewUploadFileActions">'
								.			'<button type="button" class="btn btn-sm btn-md-block btn-danger galleryShareUploadProgressCancel galleryItemsNewUploadFileCancel">' . addslashes( CBTxt::T( 'Cancel' ) ) . '</button>'
								.			'<button type="button" class="btn btn-sm btn-md-block btn-danger galleryShareUploadProgressClear galleryItemsNewUploadFileClear hidden"><span class="fa fa-times"></span></button>'
								.		'</div>'
								.	'</div>';

			$uploadError		=	'<div class="mt-1 text-danger text-wrap galleryShareUploadProgressError galleryItemsNewUploadFileAlert">'
								.		"' + response.message + '"
								.	'</div>';

			$linkError			=	'<div class="d-block invalid-feedback text-wrap cbValidationMessage galleryShareLinkError">'
								.		"' + response.message + '"
								.	'</div>';

			$js					=	"$( '.galleryActivityNew' ).each( function(){"
								.		"var form = $( this ).closest( '.streamItemForm' );"
								.		"$( this ).cbgallery({"
								.			"mode: 'share',"
								.			"pasteZone: form,"
								.			"callback: {"
								.				"upload: {"
								.					"add: function ( cbgallery, data, file ) {"
								.						"if ( ! form.find( '.streamInputUpload' ).hasClass( 'streamToggleOpen' ) ) {"
								.							"form.find( '.streamInputMessage' ).trigger( 'click' );"
								.							"form.find( '.streamInputUpload' ).trigger( 'click.^$' );" // Ignore namespaces as we don't want to trigger tooltip
								.						"}"
								.						"return $( '" . $uploadRow . "' );"
								.					"},"
								.					"error: function ( cbgallery, response ) {"
								.						"return $( '" . $uploadError . "' );"
								.					"}"
								.				"},"
								.				"link: {"
								.					"error: function ( cbgallery, response ) {"
								.						"return $( '" . $linkError . "' );"
								.					"}"
								.				"}"
								.			"},"
								.			"messages: {"
								.				"acceptTypes: '" . addslashes( CBTxt::T( 'Invalid file extension. Please upload only {0}!' ) ) . "',"
								.				"extensions: '" . addslashes( CBTxt::T( 'Invalid file extension. Please upload only {0}!' ) ) . "',"
								.				"minSize: '" . addslashes( CBTxt::T( 'The file is too small. The minimum size is {0} {2}s!' ) ) . "',"
								.				"maxSize: '" . addslashes( CBTxt::T( 'The file is too large. The maximum size is {1} {2}s!' ) ) . "'"
								.			"}"
								.		"});"
								.		"$( this ).closest( '.activityStream,.commentsStream' ).on( 'cbactivity.new.cancel', function() {"
								.			"$( this ).find( '.galleryShareEdit' ).find( '.galleryEditDelete' ).removeAttr( 'data-cbgallery-delete-message' ).click();"
								.		"}).on( 'cbactivity.save.success cbactivity.new.cancel', function() {"
								.			"$( this ).find( '.galleryItemsNewUploadFiles,.galleryShareEdit' ).addClass( 'hidden' );"
								.			"$( this ).find( '.galleryShareUploadProgressRows' ).html( '' );"
								.			"$( this ).find( '.galleryShareEdit' ).html( '' );"
								.		"});"
								.	"});";

			$_CB_framework->outputCbJQuery( $js, 'cbgallery' );
		}

		$uploadTooltip			=	cbTooltip( null, CBTxt::T( 'HAVE_TYPES_TO_SHARE', 'Have [types] to share?', array( '%%COUNT%%' => count( $types ), '[types]' => implode( ', ', $types ) ) ), null, 'auto', null, null, null, 'data-hascbtooltip="true" data-cbtooltip-position-my="bottom center" data-cbtooltip-position-at="top center" data-cbtooltip-classes="qtip-simple"' );

		$buttons['left'][]		=	'<button type="button" class="btn btn-light btn-sm border streamToggle streamInputUpload" data-cbactivity-toggle-target=".streamInputUploadContainer" data-cbactivity-toggle-active-classes="btn-info" data-cbactivity-toggle-inactive-classes="btn-light border"' . $uploadTooltip . '><span class="fa ' . htmlspecialchars( $icon ) . '"></span></button>';

		$class					=	$plugin->params->getString( 'general_class' );

		$imageHeight			=	$gallery->getInt( 'photos_image_height', 640 );
		$imageWidth				=	$gallery->getInt( 'photos_image_width', 1280 );

		if ( ! $imageHeight ) {
			$imageHeight		=	640;
		}

		if ( ! $imageWidth ) {
			$imageWidth			=	1280;
		}

		$minFileSizes			=	array(	$gallery->getInt( 'photos_min_size', 0 ),
											$gallery->getInt( 'videos_min_size', 0 ),
											$gallery->getInt( 'files_min_size', 0 ),
											$gallery->getInt( 'music_min_size', 0 )
										);

		sort( $minFileSizes, SORT_NUMERIC );

		$maxFileSizes			=	array(	$gallery->getInt( 'photos_max_size', 0 ),
											$gallery->getInt( 'videos_max_size', 0 ),
											$gallery->getInt( 'files_max_size', 0 ),
											$gallery->getInt( 'music_max_size', 0 )
										);

		rsort( $maxFileSizes, SORT_NUMERIC );

		$minFileSize			=	( ! in_array( 0, $minFileSizes, true ) ? $minFileSizes[0] : 0 );
		$maxFileSize			=	( ! in_array( 0, $maxFileSizes, true ) ? $maxFileSizes[0] : 0 );
		$phpMaxFileSize			=	CBGallery::getPHPMaxUpload( 'KB' );

		if ( ( ! $maxFileSize ) || ( $maxFileSize > $phpMaxFileSize ) ) {
			$maxFileSize		=	$phpMaxFileSize;
		}

		$uploadExtLimit			=	CBGallery::getExtensions( 'all', $gallery, 'client' );

		$attributes				=	' data-cbgallery-url="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'item', 'func' => 'save', 'folder' => '-1', 'gallery' => $gallery->id(), cbSpoofField() => cbSpoofString( null, 'plugin' ) ), 'raw', 0, true ) . '"'
								.	' data-cbgallery-clientResize="' . $gallery->getInt( 'photos_client_resize', 1 ) . '"'
								.	' data-cbgallery-maxWidth="' . $imageWidth . '"'
								.	' data-cbgallery-maxHeight="' . $imageHeight . '"'
								.	' data-cbgallery-aspectRatio="' . $gallery->getInt( 'photos_maintain_aspect_ratio', 1 ) . '"'
								.	' data-cbgallery-alwaysResample="' . $gallery->getInt( 'photos_resample', 1 ) . '"';

		if ( $uploadExtLimit ) {
			$attributes			.=	' data-cbgallery-extensions="' . htmlspecialchars( implode( ',', $uploadExtLimit ) ) . '"';
		}

		if ( $minFileSize ) {
			$attributes			.=	' data-cbgallery-minSize="' . htmlspecialchars( json_encode( array( $minFileSize, 'KB' ) ) ) . '"';
		}

		if ( $maxFileSize ) {
			$attributes			.=	' data-cbgallery-maxSize="' . htmlspecialchars( json_encode( array( $maxFileSize, 'KB' ) ) ) . '"';
		}

		$return					=	'<div class="' . ( $stream instanceof Comments ? 'bg-white border border-top-0' : 'border-top' ) . ' p-2 streamItemInputGroup streamInputUploadContainer hidden">'
								.		'<input type="hidden" name="gallery" value="' . htmlspecialchars( $gallery->id() ) . '" />'
								.		'<div class="streamItemInputGroupInput">'
								.			'<div class="cbGallery' . ( $class ? ' ' . htmlspecialchars( $class ) : null ) . '">'
								.				'<div class="galleryActivityNew galleryItemsNew"' . $attributes . '>';

		if ( $canUpload ) {
			$return				.=					'<div class="galleryItemsNewUpload">'
								.						'<div class="border bg-light rounded p-3 text-center galleryShareUploadDropZone galleryItemsNewUploadArea">'
								.							'<strong><span class="fa fa-upload"></span> ' . CBTxt::T( 'Click or Drag & Drop to Upload' ) . '</strong>'
								.							'<input type="file" name="upload" class="galleryShareUpload hidden" multiple />'
								.						'</div>'
								.						'<div class="galleryShareUploadProgress galleryItemsNewUploadFiles hidden"></div>'
								.					'</div>';
		}

		if ( $canLink ) {
			if ( $canUpload ) {
				$return			.=					'<div class="mt-1 mb-1 d-flex flex-wrap no-gutters align-items-center galleryItemsNewOr">'
								.						'<div class="col"><hr class="m-0" /></div>'
								.						'<div class="pl-2 pr-2 text-center text-muted text-small">' . CBTxt::T( 'OR' ) . '</div>'
								.						'<div class="col"><hr class="m-0" /></div>'
								.					'</div>';
			}

			$return				.=					'<div class="galleryShareLinkArea galleryItemsNewLink">'
								.						'<div class="input-group">'
								.							'<input type="text" class="form-control galleryShareLink" placeholder="' . htmlspecialchars( CBTxt::T( 'Have a media link to share?' ) ) . '">'
								.							'<div class="input-group-append">'
								.								'<button type="button" class="btn btn-primary galleryShareLinkSave galleryButton galleryButtonShare">' . CBTxt::T( 'Share' ) . '</button>'
								.							'</div>'
								.						'</div>'
								.					'</div>';
		}

		$return					.=					'<div class="d-flex flex-wrap no-gutters mt-2 galleryShareEdit galleryItemsNewEdit hidden"></div>'
								.				'</div>'
								.			'</div>'
								.		'</div>'
								.	'</div>';

		return $return;
	}
}