<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\Gallery\Trigger;

use CB\Plugin\Gallery\CBGallery;
use CB\Plugin\Gallery\Gallery;
use CB\Plugin\PMS\PMSHelper;
use CB\Plugin\PMS\Table\MessageTable;
use CB\Database\Table\UserTable;
use CBLib\Application\Application;

defined( 'CBLIB') or die();

class PMSTrigger extends \cbPluginHandler
{

	/**
	 * @param int $profileId
	 * @param int $pmId
	 * @return Gallery|null
	 */
	private function pmGallery( $profileId, $pmId = 0 )
	{
		global $_PLUGINS;

		if ( ( ! $profileId ) || ( ! PMSHelper::getGlobalParams()->getBool( 'messages_attachments', false ) ) ) {
			return null;
		}

		$gallery		=	new Gallery( 'pm.' . $pmId, $profileId );

		$gallery->set( 'photos_link', false );
		$gallery->set( 'videos_link', false );
		$gallery->set( 'files_link', false );
		$gallery->set( 'music_link', false );

		$gallery->parse( PMSHelper::getGlobalParams(), 'gallery_', true );

		$gallery->set( 'location', CBGallery::getReturn( false, true ) );
		$gallery->set( 'folders', false );
		$gallery->set( 'items_create', true );
		$gallery->set( 'items_paging', false );
		$gallery->set( 'items_search', false );
		$gallery->set( 'thumbnails', false );

		$access			=	true;

		$_PLUGINS->trigger( 'gallery_onGalleryAccess', array( &$gallery, &$access ) );

		if ( ! $access )  {
			return null;
		}

		if ( ! $gallery->id() ) {
			$gallery->cache();
		}

		return $gallery;
	}

	/**
	 * @param MessageTable $row
	 * @param string       $avatar
	 * @param string       $name
	 * @param array        $menu
	 * @param UserTable    $user
	 * @return string|null
	 */
	public function pmDisplay( $row, $avatar, $name, $menu, $user )
	{
		$gallery	=	$this->pmGallery( $row->getInt( 'from_user', 0 ), $row->getInt( 'id', 0 ) );

		if ( ! $gallery ) {
			return null;
		}

		$items		=	$gallery->setPublished( ( CBGallery::canModerate( $gallery ) ? null : 1 ) )->items();

		CBGallery::getTemplate( array( 'pm', 'item_container', 'embed' ) );

		return \HTML_cbgalleryPM::showPM( $row, $items, $user, $gallery, $this );
	}

	/**
	 * @param MessageTable $row
	 * @param array        $input
	 * @param UserTable    $user
	 * @return string|null
	 */
	public function pmEditReply( $row, $input, $user )
	{
		return $this->pmEdit( $row, $input, $user, true );
	}

	/**
	 * @param MessageTable $row
	 * @param array        $input
	 * @param UserTable    $user
	 * @param bool         $isReply
	 * @return string|null
	 */
	public function pmEdit( $row, $input, $user, $isReply = false )
	{
		$rowId		=	( $isReply ? 0 : $row->getInt( 'id', 0 ) );
		$gallery	=	$this->pmGallery( $user->getInt( 'id', 0 ), $rowId );

		if ( ! $gallery ) {
			return null;
		}

		if ( $rowId ) {
			$items	=	$gallery->items();
		} else {
			$items	=	array();
		}

		CBGallery::getTemplate( array( 'pm_edit', 'item_edit_micro', 'item_container' ) );

		return \HTML_cbgalleryPMEdit::showPMEdit( $row, $items, $isReply, $user, $gallery, $this );
	}

	/**
	 * @param MessageTable $row
	 */
	public function pmSave( $row )
	{
		$gallery	=	$this->pmGallery( $row->getInt( 'from_user', 0 ) );

		if ( ! $gallery ) {
			return null;
		}

		$items		=	cbToArrayOfInt( Application::Input()->getRaw( 'items', array() ) );

		if ( ! $items ) {
			return;
		}

		foreach ( $gallery->reset()->setId( $items )->items() as $item ) {
			$item->set( 'asset', 'pm.' . $row->getInt( 'id', 0 ) );

			$item->store();
		}
	}
}