(function($) {
	var instances = [];
	var methods = {
		init: function( options ) {
			return this.each( function () {
				var $this = this;
				var cbgallery = $( $this ).data( 'cbgallery' );

				if ( cbgallery ) {
					return; // cbgallery is already bound; so no need to rebind below
				}

				cbgallery = {};
				cbgallery.options = options;
				cbgallery.defaults = $.fn.cbgallery.defaults;
				cbgallery.settings = $.extend( true, {}, cbgallery.defaults, cbgallery.options );
				cbgallery.element = $( $this );
				cbgallery.gallery = $( $this ).data( 'cbgallery-gallery' );

				if ( typeof cbgallery.gallery == 'undefined' ) {
					cbgallery.gallery = null;
				}

				if ( cbgallery.settings.useData ) {
					$.each( cbgallery.defaults, function( key, value ) {
						if ( ( key != 'init' ) && ( key != 'useData' ) ) {
							// Dash Separated:
							var dataValue = cbgallery.element.data( 'cbgallery' + key.charAt( 0 ).toUpperCase() + key.slice( 1 ) );

							if ( typeof dataValue != 'undefined' ) {
								cbgallery.settings[key] = dataValue;
							} else {
								// No Separater:
								dataValue = cbgallery.element.data( 'cbgallery' + key.charAt( 0 ).toUpperCase() + key.slice( 1 ).toLowerCase() );

								if ( typeof dataValue != 'undefined' ) {
									cbgallery.settings[key] = dataValue;
								}
							}
						}
					});
				}

				cbgallery.element.triggerHandler( 'cbgallery.init.before', [cbgallery] );

				if ( ! cbgallery.settings.init ) {
					return;
				}

				if ( ( cbgallery.settings.request === null ) || ( ( typeof cbgallery.settings.request != 'object' ) && ( ! $.isArray( cbgallery.settings.request ) ) ) ) {
					cbgallery.settings.request = {};
				}

				$.ajaxPrefilter(function( options, originalOptions, jqXHR ) {
					options.async = true;

					if ( ( options.dataType == 'script' ) || ( originalOptions.dataType == 'script' ) ) {
						options.cache = true;
					}
				});

				if ( cbgallery.settings.mode == 'modal' ) {
					if ( ! cbgallery.settings.url ) {
						return;
					}

					if ( cbgallery.settings.previous ) {
						cbgallery.settings.request['previous'] = cbgallery.settings.previous;
					}

					if ( cbgallery.settings.next ) {
						cbgallery.settings.request['next'] = cbgallery.settings.next;
					}

					cbgallery.navigationHandler = function( e ) {
						var cbtooltip = cbgallery.element.data( 'cbtooltip' );

						if ( ( ! cbtooltip ) || $( e.target ).is( 'input,textarea' ) ) {
							return;
						}

						var nav = 0;

						if ( e.type == 'swipeleft' ) {
							nav = 37;
						} else if ( e.type == 'swiperight' ) {
							nav = 39;
						} else {
							nav = e.which;
						}

						switch( nav ) {
							case 27: // escape
								if ( ! cbtooltip.tooltip.qtip( 'api' ).elements.content ) {
									return;
								}

								var close = cbtooltip.tooltip.qtip( 'api' ).elements.content.find( '.galleryModalClose' );

								if ( close.length ) {
									close.click();
								} else {
									return;
								}
								break;
							case 37: // left
								if ( ! cbtooltip.tooltip.qtip( 'api' ).elements.content ) {
									return;
								}

								var previous = cbtooltip.tooltip.qtip( 'api' ).elements.content.find( '.galleryModalScrollLeft' );

								if ( previous.length ) {
									previous.click();
								} else {
									return;
								}
								break;
							case 39: // right
								if ( ! cbtooltip.tooltip.qtip( 'api' ).elements.content ) {
									return;
								}

								var next = cbtooltip.tooltip.qtip( 'api' ).elements.content.find( '.galleryModalScrollRight' );

								if ( next.length ) {
									next.click();
								} else {
									return;
								}
								break;
							default:
								return;
						}

						e.preventDefault();
					};

					cbgallery.actionHandler = function( e ) {
						e.preventDefault();

						if ( cbgallery.element.hasClass( 'galleryRequesting' ) ) {
							return;
						}

						var cbtooltip = cbgallery.element.data( 'cbtooltip' );

						if ( ! cbtooltip ) {
							return;
						}

						var element = $( e.target );
						var actionUrl = element.data( 'cbgallery-action-url' );

						if ( ! actionUrl ) {
							actionUrl = element.attr( 'href' );
						}

						if ( ! actionUrl ) {
							return;
						}

						var confirmMessage = element.data( 'cbgallery-confirm' );
						var confirmButton = element.data( 'cbgallery-confirm-button' );

						cbgallery.element.addClass( 'galleryRequesting' );

						var callback = function() {
							var ajax = null;

							cbtooltip.tooltip.qtip( 'api' ).set( 'content.text', function( e, api ) {
								if ( ajax == null ) {
									ajax = $.ajax({
										url: actionUrl,
										type: 'GET',
										dataType: 'html',
										cache: false,
										beforeSend: function( jqXHR, textStatus, errorThrown ) {
											cbgallery.element.triggerHandler( 'cbgallery.modal.action.send', [cbgallery, cbtooltip, jqXHR, textStatus, errorThrown] );
										}
									}).fail( function( jqXHR, textStatus, errorThrown ) {
										cbgallery.element.removeClass( 'galleryRequesting' );

										if ( ! api.destroyed ) {
											api.hide();
										}

										cbgallery.element.triggerHandler( 'cbgallery.modal.action.error', [cbgallery, cbtooltip, jqXHR, textStatus, errorThrown] );
									}).done( function( data, textStatus, jqXHR ) {
										cbgallery.element.removeClass( 'galleryRequesting' );

										if ( ! api.destroyed ) {
											var response = null;

											if ( jqXHR.getResponseHeader( 'Content-Type' ).indexOf( 'json' ) !== -1 ) {
												try {
													response = JSON.parse( data );

													var modal = cbgallery.displayHandler( e, cbtooltip );

													if ( modal ) {
														modal.done( function( data, textStatus, jqXHR ) {
															if ( response && ( typeof response.status != 'undefined' ) ) {
																if ( response.status === true ) {
																	if ( ( typeof response.message != 'undefined' ) && response.message ) {
																		if ( api.elements.content ) {
																			api.elements.content.find( '.galleryModalDisplay' ).prepend( '<div class="position-absolute p-2 galleryModalAlert"><div class="m-0 p-2 alert alert-success">' + response.message + '</div></div>' );
																		}
																	}
	
																	cbgallery.element.triggerHandler( 'cbgallery.modal.action.success', [cbgallery, cbtooltip, response, textStatus, jqXHR] );
																} else if ( response.status === false ) {
																	if ( ( typeof response.message != 'undefined' ) && response.message ) {
																		if ( api.elements.content ) {
																			api.elements.content.find( '.galleryModalDisplay' ).prepend( '<div class="position-absolute p-2 galleryModalAlert"><div class="m-0 p-2 alert alert-danger">' + response.message + '</div></div>' );
																		}
																	}

																	cbgallery.element.triggerHandler( 'cbgallery.modal.action.failed', [cbgallery, cbtooltip, response, textStatus, jqXHR] );
																}
															}
														});
													} else {
														if ( ! api.destroyed ) {
															api.hide();
														}
													}
												} catch( e ) {
													if ( ! api.destroyed ) {
														api.hide();
													}
												}
											} else {
												parseModal.call( this, data, api, cbgallery );

												cbgallery.element.triggerHandler( 'cbgallery.modal.success', [cbgallery, cbtooltip, data, textStatus, jqXHR] );
											}
										}

										cbgallery.element.triggerHandler( 'cbgallery.modal.action.always', [cbgallery, cbtooltip, data, textStatus, jqXHR] );
									});
								}

								return '<div class="d-flex flex-column justify-content-center align-items-center h-100 text-white cbTooltipClose galleryModalLoading"><div class="spinner-border"></div></div>';
							});
						};

						if ( confirmMessage ) {
							$.cbconfirm( confirmMessage, { buttonYes: confirmButton } ).done( callback ).fail( function() {
								cbgallery.element.removeClass( 'galleryRequesting' );
							});
						} else {
							callback();
						}
					};

					cbgallery.closeHandler = function() {
						$( document ).off( 'keydown.cbgallery', cbgallery.navigationHandler );
						$( document ).off( 'click.cbgallery', '.galleryModalAction', cbgallery.actionHandler );

						$( 'body' ).removeClass( 'galleryModalOpen' );
					};

					cbgallery.element.on( 'cbtooltip.hidden', cbgallery.closeHandler );

					cbgallery.displayHandler = function( e, cbtooltip ) {
						if ( cbgallery.element.hasClass( 'galleryRequesting' ) ) {
							return;
						}

						cbgallery.element.addClass( 'galleryRequesting' );

						cbtooltip.tooltip.qtip( 'api' ).set({
							'show.effect': false,
							'hide.effect': false
						});

						var ajax = null;

						cbtooltip.tooltip.qtip( 'api' ).set( 'content.text', function( e, api ) {
							if ( ajax == null ) {
								ajax = $.ajax({
									url: cbgallery.settings.url,
									type: 'GET',
									dataType: 'html',
									cache: false,
									data: cbgallery.settings.request,
									beforeSend: function( jqXHR, textStatus, errorThrown ) {
										cbgallery.element.triggerHandler( 'cbgallery.modal.send', [cbgallery, cbtooltip, jqXHR, textStatus, errorThrown] );
									}
								}).fail( function( jqXHR, textStatus, errorThrown ) {
									cbgallery.element.removeClass( 'galleryRequesting' );

									if ( ! api.destroyed ) {
										api.hide();
									}

									cbgallery.element.triggerHandler( 'cbgallery.modal.error', [cbgallery, cbtooltip, jqXHR, textStatus, errorThrown] );
								}).done( function( data, textStatus, jqXHR ) {
									cbgallery.element.removeClass( 'galleryRequesting' );

									if ( ! api.destroyed ) {
										parseModal.call( this, data, api, cbgallery );

										$( 'body' ).addClass( 'galleryModalOpen' );
									}

									cbgallery.element.triggerHandler( 'cbgallery.modal.success', [cbgallery, cbtooltip, data, textStatus, jqXHR] );
								});
							}

							return '<div class="d-flex flex-column justify-content-center align-items-center h-100 text-white cbTooltipClose galleryModalLoading"><div class="spinner-border"></div></div>';
						});

						return ajax;
					};

					cbgallery.element.on( 'cbtooltip.render', cbgallery.displayHandler );
				} else if ( cbgallery.settings.mode == 'share' ) {
					if ( ! cbgallery.settings.url ) {
						return;
					}

					var pasteZone = cbgallery.settings.pasteZone;

					if ( pasteZone === false ) {
						pasteZone = null;
					} else if ( pasteZone === 'self' ) {
						pasteZone = cbgallery.element;
					} else if ( typeof pasteZone == 'string' ) {
						if ( ( pasteZone.lastIndexOf( '~ ', 0 ) === 0 ) || ( pasteZone.lastIndexOf( '+ ', 0 ) === 0 ) || ( pasteZone.lastIndexOf( '> ', 0 ) === 0 ) || ( pasteZone.lastIndexOf( ' ', 0 ) === 0 ) ) {
							pasteZone = cbgallery.element.find( pasteZone.trim() );
						} else {
							pasteZone = $( pasteZone );
						}
					} else if ( ! pasteZone ) {
						pasteZone = $( document );
					}

					cbgallery.element.find( '.galleryShareUpload' ).fileupload({
						url: cbgallery.settings.url,
						dataType: 'html',
						sequentialUploads: false,
						replaceFileInput: true,
						dropZone: cbgallery.element.find( '.galleryShareUploadDropZone' ),
						pasteZone: pasteZone,
						formData: [],
						processQueue: [
							{
								action: 'extensions',
								cbgallery: cbgallery
							},
							{
								action: 'acceptTypes',
								cbgallery: cbgallery
							},
							{
								action: 'clientSideResize',
								cbgallery: cbgallery
							},
							{
								action: 'minFileSize',
								cbgallery: cbgallery
							},
							{
								action: 'maxFileSize',
								cbgallery: cbgallery
							}
						],
						add: function( e, data ) {
							if ( cbgallery.settings.callback.upload.add ) {
								cbgallery.element.find( '.galleryShareUploadProgress' ).removeClass( 'hidden' );
							}

							$.each( data.files, function( index, file ) {
								file.error = null;
								file.context = null;

								if ( cbgallery.settings.callback.upload.add ) {
									file.context = cbgallery.settings.callback.upload.add.call( cbgallery.element, cbgallery, data, file );
								}

								if ( file.context ) {
									file.context.find( '.galleryShareUploadProgressCancel' ).on( 'click', function() {
										data.abort();

										file.context.find( '.progress-bar' ).css( 'width', '100%' ).removeClass( 'progress-bar-striped progress-bar-animated' ).addClass( 'bg-warning' );
										file.context.find( '.galleryShareUploadProgressClear' ).removeClass( 'hidden' );
										file.context.find( '.galleryShareUploadProgressCancel' ).remove();
									});

									file.context.find( '.galleryShareUploadProgressClear' ).on( 'click', function() {
										file.context.next( '.galleryShareUploadProgressError' ).remove();
										file.context.remove();

										if ( ! cbgallery.element.find( '.galleryShareUploadProgressFile' ).length ) {
											cbgallery.element.find( '.galleryShareUploadProgress' ).addClass( 'hidden' );
										}
									});

									file.context.appendTo( cbgallery.element.find( '.galleryShareUploadProgress' ) );
								}

								cbgallery.element.triggerHandler( 'cbgallery.upload.add.file', [cbgallery, file, data] );
							});

							if ( typeof $.blueimp.fileupload.prototype.process != 'undefined' ) {
								data.process( function () {
									return cbgallery.element.find( '.galleryShareUpload' ).fileupload( 'process', data );
								});
							}

							data.process().done( function () {
								data.submit();
							});

							$( this ).val( '' );

							cbgallery.element.triggerHandler( 'cbgallery.upload.add', [cbgallery, data] );
						},
						progress: function( e, data ) {
							var index = data.index;

							if ( ! index ) {
								index = 0;
							}

							var file = data.files[index].context;

							if ( file ) {
								file.find( '.progress-bar' ).css( 'width', parseInt( ( ( data.loaded / data.total ) * 100 ), 10 ) + '%' );
							}

							cbgallery.element.triggerHandler( 'cbgallery.upload.progress', [cbgallery, file, data] );
						},
						fail: function( e, data ) {
							var index = data.index;

							if ( ! index ) {
								index = 0;
							}

							var file = data.files[index].context;

							if ( file ) {
								file.find( '.progress-bar' ).css( 'width', '100%' ).removeClass( 'progress-bar-striped progress-bar-animated' ).addClass( 'bg-danger' );
								file.find( '.galleryShareUploadProgressClear' ).removeClass( 'hidden' );
								file.find( '.galleryShareUploadProgressCancel' ).remove();

								if ( data.files[index].error ) {
									if ( cbgallery.settings.callback.upload.error ) {
										var response = { status: true, message: data.files[index].error };

										data.files[index].error = cbgallery.settings.callback.upload.error.call( cbgallery.element, cbgallery, response, file, data );
									}

									if ( data.files[index].error ) {
										file.after( data.files[index].error );
									}
								}
							}

							cbgallery.element.triggerHandler( 'cbgallery.upload.error', [cbgallery, file, data] );
						},
						done: function( e, data ) {
							var response = null;

							if ( data.jqXHR.getResponseHeader( 'Content-Type' ).indexOf( 'json' ) !== -1 ) {
								try {
									response = JSON.parse( data.result );
								} catch( e ) {}
							} else {
								response = { status: true, message: data.result };
							}

							var index = data.index;

							if ( ! index ) {
								index = 0;
							}

							var file = data.files[index].context;

							if ( file ) {
								var progressBar = file.find( '.progress-bar' );

								file.find( '.galleryShareUploadProgressClear' ).removeClass( 'hidden' );
								file.find( '.galleryShareUploadProgressCancel' ).remove();

								progressBar.css( 'width', '100%' ).removeClass( 'progress-bar-striped progress-bar-animated' );
							}

							if ( response && ( typeof response.status != 'undefined' ) ) {
								if ( response.status === true ) {
									if ( file ) {
										progressBar.addClass( 'bg-success' );
									}

									if ( ( typeof response.message != 'undefined' ) && response.message ) {
										var dataHtml = $( response.message );
										var loadScripts = parseHeaders.call( dataHtml, cbgallery );

										cbgallery.element.find( '.galleryShareEdit' ).removeClass( 'hidden' ).append( dataHtml );

										parseScripts.call( dataHtml, cbgallery, loadScripts );

										dataHtml.find( '.cbTooltip,[data-hascbtooltip=\"true\"]' ).cbtooltip();

										if ( file ) {
											file.find( '.galleryShareUploadProgressClear' ).click();
										}

										confirmToggle.call( dataHtml, cbgallery );
									}

									cbgallery.element.triggerHandler( 'cbgallery.upload.success', [cbgallery, file, data] );
								} else if ( response.status === false ) {
									if ( file ) {
										progressBar.addClass( 'bg-danger' );

										if ( ( typeof response.message != 'undefined' ) && response.message ) {
											if ( cbgallery.settings.callback.upload.error ) {
												data.files[index].error = cbgallery.settings.callback.upload.error.call( cbgallery.element, cbgallery, response, file, data );
											}

											if ( data.files[index].error ) {
												file.after( data.files[index].error );
											}
										}
									}

									cbgallery.element.triggerHandler( 'cbgallery.upload.failed', [cbgallery, file, data] );
								}
							}

							cbgallery.element.triggerHandler( 'cbgallery.upload.always', [cbgallery, file, data] );
						}
					}).on( 'fileuploadprocessfail', function ( e, data ) {
						var index = data.index;

						if ( ! index ) {
							index = 0;
						}

						var file = data.files[index].context;

						if ( file ) {
							file.find( '.progress-bar' ).css( 'width', '100%' ).removeClass( 'progress-bar-striped progress-bar-animated' ).addClass( 'bg-danger' );
							file.find( '.galleryShareUploadProgressClear' ).removeClass( 'hidden' );
							file.find( '.galleryShareUploadProgressCancel' ).remove();

							if ( data.files[index].error ) {
								if ( cbgallery.settings.callback.upload.error ) {
									var response = { status: false, message: data.files[index].error };

									data.files[index].error = cbgallery.settings.callback.upload.error.call( cbgallery.element, cbgallery, response, file, data );
								}

								if ( data.files[index].error ) {
									file.after( data.files[index].error );
								}
							}
						}

						cbgallery.element.triggerHandler( 'cbgallery.upload.error', [cbgallery, file, data] );
					});

					cbgallery.uploadChangeHandler = function() {
						var currentValue = $( this ).val();

						if ( $.isArray( currentValue ) ) {
							currentValue = currentValue.join( '|*|' );
						}

						if ( currentValue === $( this ).data( 'cbgallery-initial-value' ) ) {
							$( this ).removeClass( 'galleryEditChanged' );
						} else {
							$( this ).addClass( 'galleryEditChanged' );
						}

						if ( cbgallery.element.find( '.galleryShareEdit .galleryEditChanged' ).length ) {
							cbgallery.element.find( '.galleryShareEditConfirm' ).removeClass( 'hidden' );
							cbgallery.element.find( '.galleryShareEditDone' ).addClass( 'hidden' );
						} else {
							cbgallery.element.find( '.galleryShareEditConfirm' ).addClass( 'hidden' );
							cbgallery.element.find( '.galleryShareEditDone' ).removeClass( 'hidden' );
						}

						cbgallery.element.find( '.galleryShareEditBack' ).addClass( 'hidden' );
					};

					cbgallery.element.find( '.galleryShareEdit' ).on( 'keyup change', 'input,select,textarea', cbgallery.uploadChangeHandler );

					cbgallery.dropZoneHandler = function( e ) {
						if ( ! $( e.target ).is( 'input' ) ) {
							e.preventDefault();

							cbgallery.element.find( '.galleryShareUpload' ).click();
						}
					};

					cbgallery.element.find( '.galleryShareUploadDropZone' ).on( 'click', cbgallery.dropZoneHandler );

					cbgallery.linkSaveHandler = function( e ) {
						e.preventDefault();

						if ( cbgallery.element.hasClass( 'galleryRequesting' ) ) {
							return;
						}

						var button = $( this );
						var link = cbgallery.element.find( '.galleryShareLink' );

						if ( link.val() ) {
							cbgallery.element.addClass( 'galleryRequesting' );

							cbgallery.settings.request['value'] = link.val();

							$.ajax({
								url: cbgallery.settings.url,
								type: 'POST',
								dataType: 'html',
								cache: false,
								data: cbgallery.settings.request,
								beforeSend: function( jqXHR, textStatus, errorThrown ) {
									link.prop( 'disabled', true );
									button.prop( 'disabled', true );

									cbgallery.element.find( '.galleryShareLinkLoading' ).removeClass( 'hidden' );
									cbgallery.element.find( '.galleryShareLinkArea' ).removeClass( 'cbValidationError' );
									cbgallery.element.find( '.galleryShareLink' ).removeClass( 'cbValidationError is-invalid' );
									cbgallery.element.find( '.galleryShareLinkError' ).remove();

									cbgallery.element.triggerHandler( 'cbgallery.link.send', [cbgallery, jqXHR, textStatus, errorThrown] );
								}
							}).fail( function( jqXHR, textStatus, errorThrown ) {
								cbgallery.element.removeClass( 'galleryRequesting' );
								cbgallery.element.find( '.galleryShareLinkLoading' ).addClass( 'hidden' );
								cbgallery.element.find( '.galleryShareLinkArea' ).addClass( 'cbValidationError' );
								cbgallery.element.find( '.galleryShareLink' ).addClass( 'cbValidationError is-invalid' );

								link.prop( 'disabled', false );
								button.prop( 'disabled', false );

								cbgallery.element.triggerHandler( 'cbgallery.link.error', [cbgallery, jqXHR, textStatus, errorThrown] );
							}).done( function( data, textStatus, jqXHR ) {
								cbgallery.element.removeClass( 'galleryRequesting' );

								var response = null;

								if ( jqXHR.getResponseHeader( 'Content-Type' ).indexOf( 'json' ) !== -1 ) {
									try {
										response = JSON.parse( data );
									} catch( e ) {}
								} else {
									response = { status: true, message: data };
								}

								cbgallery.element.find( '.galleryShareLinkLoading' ).addClass( 'hidden' );

								link.prop( 'disabled', false );
								button.prop( 'disabled', false );

								if ( response && ( typeof response.status != 'undefined' ) ) {
									if ( response.status === true ) {
										link.val( '' );

										if ( ( typeof response.message != 'undefined' ) && response.message ) {
											var dataHtml = $( response.message );
											var loadScripts = parseHeaders.call( dataHtml, cbgallery );

											cbgallery.element.find( '.galleryShareEdit' ).removeClass( 'hidden' ).append( dataHtml );

											parseScripts.call( dataHtml, cbgallery, loadScripts );

											dataHtml.find( '.cbTooltip,[data-hascbtooltip=\"true\"]' ).cbtooltip();

											confirmToggle.call( dataHtml, cbgallery );
										}

										cbgallery.element.triggerHandler( 'cbgallery.link.success', [cbgallery, response, textStatus, jqXHR] );
									} else if ( response.status === false ) {
										cbgallery.element.find( '.galleryShareLinkArea' ).addClass( 'cbValidationError' );
										cbgallery.element.find( '.galleryShareLink' ).addClass( 'cbValidationError is-invalid' );

										if ( ( typeof response.message != 'undefined' ) && response.message ) {
											var error = null;

											if ( cbgallery.settings.callback.link.error ) {
												error = cbgallery.settings.callback.link.error.call( cbgallery.element, cbgallery, response, data );
											}

											if ( error ) {
												cbgallery.element.find( '.galleryShareLinkArea' ).append( error );
											}
										}

										cbgallery.element.triggerHandler( 'cbgallery.link.failed', [cbgallery, response, textStatus, jqXHR] );
									}
								}

								cbgallery.element.triggerHandler( 'cbgallery.link.always', [cbgallery, response, textStatus, jqXHR] );
							});
						} else {
							cbgallery.element.find( '.galleryShareLinkArea' ).addClass( 'cbValidationError' );
							cbgallery.element.find( '.galleryShareLink' ).addClass( 'cbValidationError is-invalid' );
						}
					};

					cbgallery.element.find( '.galleryShareLinkSave' ).on( 'click', cbgallery.linkSaveHandler );
				} else if ( cbgallery.settings.mode == 'edit' ) {
					cbgallery.deleteHandler = function( e ) {
						e.preventDefault();

						if ( cbgallery.element.hasClass( 'galleryRequesting' ) ) {
							return;
						}

						var deleteUrl = $( this ).data( 'cbgallery-delete-url' );

						if ( ! deleteUrl ) {
							return false;
						}

						var deleteMedia = function() {
							cbgallery.element.addClass( 'galleryRequesting' );

							$.ajax({
								url: deleteUrl,
								type: 'POST',
								dataType: 'html',
								cache: false,
								beforeSend: function( jqXHR, textStatus, errorThrown ) {
									if ( cbgallery.element.hasClass( 'card' ) ) {
										cbgallery.element.removeClass( 'border-danger' );
									}

									cbgallery.element.find( '.galleryEditError' ).remove();
									cbgallery.element.find( '.galleryEditLoading' ).removeClass( 'hidden' );

									cbgallery.element.triggerHandler( 'cbgallery.delete.send', [cbgallery, jqXHR, textStatus, errorThrown] );
								}
							}).fail( function( jqXHR, textStatus, errorThrown ) {
								cbgallery.element.removeClass( 'galleryRequesting' );
								cbgallery.element.find( '.galleryEditLoading' ).addClass( 'hidden' );

								if ( cbgallery.element.hasClass( 'card' ) ) {
									cbgallery.element.addClass( 'border-danger' );
								}

								cbgallery.element.triggerHandler( 'cbgallery.delete.error', [cbgallery, jqXHR, textStatus, errorThrown] );
							}).done( function( data, textStatus, jqXHR ) {
								cbgallery.element.removeClass( 'galleryRequesting' );

								var response = null;

								if ( jqXHR.getResponseHeader( 'Content-Type' ).indexOf( 'json' ) !== -1 ) {
									try {
										response = JSON.parse( data );
									} catch( e ) {}
								} else {
									response = { status: true, message: data };
								}

								cbgallery.element.find( '.galleryEditLoading' ).addClass( 'hidden' );

								if ( response && ( typeof response.status != 'undefined' ) ) {
									if ( response.status === true ) {
										// We are deleting the element so lets make a clone for the sake of the delete event:
										var previous = cbgallery.element.clone( true );

										cbgallery.element.remove();

										previous.triggerHandler( 'cbgallery.delete.success', [cbgallery, response, textStatus, jqXHR] );
									} else if ( response.status === false ) {
										if ( cbgallery.element.hasClass( 'card' ) ) {
											cbgallery.element.addClass( 'border-danger' );
										}

										if ( ( typeof response.message != 'undefined' ) && response.message ) {
											var error = null;

											if ( cbgallery.settings.callback.delete.error ) {
												error = cbgallery.settings.callback.delete.error.call( cbgallery.element, cbgallery, response, data, textStatus, jqXHR );
											}

											if ( error ) {
												cbgallery.element.prepend( error );
											}
										}

										cbgallery.element.triggerHandler( 'cbgallery.delete.failed', [cbgallery, response, textStatus, jqXHR] );
									}
								}

								cbgallery.element.triggerHandler( 'cbgallery.delete.always', [cbgallery, response, textStatus, jqXHR] );
							});
						}

						var deleteMsg = $( this ).data( 'cbgallery-delete-message' );

						if ( deleteMsg ) {
							$.cbconfirm( deleteMsg ).done( deleteMedia );
						} else {
							deleteMedia();
						}

						return false;
					};

					cbgallery.element.find( '.galleryEditDelete' ).on( 'click', cbgallery.deleteHandler );

					cbgallery.editHandler = function( e ) {
						e.preventDefault();

						if ( cbgallery.element.hasClass( 'galleryRequesting' ) ) {
							return;
						}

						cbgallery.element.addClass( 'galleryRequesting' );

						cbgallery.element.find( '.galleryEditForm' ).ajaxSubmit({
							type: 'POST',
							dataType: 'html',
							beforeSerialize: function( form, options ) {
								cbgallery.element.triggerHandler( 'cbgallery.save.serialize', [cbgallery, form, options] );
							},
							beforeSubmit: function( formData, form, options ) {
								var validator = cbgallery.element.data( 'cbvalidate' );

								if ( validator ) {
									if ( ! validator.element.cbvalidate( 'validate' ) ) {
										return false;
									}
								}

								if ( cbgallery.element.hasClass( 'card' ) ) {
									cbgallery.element.removeClass( 'border-danger' );
								}

								cbgallery.element.find( '.galleryEditError' ).remove();
								cbgallery.element.find( '.galleryEditLoading' ).removeClass( 'hidden' );

								cbgallery.element.triggerHandler( 'cbgallery.save.submit', [cbgallery, formData, form, options] );
							},
							error: function( jqXHR, textStatus, errorThrown ) {
								cbgallery.element.removeClass( 'galleryRequesting' );
								cbgallery.element.find( '.galleryEditLoading' ).addClass( 'hidden' );

								if ( cbgallery.element.hasClass( 'card' ) ) {
									cbgallery.element.addClass( 'border-danger' );
								}

								cbgallery.element.triggerHandler( 'cbgallery.save.error', [cbgallery, jqXHR, textStatus, errorThrown] );
							},
							success: function( data, textStatus, jqXHR ) {
								cbgallery.element.removeClass( 'galleryRequesting' );

								var response = null;

								if ( jqXHR.getResponseHeader( 'Content-Type' ).indexOf( 'json' ) !== -1 ) {
									try {
										response = JSON.parse( data );
									} catch( e ) {}
								} else {
									response = { status: true, message: data };
								}

								cbgallery.element.find( '.galleryEditLoading' ).addClass( 'hidden' );

								if ( response && ( typeof response.status != 'undefined' ) ) {
									if ( response.status === true ) {
										var dataHtml = $( data );
										var loadScripts = parseHeaders.call( dataHtml, cbgallery );

										// We are replacing the element so lets make a clone for the sake of the save event:
										var previous = cbgallery.element.clone( true );

										cbgallery.element.replaceWith( dataHtml );

										parseScripts.call( dataHtml, cbgallery, loadScripts );

										dataHtml.find( '.cbTooltip,[data-hascbtooltip=\"true\"]' ).cbtooltip();

										// Update the element since we replaced it above:
										cbgallery.element = dataHtml;

										previous.triggerHandler( 'cbgallery.save.success', [cbgallery, response, data, textStatus, jqXHR] );
									} else if ( response.status === false ) {
										if ( cbgallery.element.hasClass( 'card' ) ) {
											cbgallery.element.addClass( 'border-danger' );
										}

										if ( ( typeof response.message != 'undefined' ) && response.message ) {
											var error = null;

											if ( cbgallery.settings.callback.edit.error ) {
												error = cbgallery.settings.callback.edit.error.call( cbgallery.element, cbgallery, response, data, textStatus, jqXHR );
											}

											if ( error ) {
												cbgallery.element.prepend( error );
											}
										}

										cbgallery.element.triggerHandler( 'cbgallery.save.failed', [cbgallery, response, data, textStatus, jqXHR] );
									}
								}
							}
						});

						return false;
					};

					cbgallery.element.find( '.galleryEditForm' ).on( 'submit', cbgallery.editHandler );
				}

				// Destroy the cbgallery element:
				cbgallery.element.on( 'remove.cbgallery destroy.cbgallery', function() {
					cbgallery.element.cbgallery( 'destroy' );
				});

				// Rebind the cbgallery element to pick up any data attribute modifications:
				cbgallery.element.on( 'rebind.cbgallery', function() {
					cbgallery.element.cbgallery( 'rebind' );
				});

				// If the cbgallery element is modified we need to rebuild it to ensure all our bindings are still ok:
				cbgallery.element.on( 'modified.cbgallery', function( e, oldId, newId, index ) {
					if ( oldId != newId ) {
						cbgallery.element.cbgallery( 'destroy' );
						cbgallery.element.cbgallery( cbgallery.options );
					}
				});

				// If the cbgallery is cloned we need to rebind it back:
				cbgallery.element.on( 'cloned.cbgallery', function( e, oldId ) {
					$( this ).off( '.cbgallery' );

					if ( cbgallery.settings.mode == 'modal' ) {
						$( document ).off( 'keydown.cbgallery', cbgallery.navigationHandler );
						$( document ).off( 'click.cbgallery', '.galleryModalAction', cbgallery.actionHandler );

						$( this ).off( 'cbtooltip.hidden', cbgallery.closeHandler );
						$( this ).off( 'cbtooltip.render', cbgallery.displayHandler );
					} else if ( cbgallery.settings.mode == 'share' ) {
						$( this ).find( '.galleryShareUpload' ).fileupload( 'destroy' );
						$( this ).find( '.galleryShareEdit' ).off( 'keyup change', 'input,select,textarea', cbgallery.uploadChangeHandler );
						$( this ).find( '.galleryShareUploadDropZone' ).off( 'click', cbgallery.dropZoneHandler );
						$( this ).find( '.galleryShareLinkSave' ).off( 'click', cbgallery.linkSaveHandler );
					} else if ( cbgallery.settings.mode == 'edit' ) {
						$( this ).find( '.galleryEditDelete' ).off( 'click', cbgallery.deleteHandler );
						$( this ).find( '.galleryEditSave' ).off( 'click', cbgallery.editHandler );
					}

					$( this ).removeData( 'cbgallery' );
					$( this ).cbgallery( cbgallery.options );
				});

				cbgallery.element.triggerHandler( 'cbgallery.init.after', [cbgallery] );

				// Bind the cbgallery to the element so it's reusable and chainable:
				cbgallery.element.data( 'cbgallery', cbgallery );

				// Add this instance to our instance array so we can keep track of our cbgallery instances:
				instances.push( cbgallery );
			});
		},
		rebind: function() {
			var cbgallery = $( this ).data( 'cbgallery' );

			if ( ! cbgallery ) {
				return this;
			}

			cbgallery.element.cbgallery( 'destroy' );
			cbgallery.element.cbgallery( cbgallery.options );

			return this;
		},
		destroy: function() {
			var cbgallery = $( this ).data( 'cbgallery' );

			if ( ! cbgallery ) {
				return false;
			}

			cbgallery.element.off( '.cbgallery' );

			$.each( instances, function( i, instance ) {
				if ( instance.element == cbgallery.element ) {
					instances.splice( i, 1 );

					return false;
				}

				return true;
			});

			if ( cbgallery.settings.mode == 'modal' ) {
				$( document ).off( 'keydown.cbgallery', cbgallery.navigationHandler );
				$( document ).off( 'click.cbgallery', '.galleryModalAction', cbgallery.actionHandler );

				cbgallery.element.off( 'cbtooltip.hidden', cbgallery.closeHandler );
				cbgallery.element.off( 'cbtooltip.render', cbgallery.displayHandler );
			} else if ( cbgallery.settings.mode == 'share' ) {
				cbgallery.element.find( '.galleryShareUpload' ).fileupload( 'destroy' );
				cbgallery.element.find( '.galleryShareEdit' ).off( 'keyup change', 'input,select,textarea', cbgallery.uploadChangeHandler );
				cbgallery.element.find( '.galleryShareUploadDropZone' ).off( 'click', cbgallery.dropZoneHandler );
				cbgallery.element.find( '.galleryShareLinkSave' ).off( 'click', cbgallery.linkSaveHandler );
			} else if ( cbgallery.settings.mode == 'edit' ) {
				cbgallery.element.find( '.galleryEditDelete' ).off( 'click', cbgallery.deleteHandler );
				cbgallery.element.find( '.galleryEditSave' ).off( 'click', cbgallery.editHandler );
			}

			cbgallery.element.removeData( 'cbgallery' );
			cbgallery.element.triggerHandler( 'cbgallery.destroyed', [cbgallery] );

			return true;
		},
		instances: function() {
			return instances;
		}
	};

	$.widget( 'blueimp.fileupload', $.blueimp.fileupload, {
		processActions: {
			extensions: function ( data, options ) {
				var $that = this;
				var deferred = $.Deferred();
				var cbgallery = options.cbgallery;

				if ( ! cbgallery.settings.extensions ) {
					deferred.resolveWith( $that, [data] );
				} else {
					var index = data.index;

					if ( ! index ) {
						index = 0;
					}

					var file = data.files[index];

					if ( ! ( new RegExp( '\\.(' + cbgallery.settings.extensions.replace( /,/g, '|' ) + ')$', 'i' ) ).test( file.name ) ) {
						if ( cbgallery.settings.messages.extensions ) {
							file.error = cbgallery.settings.messages.extensions.replace( '{0}', cbgallery.settings.extensions.replace( /,/g, ', ' ) );
						}

						deferred.rejectWith( $that, [data] );
					} else {
						deferred.resolveWith( $that, [data] );
					}
				}

				return deferred.promise();
			},
			acceptTypes: function ( data, options ) {
				var $that = this;
				var deferred = $.Deferred();
				var cbgallery = options.cbgallery;

				if ( ! cbgallery.settings.acceptTypes ) {
					deferred.resolveWith( $that, [data] );
				} else {
					var index = data.index;

					if ( ! index ) {
						index = 0;
					}

					var acceptedTypes = cbgallery.settings.acceptTypes.replace( /\s/g, '' ).replace( /,/g, '|' ).replace( /[\-\[\]\/\{\}\(\)\+\?\.\\\^\$\|]/g, "\\$&" ).replace( /,/g, "|" ).replace( /\/\*/g, "/.*" );
					var file = data.files[index];

					if ( file.type && ( ! ( new RegExp( '.?(' + acceptedTypes + ')$', 'i' ) ).test( file.type.replace( /mp3/, 'mpeg' ).replace( /m4a/, 'mp4' ) ) ) ) {
						if ( cbgallery.settings.messages.acceptTypes ) {
							file.error = cbgallery.settings.messages.acceptTypes.replace( '{0}', cbgallery.settings.acceptTypes );
						}

						deferred.rejectWith( $that, [data] );
					} else {
						deferred.resolveWith( $that, [data] );
					}
				}

				return deferred.promise();
			},
			minFileSize: function ( data, options ) {
				var $that = this;
				var deferred = $.Deferred();
				var cbgallery = options.cbgallery;

				if ( ( ! cbgallery.settings.minSize ) || ( ! cbgallery.settings.minSize[0] ) ) {
					deferred.resolveWith( $that, [data] );
				} else {
					var index = data.index;

					if ( ! index ) {
						index = 0;
					}

					var file = data.files[index];
					var size = bytesToType( file.size, cbgallery.settings.minSize[1] );

					if ( size < cbgallery.settings.minSize[0] ) {
						if ( cbgallery.settings.messages.minSize ) {
							file.error = cbgallery.settings.messages.minSize.replace( '{0}', cbgallery.settings.minSize[0] ).replace( '{1}', '0' ).replace( '{2}', cbgallery.settings.minSize[1] );
						}

						deferred.rejectWith( $that, [data] );
					} else {
						deferred.resolveWith( $that, [data] );
					}
				}

				return deferred.promise();
			},
			maxFileSize: function ( data, options ) {
				var $that = this;
				var deferred = $.Deferred();
				var cbgallery = options.cbgallery;

				if ( ( ! cbgallery.settings.maxSize ) || ( ! cbgallery.settings.maxSize[0] ) ) {
					deferred.resolveWith( $that, [data] );
				} else {
					var index = data.index;

					if ( ! index ) {
						index = 0;
					}

					var file = data.files[index];
					var size = bytesToType( file.size, cbgallery.settings.maxSize[1] );

					if ( size > cbgallery.settings.maxSize[0] ) {
						if ( cbgallery.settings.messages.maxSize ) {
							file.error = cbgallery.settings.messages.maxSize.replace( '{0}', '0' ).replace( '{1}', cbgallery.settings.maxSize[0] ).replace( '{2}', cbgallery.settings.maxSize[1] );
						}

						deferred.rejectWith( $that, [data] );
					} else {
						deferred.resolveWith( $that, [data] );
					}
				}

				return deferred.promise();
			},
			clientSideResize: function ( data, options ) {
				var $that = this;
				var deferred = $.Deferred();
				var index = data.index;

				if ( ! index ) {
					index = 0;
				}

				var file = data.files[index];
				var cbgallery = options.cbgallery;

				if ( ( ! window.FileReader ) || ( ! window.Blob ) || ( ! cbgallery.settings.clientResize ) || ( ! /image/.test( file.type ) ) || ( ! /\.(jpg|jpeg|png|webp|avif)$/i.test( file.name ) ) ) {
					deferred.resolveWith( $that, [data] );
				} else {
					if ( /\.(jpg|jpeg)$/i.test( file.name ) ) {
						var reader = new FileReader();

						reader.mimeType = file.type;

						reader.onload = function( readerEvent ) {
							var orientation = null;

							if ( window.DataView && ( ! CSS.supports( 'image-orientation', 'from-image' ) ) ) {
								var view = new DataView( readerEvent.target.result );

								if ( view.getUint16( 0, false ) == 0xFFD8 ) {
									var length = view.byteLength;
									var offset = 2;

									while ( offset < length ) {
										var marker = view.getUint16( offset, false );

										offset += 2;

										if ( marker == 0xFFE1 ) {
											if ( view.getUint32( offset += 2, false ) == 0x45786966 ) {
												var little = view.getUint16( offset += 6, false ) == 0x4949;

												offset += view.getUint32( offset + 4, little );

												var tags = view.getUint16( offset, little );

												offset += 2;

												for ( var i = 0; i < tags; i++ ) {
													if ( view.getUint16( offset + ( i * 12 ), little ) == 0x0112 ) {
														orientation = view.getUint16( offset + ( i * 12 ) + 8, little );
														break;
													}
												}

												if ( orientation ) {
													break;
												}
											} else {
												break;
											}
										} else if ( ( marker & 0xFF00 ) != 0xFF00 ) {
											break;
										} else {
											offset += view.getUint16( offset, false );
										}
									}
								}
							}

							file.orientation = orientation;

							resizeImage.call( $that, deferred, data, index, file, cbgallery );
						};

						reader.onerror = function() {
							deferred.resolveWith( $that, [data] );
						};

						reader.readAsArrayBuffer( file );
					} else {
						file.orientation = null;

						resizeImage.call( $that, deferred, data, index, file, cbgallery );
					}
				}

				return deferred.promise();
			}
		}
	});

	function parseModal( data, api, cbgallery ) {
		var dataHtml = $( data );
		var loadScripts = parseHeaders.call( dataHtml, cbgallery );

		api.set( 'content.text', dataHtml[0].outerHTML );

		parseScripts.call( api.elements.content, cbgallery, loadScripts );

		if ( api.elements.content ) {
			api.elements.content.find( '.cbTooltip,[data-hascbtooltip=\"true\"]' ).cbtooltip();

			api.elements.content.find( '.galleryModalScrollLeft' ).on( 'click', function () {
				var previous = $( this ).find( '.galleryModalScrollLeftIcon' ).data( 'cbgallery-previous' );

				if ( typeof previous != 'undefined' ) {
					api.toggle( false );

					if ( typeof previous == 'number' ) {
						cbgallery.element.closest( '.galleryContainer' ).siblings().addBack().eq( previous ).find( '.galleryModalToggle:first' ).click();
					} else {
						cbgallery.element.closest( '.galleryContainer' ).siblings( previous ).find( '.galleryModalToggle:first' ).click();
					}
				}
			});

			api.elements.content.find( '.galleryModalScrollRight' ).on( 'click', function () {
				var next = $( this ).find( '.galleryModalScrollRightIcon' ).data( 'cbgallery-next' );

				if ( typeof next != 'undefined' ) {
					api.toggle( false );

					if ( typeof next == 'number' ) {
						cbgallery.element.closest( '.galleryContainer' ).siblings().addBack().eq( next ).find( '.galleryModalToggle:first' ).click();
					} else {
						cbgallery.element.closest( '.galleryContainer' ).siblings( next ).find( '.galleryModalToggle:first' ).click();
					}
				}
			});

			api.elements.content.find( '.galleryModalItem' ).on( 'swipeleft swiperight', cbgallery.navigationHandler );

			api.elements.content.on( 'click', '.galleryModalAlert', function() {
				$( this ).remove();
			});
		}

		$( document ).off( 'keydown.cbgallery' ).on( 'keydown.cbgallery', cbgallery.navigationHandler );
		$( document ).off( 'click.cbgallery' ).on( 'click.cbgallery', '.galleryModalAction', cbgallery.actionHandler );
	}

	function resizeImage( deferred, data, index, file, cbgallery ) {
		var $that = this;
		var maxWidth = cbgallery.settings.maxWidth;
		var maxHeight = cbgallery.settings.maxHeight;
		var aspectRatio = cbgallery.settings.aspectRatio;
		var alwaysResample = cbgallery.settings.alwaysResample;
		var imgReader = new FileReader();

		imgReader.mimeType = file.type;

		// Always process WEBP and AVIF as we need to convert it to PNG:
		if ( ( file.type == 'image/webp' ) || ( file.type == 'image/webp' ) ) {
			alwaysResample = true;
		}

		imgReader.onload = function( imgReaderEvent ) {
			var image = new Image();

			image.mimeType = this.mimeType;

			image.onload = function( imageEvent ) {
				var originalImage = image;
				var originalWidth = image.width;
				var originalHeight = image.height;

				var mimeType = image.mimeType;
				var width = originalWidth;
				var height = originalHeight;

				// Lets correctly rotate the image before we do any form of cropping and resizing:
				if ( file.orientation ) {
					var orientationCanvas = document.createElement( 'canvas' );

					if ( ( file.orientation > 4 ) && ( file.orientation < 9 ) ) {
						width = originalHeight;
						maxWidth = cbgallery.settings.maxHeight;
						height = originalWidth;
						maxHeight = cbgallery.settings.maxWidth;

						orientationCanvas.width = originalHeight;
						orientationCanvas.height = originalWidth;
					} else {
						orientationCanvas.width = originalWidth;
						orientationCanvas.height = originalHeight;
					}

					var orientationContext = orientationCanvas.getContext( '2d' );

					orientationContext.mozImageSmoothingEnabled = false;
					orientationContext.webkitImageSmoothingEnabled = false;
					orientationContext.msImageSmoothingEnabled = false;
					orientationContext.imageSmoothingEnabled = false;
					orientationContext.imageSmoothingQuality = 'high';

					switch ( file.orientation ) {
						case 2:
							orientationContext.transform( -1, 0, 0, 1, originalWidth, 0 );
							break;
						case 3:
							orientationContext.transform( -1, 0, 0, -1, originalWidth, originalHeight );
							break;
						case 4:
							orientationContext.transform( 1, 0, 0, -1, 0, originalHeight );
							break;
						case 5:
							orientationContext.transform( 0, 1, 1, 0, 0, 0 );
							break;
						case 6:
							orientationContext.transform( 0, 1, -1, 0, originalHeight, 0 );
							break;
						case 7:
							orientationContext.transform( 0, -1, -1, 0, originalHeight, originalWidth );
							break;
						case 8:
							orientationContext.transform( 0, -1, 1, 0, 0, originalWidth );
							break;
					}

					orientationContext.drawImage( originalImage, 0, 0 );

					// Replace the image source with our rotated one:
					originalImage = orientationCanvas;
				}

				if ( ! maxWidth ) {
					maxWidth = width;
				}

				if ( ! maxHeight ) {
					maxHeight = height;
				}

				var dx = 0;
				var dy = 0;

				if ( ! aspectRatio ) {
					width = maxWidth;
					height = maxHeight;
				} else if ( aspectRatio == 1 ) {
					if ( width > maxWidth ) {
						height = Math.floor( ( height * ( maxWidth / width ) ) );
						width = maxWidth;
					}

					if ( height > maxHeight ) {
						width = Math.floor( ( width * ( maxHeight / height ) ) );
						height = maxHeight;
					}
				} else if ( aspectRatio == 2 ) {
					if ( ( maxWidth > maxHeight ) || ( ( maxHeight == maxWidth ) && ( height > width ) ) ) {
						height = Math.floor( ( height * ( maxWidth / width ) ) );
						width = maxWidth;
						dy = Math.floor( ( ( maxHeight / 2 ) - ( height / 2 ) ) );
					} else if ( ( maxHeight > maxWidth ) || ( ( maxHeight == maxWidth ) && ( width > height ) ) ) {
						width = Math.floor( ( width * ( maxHeight / height ) ) );
						height = maxHeight;
						dx = Math.floor( ( ( maxWidth / 2 ) - ( width / 2 ) ) );
					} else if ( width == height ) {
						width = maxWidth;
						height = maxHeight;
					}
				}

				var cropOrientation = null;

				if ( height > width ) {
					cropOrientation = 'portrait';

					if ( height <= maxHeight ) {
						cropOrientation = 'landscape';
					}
				} else if ( width > height ) {
					cropOrientation = 'landscape';

					if ( width <= maxWidth ) {
						cropOrientation = 'portrait';
					}
				} else {
					cropOrientation = 'square';
				}

				if ( ( ! alwaysResample ) && ( originalWidth == width ) && ( originalHeight == height ) && ( aspectRatio != 3 ) ) {
					// No change in size so lets abort resizing:
					deferred.resolveWith( $that, [data] );
				} else {
					var canvas = document.createElement( 'canvas' );

					if ( aspectRatio == 2 ) {
						canvas.width = maxWidth;
						canvas.height = maxHeight;

						if ( cropOrientation == 'square' ) {
							dx = 0;
							dy = 0;
						}
					} else {
						canvas.width = width;
						canvas.height = height;
					}

					var context = canvas.getContext( '2d' );

					context.mozImageSmoothingEnabled = false;
					context.webkitImageSmoothingEnabled = false;
					context.msImageSmoothingEnabled = false;
					context.imageSmoothingEnabled = false;
					context.imageSmoothingQuality = 'high';

					context.drawImage( originalImage, dx, dy, width, height );

					var blobRequest = new XMLHttpRequest();
					var name = file.name;

					if ( mimeType == 'image/webp' ) {
						// If this is WEBP change it to PNG:
						mimeType = 'image/png';
						name = name.replace( '.webp', '.png' );
					} else if ( mimeType == 'image/avif' ) {
						// If this is AVIF change it to PNG:
						mimeType = 'image/png';
						name = name.replace( '.avif', '.png' );
					}

					blobRequest.open( 'GET', canvas.toDataURL( mimeType ), true );
					blobRequest.responseType = 'arraybuffer';

					blobRequest.onload = function() {
						if ( this.response ) {
							var newFile = new Blob( [this.response], {type: mimeType} );

							newFile.name = name;
							newFile.context = file.context;
							newFile.error = file.error;

							data.files[index] = newFile;
						}

						deferred.resolveWith( $that, [data] );
					};

					blobRequest.onerror = function() {
						deferred.resolveWith( $that, [data] );
					};

					blobRequest.send();
				}
			};

			image.onerror = function() {
				deferred.resolveWith( $that, [data] );
			}

			image.src = imgReaderEvent.target.result;
		};

		imgReader.onerror = function() {
			deferred.resolveWith( $that, [data] );
		};

		imgReader.readAsDataURL( file );
	}

	function bytesToType( bytes, type ) {
		if ( type == 'TB' ) {
			bytes = ( ( ( ( bytes / 1024 ) / 1024 ) / 1024 ) / 1024 );
		} else if ( type == 'GB' ) {
			bytes = ( ( ( bytes / 1024 ) / 1024 ) / 1024 );
		} else if ( type == 'MB' ) {
			bytes = ( ( bytes / 1024 ) / 1024 );
		} else if ( type == 'KB' ) {
			bytes = ( bytes / 1024 );
		}

		return bytes;
	}

	function parseHeaders( cbgallery ) {
		var element = ( this.jquery ? this : $( this ) );
		var headers = element.find( '.galleryHeaders' );

		if ( ! headers.length ) {
			headers = element.filter( '.galleryHeaders' );
		}

		if ( ! headers.length ) {
			return [];
		}

		var head = $( 'head' );
		var loadedCSS = [];
		var loadedScripts = [];

		head.find( 'link' ).each( function() {
			var cssUrl = $( this ).attr( 'href' );

			if ( typeof cssUrl != 'undefined' ) {
				loadedCSS.push( cssUrl );
			}
		});

		head.find( 'script' ).each( function() {
			var scriptUrl = $( this ).attr( 'src' );

			if ( typeof scriptUrl != 'undefined' ) {
				loadedScripts.push( scriptUrl );
			}
		});

		headers.children( 'link' ).each( function() {
			var cssUrl = $( this ).attr( 'href' );

			if ( ( typeof cssUrl == 'undefined' ) || ( loadedCSS.indexOf( cssUrl ) !== -1 ) ) {
				$( this ).remove();

				return;
			}

			var stylesheetPosition = $( 'head' ).find( 'link[href*="com_comprofiler"][rel="stylesheet"]' ).last();

			if ( ! stylesheetPosition.length ) {
				// CB isn't loaded so lets just do a temporary usage:
				return;
			}

			// CB is already loaded so lets be sure we insert these after CB:
			var stylesheet = document.createElement( 'link' );

			stylesheet.href = cssUrl;
			stylesheet.rel = 'stylesheet';

			stylesheetPosition[0].after( stylesheet );

			$( this ).remove();
		});

		var loadScripts = [];

		headers.children( 'script' ).each( function() {
			var scriptUrl = $( this ).attr( 'src' );

			if ( typeof scriptUrl == 'undefined' ) {
				loadScripts.push( this );
			} else {
				if ( loadedScripts.indexOf( scriptUrl ) === -1 ) {
					loadScripts.push( this );
				}
			}

			$( this ).remove();
		});

		return loadScripts;
	}

	function parseScripts( cbgallery, loadScripts ) {
		if ( ! loadScripts.length ) {
			return;
		}

		var element = ( this.jquery ? this : $( this ) );
		var scripts = $( '<div class="galleryHeadersScripts" style="position: absolute; display: none; height: 0; width: 0; z-index: -999;" />' );

		var loadScript = function( i ) {
			var nextScript = ( i + 1 );
			var scriptUrl = $( this ).attr( 'src' );

			if ( scriptUrl ) {
				var scriptPosition = $( 'head' ).find( 'script[src*="com_comprofiler"]' ).last();

				if ( ! scriptPosition.length ) {
					// CB isn't loaded so lets just do a temporary usage:
					$.ajax({
						url: scriptUrl,
						dataType: 'script',
						cache: true
					}).always( function() {
						scripts.append( '<script type="text/javascript" src="' + scriptUrl + '"></script>' );

						if ( typeof loadScripts[nextScript] != 'undefined' ) {
							loadScript.call( loadScripts[nextScript], nextScript );
						}
					});
				} else {
					// CB is already loaded so lets be sure we insert these after CB:
					var script = document.createElement( 'script' );

					script.type = 'text/javascript';
					script.onload = function () {
						if ( typeof loadScripts[nextScript] != 'undefined' ) {
							loadScript.call( loadScripts[nextScript], nextScript );
						}
					};
					script.src = scriptUrl;

					scriptPosition[0].after( script );
				}
			} else {
				scripts.append( '<script type="text/javascript">' + $( this ).text() + '</script>' );

				if ( typeof loadScripts[nextScript] != 'undefined' ) {
					loadScript.call( loadScripts[nextScript], nextScript );
				}
			}
		};

		loadScript.call( loadScripts[0], 0 );

		var headers = element.find( '.galleryHeaders' );

		if ( ! headers.length ) {
			headers = element.filter( '.galleryHeaders' );
		}

		headers.append( scripts );
	}

	function confirmToggle( cbgallery )
	{
		var element = ( this.jquery ? this : $( this ) );

		var setInitialValues = function() {
			var currentValue = $( this ).val();

			if ( $.isArray( currentValue ) ) {
				currentValue = currentValue.join( '|*|' );
			}

			$( this ).data( 'cbgallery-initial-value', currentValue );
		};

		element.find( 'input,select,textarea' ).each( setInitialValues );

		var editSaveToggleDone = function( subevent, subcbgallery ) {
			subcbgallery.element.on( 'cbgallery.save.success', editSaveToggleDone );
			subcbgallery.element.on( 'cbgallery.delete.success', editDeleteToggleDone );

			subcbgallery.element.find( 'input,select,textarea' ).each( setInitialValues );

			if ( cbgallery.element.find( '.galleryShareEdit .galleryEditChanged' ).length ) {
				cbgallery.element.find( '.galleryShareEditConfirm' ).removeClass( 'hidden' );
				cbgallery.element.find( '.galleryShareEditDone' ).addClass( 'hidden' );
			} else {
				cbgallery.element.find( '.galleryShareEditConfirm' ).addClass( 'hidden' );
				cbgallery.element.find( '.galleryShareEditDone' ).removeClass( 'hidden' );
			}

			cbgallery.element.find( '.galleryShareEditBack' ).addClass( 'hidden' );
		};

		var editDeleteToggleDone = function() {
			if ( ! cbgallery.element.find( '.galleryShareEdit .galleryEdit' ).length ) {
				cbgallery.element.find( '.galleryShareEdit' ).addClass( 'hidden' );
				cbgallery.element.find( '.galleryShareEditConfirm' ).addClass( 'hidden' );
				cbgallery.element.find( '.galleryShareEditDone' ).addClass( 'hidden' );
				cbgallery.element.find( '.galleryShareEditBack' ).removeClass( 'hidden' );
			} else {
				if ( cbgallery.element.find( '.galleryShareEdit .galleryEditChanged' ).length ) {
					cbgallery.element.find( '.galleryShareEditConfirm' ).removeClass( 'hidden' );
					cbgallery.element.find( '.galleryShareEditDone' ).addClass( 'hidden' );
				} else {
					cbgallery.element.find( '.galleryShareEditConfirm' ).addClass( 'hidden' );
					cbgallery.element.find( '.galleryShareEditDone' ).removeClass( 'hidden' );
				}

				cbgallery.element.find( '.galleryShareEditBack' ).addClass( 'hidden' );
			}
		};

		element.on( 'cbgallery.save.success', editSaveToggleDone );
		element.on( 'cbgallery.delete.success', editDeleteToggleDone );

		cbgallery.element.find( '.galleryShareEditConfirm' ).addClass( 'hidden' );
		cbgallery.element.find( '.galleryShareEditDone' ).removeClass( 'hidden' );
		cbgallery.element.find( '.galleryShareEditBack' ).addClass( 'hidden' );
	}

	$.fn.cbgallery = function( options ) {
		if ( methods[options] ) {
			return methods[ options ].apply( this, Array.prototype.slice.call( arguments, 1 ) );
		} else if ( ( typeof options == 'object' ) || ( ! options ) ) {
			return methods.init.apply( this, arguments );
		}

		return this;
	};

	$.fn.cbgallery.defaults = {
		init: true,
		useData: true,
		url: null,
		mode: 'modal',
		pasteZone: null,
		acceptTypes: null,
		extensions: null,
		minSize: [ 0, 'KB' ],
		maxSize: [ 0, 'KB' ],
		clientResize: true,
		alwaysResample: true,
		maxWidth: 0,
		maxHeight: 0,
		aspectRatio: 1,
		previous: null,
		next: null,
		request: null,
		callback: {
			upload: {
				add: null,
				error: null
			},
			link: {
				error: null
			},
			delete: {
				error: null
			},
			edit: {
				error: null
			}
		},
		messages: {
			acceptTypes: 'Please enter a value with a valid extension.',
			extensions: 'Please enter a value with a valid extension.',
			minSize: 'File size exceeds the minimum of {0} {2}s.',
			maxSize: 'File size exceeds the maximum of {1} {2}s.'
		}
	};
})(jQuery);