<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\AutoActions\Table;

use CBLib\Application\Application;
use CBLib\Database\Table\Table;
use CBLib\Language\CBTxt;

\defined( 'CBLIB' ) or die();

class UseTable extends Table
{
	/** @var null|int */
	public $id;
	/** @var null|int */
	public $user_id;
	/** @var null|int */
	public $auto_action;
	/** @var null|string */
	public $date;

	/**
	 * Table name in database
	 *
	 * @var string
	 */
	protected $_tbl			=	'#__comprofiler_plugin_autoactions_uses';

	/**
	 * Primary key(s) of table
	 *
	 * @var string
	 */
	protected $_tbl_key		=	'id';

	/**
	 * @return bool
	 */
	public function check(): bool
	{
		if ( ! $this->getAutoAction() ) {
			$this->setError( CBTxt::T( 'Auto Action not specified!' ) );

			return false;
		}

		return true;
	}

	/**
	 * @param bool $updateNulls
	 * @return bool
	 */
	public function store( $updateNulls = false ): bool
	{
		if ( ! $this->getDate() ) {
			$this->setDate( Application::Database()->getUtcDateTime() );
		}

		return ( parent::store( $updateNulls ) !== false );
	}

	/**
	 * @return int
	 */
	public function getId(): int
	{
		return $this->getInt( 'id', 0 );
	}

	/**
	 * @param null|int $id
	 */
	public function setId( ?int $id ): void
	{
		$this->id	=	$id;
	}

	/**
	 * @return int
	 */
	public function getUserId(): int
	{
		return $this->getInt( 'user_id', 0 );
	}

	/**
	 * @param int $user_id
	 */
	public function setUserId( int $user_id ): void
	{
		$this->user_id	=	$user_id;
	}

	/**
	 * @return int
	 */
	public function getAutoAction(): int
	{
		return $this->getInt( 'auto_action', 0 );
	}

	/**
	 * @param int $auto_action
	 */
	public function setAutoAction( int $auto_action ): void
	{
		$this->auto_action	=	$auto_action;
	}

	/**
	 * @return string
	 */
	public function getDate(): string
	{
		return $this->getString( 'date', '' );
	}

	/**
	 * @param string $date
	 */
	public function setDate( string $date ): void
	{
		$this->date	=	$date;
	}
}