<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\AutoActions\Action;

use CB\Database\Table\UserTable;
use CBLib\Language\CBTxt;
use CBLib\Registry\ParamsInterface;
use GuzzleHttp\Client;

\defined( 'CBLIB' ) or die();

class RequestAction extends Action
{

	/**
	 * @param UserTable $user
	 * @return string
	 */
	public function execute( UserTable $user ): string
	{
		$return								=	'';

		foreach ( $this->autoaction()->getParams()->subTree( 'request' ) as $row ) {
			/** @var ParamsInterface $row */
			$url							=	$this->string( $user, $row->getString( 'url', '' ), ( preg_match( '/^\[[a-zA-Z0-9-_]+\]$/', $row->getString( 'url', '' ) ) ? false : [ '\CB\Plugin\AutoActions\CBAutoActions', 'escapeURL' ] ) );

			if ( ! $url ) {
				$this->error( CBTxt::T( 'AUTO_ACTION_REQUEST_NO_URL', ':: Action [action] :: Request skipped due to missing url', [ '[action]' => $this->autoaction()->getId() ] ) );
				continue;
			}

			try {
				$client						=	new Client();
				$options					=	[];

				if ( $row->getString( 'auth', 'none' ) === 'basic' ) {
					$username				=	$this->string( $user, $row->getString( 'auth_username', '' ) );
					$password				=	$this->string( $user, $row->getString( 'auth_password', '' ) );

					if ( $username && $password ) {
						$options['auth']	=	[ $username, $password ];
					}
				}

				$body						=	[];

				foreach ( $row->subTree( 'request' ) as $request ) {
					/** @var ParamsInterface $request */
					$key					=	$request->getString( 'key', '' );

					if ( $key ) {
						$body[$key]			=	$this->string( $user, $request->getRaw( 'value', '' ), false, $request->getBool( 'translate', false ) );
					}
				}

				$headers					=	[];

				foreach ( $row->subTree( 'header' ) as $header ) {
					/** @var ParamsInterface $header */
					$key					=	$header->getString( 'key', '' );

					if ( $key ) {
						$headers[$key]		=	$this->string( $user, $header->getRaw( 'value', '' ), false, $header->getBool( 'translate', false ) );
					}
				}

				if ( $headers ) {
					$options['headers']		=	$headers;
				}

				if ( $row->getString( 'method', 'GET' ) === 'POST' ) {
					if ( $body ) {
						if ( cbGuzzleVersion() >= 6 ) {
							$options['form_params']		=	$body;
						} else {
							$options['body']			=	$body;
						}
					}

					$result					=	$client->post( $url, $options );
				} else {
					if ( $body ) {
						$options['query']	=	$body;
					}

					$result					=	$client->get( $url, $options );
				}

				if ( (int) $result->getStatusCode() !== 200 ) {
					$this->error( CBTxt::T( 'AUTO_ACTION_REQUEST_FAILED', ':: Action [action] :: Request failed. Error: [error]', [ '[action]' => $this->autoaction()->getId(), '[error]' => $result->getStatusCode() ] ) );
					continue;
				}

				$return						.=	(string) $result->getBody();
			} catch ( \Exception $e ) {
				$this->error( CBTxt::T( 'AUTO_ACTION_REQUEST_FAILED', ':: Action [action] :: Request failed. Error: [error]', [ '[action]' => $this->autoaction()->getId(), '[error]' => $e->getMessage() ] ) );
				continue;
			}
		}

		return $return;
	}
}