<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\AutoActions\Action;

use CB\Database\Table\UserTable;
use CBLib\Language\CBTxt;
use CBLib\Registry\ParamsInterface;

\defined( 'CBLIB' ) or die();

class PmsAction extends Action
{

	/**
	 * @param UserTable $user
	 */
	public function execute( UserTable $user ): void
	{
		global $_CB_PMS;

		foreach ( $this->autoaction()->getParams()->subTree( 'pms' ) as $row ) {
			/** @var ParamsInterface $row */
			$pmFrom				=	$row->getString( 'from', '' );

			if ( ! $pmFrom ) {
				$pmFromId		=	$user->getInt( 'id', 0 );
			} else {
				$pmFromId		=	(int) $this->string( $user, $pmFrom );
			}

			if ( $user->getInt( 'id', 0 ) !== $pmFromId ) {
				$actionUser		=	\CBuser::getUserDataInstance( $pmFromId );
			} else {
				$actionUser		=	$user;
			}

			$pmTo				=	$this->string( $actionUser, $row->getString( 'to', '' ) );

			if ( ! $pmTo ) {
				$this->error( CBTxt::T( 'AUTO_ACTION_PMS_NO_TO', ':: Action [action] :: Private Message skipped due to missing to', [ '[action]' => $this->autoaction()->getId() ] ) );
				continue;
			}

			$pmMessage			=	$this->pmString( $pmTo, $actionUser, $row->getRaw( 'message', '' ), false );

			if ( ! $pmMessage ) {
				$this->error( CBTxt::T( 'AUTO_ACTION_PMS_NO_MSG', ':: Action [action] :: Private Message skipped due to missing message', [ '[action]' => $this->autoaction()->getId() ] ) );
				continue;
			}

			if ( $pmFrom === 0 ) {
				$pmFromId		=	0;
				$pmFromName		=	$this->pmString( $pmTo, $actionUser, $row->getString( 'from_name', '' ) );
				$pmFromEmail	=	$this->pmString( $pmTo, $actionUser, $row->getString( 'from_email', '' ) );
			} else {
				$pmFromName		=	null;
				$pmFromEmail	=	null;
			}

			$pmSubject			=	$this->pmString( $pmTo, $actionUser, $row->getString( 'subject', '' ) );

			$_CB_PMS->sendPMSMSG( $pmTo, $pmFromId, $pmSubject, $pmMessage, $row->getBool( 'from_system', true ), $pmFromName, $pmFromEmail );
		}
	}

	/**
	 * Parses a string through action substitutions
	 *
	 * @param int             $recipient
	 * @param null|UserTable  $user
	 * @param null|string     $string
	 * @param null|array|bool $htmlspecialchars
	 * @param null|bool       $translate
	 * @param null|bool       $format
	 * @param null|bool       $prepare
	 * @param null|bool       $substitutions
	 * @param array           $extras
	 * @return string
	 */
	private function pmString( int $recipient, ?UserTable $user, ?string $string, $htmlspecialchars = true, ?bool $translate = null, ?bool $format = null, ?bool $prepare = null, ?bool $substitutions = null, array $extras = [] ): string
	{
		$string					=	str_ireplace( '[recipient]', $recipient, $string );

		$extras['recipient']	=	$recipient;

		return $this->string( $user, $string, $htmlspecialchars, $translate, $format, $prepare, $substitutions, $extras );
	}
}