<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\AutoActions\Action;

use CB\Database\Table\UserTable;
use CBLib\Application\Application;
use CBLib\Language\CBTxt;

\defined( 'CBLIB' ) or die();

class K2Action extends Action
{

	/**
	 * @param UserTable $user
	 */
	public function execute( UserTable $user ): void
	{
		global $_CB_database;

		if ( ! $this->installed() ) {
			$this->error( CBTxt::T( 'AUTO_ACTION_K2_NOT_INSTALLED', ':: Action [action] :: K2 is not installed', [ '[action]' => $this->autoaction()->getId() ] ) );
			return;
		}

		$params				=	$this->autoaction()->getParams()->subTree( 'k2' );
		$userId				=	$params->getString( 'user', '' );

		if ( ! $userId ) {
			$userId			=	$user->getInt( 'id', 0 );
		} else {
			$userId			=	(int) $this->string( $user, $userId );
		}

		if ( $user->getInt( 'id', 0 ) !== $userId ) {
			$actionUser		=	\CBuser::getUserDataInstance( $userId );
		} else {
			$actionUser		=	$user;
		}

		if ( ! $actionUser->getInt( 'id', 0 ) ) {
			$this->error( CBTxt::T( 'AUTO_ACTION_K2_NO_USER', ':: Action [action] :: K2 skipped due to missing user', [ '[action]' => $this->autoaction()->getId() ] ) );
			return;
		}

		if ( $params->getInt( 'mode', 1 ) ) {
			$group			=	$params->getInt( 'group', 0 );
			$gender			=	$this->string( $actionUser, $params->getString( 'gender', '' ) );
			$description	=	$this->string( $actionUser, $params->getRaw( 'description', '' ), false );
			$url			=	$this->string( $actionUser, $params->getString( 'url', '' ) );
			$notes			=	$this->string( $actionUser, $params->getRaw( 'notes', '' ), false );

			$query			=	'SELECT *'
							.	"\n FROM " . $_CB_database->NameQuote( '#__k2_users' )
							.	"\n WHERE " . $_CB_database->NameQuote( 'userID' ) . " = " . $actionUser->getInt( 'id', 0 );
			$_CB_database->setQuery( $query, 0, 1 );
			$k2User			=	new \stdClass();
			$_CB_database->loadObject( $k2User );

			if ( $k2User ) {
				$set		=	[];

				if ( $group && ( $k2User->group !== $group ) ) {
					$set[]	=	$_CB_database->NameQuote( 'group' ) . " = " . $_CB_database->Quote( $group );
				}

				if ( $gender && ( $k2User->gender !== $gender ) ) {
					$set[]	=	$_CB_database->NameQuote( 'gender' ) . " = " . $_CB_database->Quote( $gender );
				}

				if ( $description && ( $k2User->description !== $description ) ) {
					$set[]	=	$_CB_database->NameQuote( 'description' ) . " = " . $_CB_database->Quote( $description );
				}

				if ( $url && ( $k2User->url !== $url ) ) {
					$set[]	=	$_CB_database->NameQuote( 'url' ) . " = " . $_CB_database->Quote( $url );
				}

				if ( $notes && ( $k2User->notes !== $notes ) ) {
					$set[]	=	$_CB_database->NameQuote( 'notes' ) . " = " . $_CB_database->Quote( $notes );
				}

				if ( ! empty( $set ) ) {
					$query	=	'UPDATE ' . $_CB_database->NameQuote( '#__k2_users' )
							.	"\n SET " . implode( ', ', $set )
							.	"\n WHERE " . $_CB_database->NameQuote( 'userID' ) . " = " . $actionUser->getInt( 'id', 0 );
					$_CB_database->setQuery( $query );
					$_CB_database->query();
				}
			} else {
				$ip			=	Application::Input()->getString( 'server/REMOTE_ADDR', '' );
				$hostname	=	gethostbyaddr( $ip );

				$query		=	'INSERT INTO ' . $_CB_database->NameQuote( '#__k2_users' )
							.	"\n ("
							.		$_CB_database->NameQuote( 'userID' )
							.		', ' . $_CB_database->NameQuote( 'userName' )
							.		', ' . $_CB_database->NameQuote( 'gender' )
							.		', ' . $_CB_database->NameQuote( 'description' )
							.		', ' . $_CB_database->NameQuote( 'url' )
							.		', ' . $_CB_database->NameQuote( 'group' )
							.		', ' . $_CB_database->NameQuote( 'ip' )
							.		', ' . $_CB_database->NameQuote( 'hostname' )
							.		', ' . $_CB_database->NameQuote( 'notes' )
							.	')'
							.	"\n VALUES ("
							.		$actionUser->getInt( 'id', 0 )
							.		', ' . $_CB_database->Quote( $actionUser->getString( 'username', '' ) )
							.		', ' . $_CB_database->Quote( ( $gender ?: 'm' ) )
							.		', ' . $_CB_database->Quote( $description )
							.		', ' . $_CB_database->Quote( $url )
							.		', ' . ( $group ?: 1 )
							.		', ' . $_CB_database->Quote( $ip )
							.		', ' . $_CB_database->Quote( $hostname )
							.		', ' . $_CB_database->Quote( $notes )
							.	')';
				$_CB_database->setQuery( $query );
				$_CB_database->query();

				$query		=	'DELETE'
							.	"\n FROM " . $_CB_database->NameQuote( '#__k2_users' )
							.	"\n WHERE " . $_CB_database->NameQuote( 'userID' ) . " = 0"
							.	"\n AND " . $_CB_database->NameQuote( 'ip' ) . " = " . $_CB_database->Quote( $ip )
							.	"\n AND " . $_CB_database->NameQuote( 'hostname' ) . " = " . $_CB_database->Quote( $hostname );
				$_CB_database->setQuery( $query );
				$_CB_database->query();
			}
		} else {
			$query			=	'DELETE'
							.	"\n FROM " . $_CB_database->NameQuote( '#__k2_users' )
							.	"\n WHERE " . $_CB_database->NameQuote( 'userID' ) . " = " . $actionUser->getInt( 'id', 0 );
			$_CB_database->setQuery( $query );
			$_CB_database->query();
		}
	}

	/**
	 * @return bool
	 */
	public function installed(): bool
	{
		global $_CB_framework;

		return is_dir( $_CB_framework->getCfg( 'absolute_path' ) . '/administrator/components/com_k2' ) && class_exists( 'K2Model' );
	}
}