<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\AutoActions\Action;

use CB\Database\Table\UserTable;
use CB\Plugin\AutoActions\CBAutoActions;
use CBLib\Language\CBTxt;
use CBLib\Registry\ParamsInterface;

\defined( 'CBLIB' ) or die();

class CodeAction extends Action
{

	/**
	 * @param UserTable $user
	 * @return null|array|string
	 */
	public function execute( UserTable $user )
	{
		global $_CB_framework;

		$return							=	null;

		foreach ( $this->autoaction()->getParams()->subTree( 'code' ) as $row ) {
			/** @var ParamsInterface $row */
			$code						=	$this->string( $user, $row->getRaw( 'code', '' ), false );
			$url						=	$this->string( $user, $row->getString( 'url', '' ) );
			$method						=	$row->getString( 'method', 'HTML' );

			if ( ( ! $code ) && ( ! $url ) && ( $method !== 'METADATA' ) ) {
				continue;
			}

			$content					=	null;

			switch ( $method ) {
				case 'PHP1':
				case 'PHP2':
				case 'PHP':
					$autoaction			=	$this->autoaction();
					$variables			=	$this->variables();

					try {
						$content		=	CBAutoActions::outputCode( $code, $autoaction, $user, $variables, $this );
					} catch ( \Exception $e ) {
						$this->error( CBTxt::T( 'AUTO_ACTION_CODE_FAILED', ':: Action [action] :: Code failed. Error: [error]', [ '[action]' => $this->autoaction()->getId(), '[error]' => $e->getMessage() ] ) );
						continue 2;
					}
					break;
				case 'JS':
					$_CB_framework->document->addHeadScriptDeclaration( $code );
					break;
				case 'JS_URL':
					$_CB_framework->document->addHeadScriptUrl( $url );
					break;
				case 'JQUERY':
					$plugins			=	$row->getString( 'plugins', '' );

					if ( $plugins ) {
						$plgs			=	explode( ',', $plugins );
					} else {
						$plgs			=	[];
					}

					$pluginUrls			=	$this->string( $user, $row->getString( 'pluginurls', '' ) );

					if ( $pluginUrls ) {
						$plgUrls		=	explode( "\n", $pluginUrls );

						foreach ( $plgUrls as $plgUrl ) {
							$plgName	=	pathinfo( $plgUrl, PATHINFO_FILENAME );

							$_CB_framework->addJQueryPlugin( $plgName, $plgUrl );

							$plgs[]		=	$plgName;
						}
					}

					$_CB_framework->outputCbJQuery( $code, ( empty( $plgs ) ? null : $plgs ) );
					break;
				case 'CSS':
					$_CB_framework->document->addHeadStyleInline( $code );
					break;
				case 'CSS_URL':
					$_CB_framework->document->addHeadStyleSheet( $url );
					break;
				case 'HEADER':
					$_CB_framework->document->addHeadCustomHtml( $code );
					break;
				case 'METADATA':
					foreach ( $row->subTree( 'metadata' ) as $metaData ) {
						/** @var ParamsInterface $metaData */
						$metaName			=	$this->string( $user, $metaData->getString( 'name', '' ) );

						if ( ! $metaName ) {
							continue;
						}

						$metaContent		=	$this->string( $user, $metaData->getString( 'content', '' ) );

						if ( ! $metaContent ) {
							continue;
						}

						$_CB_framework->document->addHeadMetaData( $metaName, $metaContent );
					}
					break;
				case 'TITLE':
					$_CB_framework->setPageTitle( $code );
					break;
				case 'PATHWAY':
					$_CB_framework->appendPathWay( $code, $url );
					break;
				case 'MESSAGE':
					$messageType		=	$row->getString( 'message_type', 'message' );

					if ( $messageType === 'custom' ) {
						$messageType	=	$this->string( $user, $row->getString( 'message_type_custom', '' ) );
					}

					$_CB_framework->enqueueMessage( $code, ( $messageType ?: null ) );
					break;
				case 'HTML':
				default:
					ob_start();
					$content			=	$code;
					ob_end_clean();
					break;
			}

			if ( ( ! \is_object( $content ) ) && ( ! \is_array( $content ) ) ) {
				if ( ( $content !== '' ) && ( $content !== null ) ) {
					if ( ( $return !== '' ) && ( $return !== null ) ) {
						$return			.=	$content;
					} else {
						$return			=	$content;
					}
				}
			} else {
				$return					=	$content;
			}
		}

		return $return;
	}
}