<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\AutoActions\Action;

use CB\Database\Table\UserTable;
use CBLib\Language\CBTxt;
use CBLib\Registry\ParamsInterface;

\defined( 'CBLIB' ) or die();

class BlogAction extends Action
{

	/**
	 * @param UserTable $user
	 */
	public function execute( UserTable $user ): void
	{
		if ( ! $this->installed() ) {
			$this->error( CBTxt::T( 'AUTO_ACTION_BLOGS_NOT_INSTALLED', ':: Action [action] :: CB Blogs is not installed', [ '[action]' => $this->autoaction()->getId() ] ) );
			return;
		}

		foreach ( $this->autoaction()->getParams()->subTree( 'blog' ) as $row ) {
			/** @var ParamsInterface $row */
			$blog			=	new \cbblogsBlogTable();

			$owner			=	$row->getString( 'owner', '' );

			if ( ! $owner ) {
				$owner		=	$user->getInt( 'id', 0 );
			} else {
				$owner		=	(int) $this->string( $user, $owner );
			}

			if ( ! $owner ) {
				$this->error( CBTxt::T( 'AUTO_ACTION_BLOGS_NO_OWNER', ':: Action [action] :: CB Blogs skipped due to missing owner', [ '[action]' => $this->autoaction()->getId() ] ) );
				continue;
			}

			if ( $user->getInt( 'id', 0 ) !== $owner ) {
				$actionUser	=	\CBuser::getUserDataInstance( $owner );
			} else {
				$actionUser	=	$user;
			}

			$blogData		=	[	'user'			=>	$actionUser->getInt( 'id', 0 ),
									'title'			=>	$this->string( $actionUser, $row->getString( 'title', '' ) ),
									'blog_intro'	=>	$this->string( $actionUser, $row->getRaw( 'intro', '' ), false ),
									'blog_full'		=>	$this->string( $actionUser, $row->getRaw( 'full', '' ), false ),
									'category'		=>	$row->getString( 'category', '' ),
									'published'		=>	$row->getInt( 'published', 1 ),
									'access'		=>	$row->getInt( 'access', 1 )
								];

			if ( ! $blog->bind( $blogData ) ) {
				$this->error( CBTxt::T( 'AUTO_ACTION_BLOGS_BIND_FAILED', ':: Action [action] :: CB Blogs failed to bind. Error: [error]', [ '[action]' => $this->autoaction()->getId(), '[error]' => $blog->getError() ] ) );
				continue;
			}

			if ( ! $blog->store() ) {
				$this->error( CBTxt::T( 'AUTO_ACTION_BLOGS_FAILED', ':: Action [action] :: CB Blogs failed to save. Error: [error]', [ '[action]' => $this->autoaction()->getId(), '[error]' => $blog->getError() ] ) );
			}
		}
	}

	/**
	 * @return array
	 */
	public function categories(): array
	{
		$options		=	[];

		if ( $this->installed() ) {
			$options	=	\cbblogsModel::getCategoriesList();
		}

		return $options;
	}

	/**
	 * @return bool
	 */
	public function installed(): bool
	{
		global $_PLUGINS;

		if ( $_PLUGINS->getLoadedPlugin( 'user', 'cbblogs' ) ) {
			return true;
		}

		return false;
	}
}