<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Plugin\AutoActions\CBAutoActions;
use CB\Plugin\AutoActions\Table\AutoActionTable;
use CBLib\Core\AutoLoader;

\defined( 'CBLIB' ) or die();

global $_CB_database, $_PLUGINS;

AutoLoader::registerExactMap( '%^CB/Plugin/AutoActions/(.+)%i', __DIR__ . '/library/$1.php' );

$_PLUGINS->loadPluginGroup( 'user' );

$_PLUGINS->registerFunction( 'mod_onCBAdminMenu', 'adminMenu', '\CB\Plugin\AutoActions\Trigger\AdminTrigger' );

$plugin										=	$_PLUGINS->getLoadedPlugin( 'user', 'cbautoactions' );

if ( $plugin ) {
	// Catch all exceptions as we don't want badly configuration auto actions breaking at binding:
	try {
		$canEval							=	CBAutoActions::canEval();

		$query								=	'SELECT *'
											.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_plugin_autoactions' )
											.	"\n WHERE " . $_CB_database->NameQuote( 'trigger' ) . " != ''"
											.	"\n AND " . $_CB_database->NameQuote( 'published' ) . " = 1"
											.	"\n ORDER BY " . $_CB_database->NameQuote( 'ordering' ) . " ASC";
		$_CB_database->setQuery( $query );
		$rows								=	$_CB_database->loadObjectList( 'id', '\CB\Plugin\AutoActions\Table\AutoActionTable', [ $_CB_database ] );

		/** @var $rows AutoActionTable[] */
		foreach ( $rows as $row ) {
			$triggers						=	explode( '|*|', $row->getTrigger() );

			foreach ( $triggers as $trigger ) {
				$trigger					=	trim( htmlspecialchars( $trigger ) );

				if ( ( ! $trigger ) || ( strpos( $trigger, 'joomla_' ) !== false ) ) {
					continue;
				}

				$references					=	cbToArrayOfInt( explode( '|*|', $row->getParams()->getString( 'references', '' ) ) );

				if ( $references && $canEval ) {
					// Prepare a list of variables to send to the anonymous function:
					$vars					=	[	1	=>	'$var1 = null',
													2	=>	'$var2 = null',
													3	=>	'$var3 = null',
													4	=>	'$var4 = null',
													5	=>	'$var5 = null',
													6	=>	'$var6 = null',
													7	=>	'$var7 = null',
													8	=>	'$var8 = null',
													9	=>	'$var9 = null',
													10	=>	'$var10 = null',
													11	=>	'$var11 = null',
													12	=>	'$var12 = null',
													13	=>	'$var13 = null',
													14	=>	'$var14 = null',
													15	=>	'$var15 = null'
												];

					// Change variables to references as needed:
					foreach ( $vars as $i => $var ) {
						if ( in_array( $i, $references, true ) ) {
							$vars[$i]		=	'&' . $var;
						}
					}

					$function				=	'$function = function( ' . implode( ', ', $vars ) . ' ) use ( $row, $trigger ) {'
											.		'$variables = [ \'trigger\' => $trigger, \'loop_key\' => null, \'loop\' => null, \'var1\' => &$var1, \'var2\' => &$var2, \'var3\' => &$var3, \'var4\' => &$var4, \'var5\' => &$var5, \'var6\' => &$var6, \'var7\' => &$var7, \'var8\' => &$var8, \'var9\' => &$var9, \'var10\' => &$var10, \'var11\' => &$var11, \'var12\' => &$var12, \'var13\' => &$var13, \'var14\' => &$var14, \'var15\' => &$var15 ];'
											.		'return $row->runAction( $variables );'
											.	'};';

					eval( $function );
				} else {
					$function				=	static function( $var1 = null, $var2 = null, $var3 = null, $var4 = null, $var5 = null, $var6 = null, $var7 = null, $var8 = null, $var9 = null, $var10 = null, $var11 = null, $var12 = null, $var13 = null, $var14 = null, $var15 = null ) use ( $row, $trigger ) {
													$variables		=	[	'trigger'	=>	$trigger,
																			'loop_key'	=>	null,
																			'loop'		=>	null,
																			'var1'		=>	&$var1,
																			'var2'		=>	&$var2,
																			'var3'		=>	&$var3,
																			'var4'		=>	&$var4,
																			'var5'		=>	&$var5,
																			'var6'		=>	&$var6,
																			'var7'		=>	&$var7,
																			'var8'		=>	&$var8,
																			'var9'		=>	&$var9,
																			'var10'		=>	&$var10,
																			'var11'		=>	&$var11,
																			'var12'		=>	&$var12,
																			'var13'		=>	&$var13,
																			'var14'		=>	&$var14,
																			'var15'		=>	&$var15
																		];

													return $row->runAction( $variables );
												};
				}

				$_PLUGINS->registerFunction( $trigger, $function );
			}
		}
	} catch ( Exception $e ) {}
}