<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\GroupJive\Table\CategoryTable;
use CB\Plugin\GroupJive\Table\GroupTable;
use CB\Plugin\GroupJive\CBGroupJive;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_groupjiveGroupEdit
{

	/**
	 * render frontend group edit
	 *
	 * @param GroupTable         $row
	 * @param array              $input
	 * @param CategoryTable      $category
	 * @param UserTable          $user
	 * @param CBplug_cbgroupjive $plugin
	 */
	public static function showGroupEdit( $row, $input, $category, $user, $plugin )
	{
		global $_CB_framework, $_PLUGINS;

		cbValidator::loadValidation();
		initToolTip();

		$js							=	"$( '#canvas_method' ).on( 'change', function() {"
									.		"if ( $( this ).val() == 1 ) {"
									.			"$( '#gjCanvasUpload' ).removeClass( 'hidden' ).find( 'input' ).removeClass( 'cbValidationDisabled' );"
									.		"} else {"
									.			"$( '#gjCanvasUpload' ).addClass( 'hidden' ).find( 'input' ).addClass( 'cbValidationDisabled' ).val( '' );"
									.		"}"
									.	"}).change();"
									.	"$( '#logo_method' ).on( 'change', function() {"
									.		"if ( $( this ).val() == 1 ) {"
									.			"$( '#gjLogoUpload' ).removeClass( 'hidden' ).find( 'input' ).removeClass( 'cbValidationDisabled' );"
									.		"} else {"
									.			"$( '#gjLogoUpload' ).addClass( 'hidden' ).find( 'input' ).addClass( 'cbValidationDisabled' ).val( '' );"
									.		"}"
									.	"}).change();";

		$_CB_framework->outputCbJQuery( $js );

		$isModerator				=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$cssClass					=	$row->getString( 'css' );
		$returnUrl					=	CBGroupJive::getReturn( true, true );
		$return						=	null;

		$integrations				=	$_PLUGINS->trigger( 'gj_onBeforeDisplayGroupEdit', array( &$return, &$row, &$input, $category, $user ) );

		if ( $row->getInt( 'id', 0 ) ) {
			$pageTitle				=	CBTxt::T( 'Edit Group' );

			if ( ! $returnUrl ) {
				$returnUrl			=	$_CB_framework->pluginClassUrl( $plugin->element, false, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->getInt( 'id', 0 ) ) );
			}
		} else {
			$pageTitle				=	CBTxt::T( 'New Group' );

			if ( ! $returnUrl ) {
				$returnUrl			=	$_CB_framework->pluginClassUrl( $plugin->element, false, array( 'action' => 'categories', 'func' => 'show', 'id' => $category->getInt( 'id', 0 ) ) );
			}
		}

		$_CB_framework->setPageTitle( $pageTitle );

		$return						.=	'<div class="gjGroupEdit gjGroupEdit' . $row->getInt( 'id', 0 ) . ( $cssClass ? ' ' . htmlspecialchars( $cssClass ) : null ) . '">'
									.		'<form action="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'save', 'id' => $row->getInt( 'id', 0 ), 'return' => CBGroupJive::getReturn( true ) ) ) . '" method="post" enctype="multipart/form-data" name="gjGroupEditForm" id="gjGroupEditForm" class="form-auto m-0 cb_form gjGroupEditForm cbValidation">'
									.			( $pageTitle ? '<div class="mb-3 border-bottom cb-page-header gjGroupEditTitle"><h3 class="m-0 p-0 mb-2 cb-page-header-title">' . $pageTitle . '</h3></div>' : null )
									.			$input['group_hidden']
									.			$input['type_hidden'];

		if ( $isModerator || ( ! $plugin->params->getInt( 'groups_create_approval', 0 ) ) || ( $row->getInt( 'id', 0 ) && ( $row->getInt( 'published', 0 ) !== -1 ) ) ) {
			$return					.=			'<div class="cbft_select cbtt_select form-group row no-gutters cb_form_line">'
									.				'<label for="published" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Published' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['published']
									.					getFieldIcons( null, 0, null, CBTxt::T( 'Select publish state of this group. Unpublished groups will not be visible to the public.' ) )
									.				'</div>'
									.			'</div>';
		}

		if ( $input['category'] ) {
			$return					.=			'<div class="cbft_select cbtt_select form-group row no-gutters cb_form_line">'
									.				'<label for="category" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Category' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['category']
									.					getFieldIcons( null, 0, null, CBTxt::T( 'Select the group category. This is the category a group will belong to and decide its navigation path.' ) )
									.				'</div>'
									.			'</div>';
		}

		if ( $input['type'] ) {
			$return					.=			'<div class="cbft_select cbtt_select form-group row no-gutters cb_form_line">'
									.				'<label for="type" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Type' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['type']
									.					getFieldIcons( null, 0, null, $input['type_desc'] )
									.				'</div>'
									.			'</div>';
		}

		$return						.=			'<div class="cbft_text cbtt_input form-group row no-gutters cb_form_line">'
									.				'<label for="name" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Name' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['name']
									.					getFieldIcons( null, 1, null, CBTxt::T( 'Input the group name. This is the name that will distinguish this group from others. Suggested to input something unique and intuitive.' ) )
									.				'</div>'
									.			'</div>'
									.			'<div class="cbft_textarea cbtt_textarea form-group row no-gutters cb_form_line">'
									.				'<label for="description" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Description' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['description']
									.					getFieldIcons( null, 0, null, CBTxt::T( 'Optionally input the group description. The group description should be short and to the point; describing what your group is all about.' ) )
									.				'</div>'
									.			'</div>';

		if ( $row->getString( 'canvas' ) ) {
			$return					.=			'<div class="cbft_delimiter form-group row no-gutters cb_form_line">'
									.				'<label for="canvas_method" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Canvas' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$row->canvas()
									.				'</div>'
									.			'</div>'
									.			'<div id="gjCanvasMethod" class="cbft_select cbtt_select form-group row no-gutters cb_form_line">'
									.				'<div class="cb_field offset-sm-3 col-sm-9">'
									.					$input['canvas_method']
									.				'</div>'
									.			'</div>';
		}

		$return						.=			'<div id="gjCanvasUpload" class="cbft_file cbtt_input form-group row no-gutters cb_form_line' . ( $row->getString( 'canvas' ) ? ' hidden' : null ) . '">'
									.				( ! $row->getString( 'canvas' ) ? '<label for="canvas" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Canvas' ) . '</label>' : null )
									.				'<div class="cb_field' . ( $row->getString( 'canvas' ) ? ' offset-sm-3' : null ) . ' col-sm-9">'
									.					$input['canvas']
									.					getFieldIcons( null, 0, null, CBTxt::T( 'Optionally select the group canvas. A canvas should represent the topic of your group; please be respectful and tasteful when selecting a canvas.' ) )
									.					'<div class="form-text">' . implode( ' ', $input['canvas_limits'] ) . '</div>'
									.				'</div>'
									.			'</div>';

		if ( $row->getString( 'logo' ) ) {
			$return					.=			'<div class="cbft_delimiter form-group row no-gutters cb_form_line">'
									.				'<label for="logo_method" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Logo' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$row->logo()
									.				'</div>'
									.			'</div>'
									.			'<div id="gjLogoMethod" class="cbft_select cbtt_select form-group row no-gutters cb_form_line">'
									.				'<div class="cb_field offset-sm-3 col-sm-9">'
									.					$input['logo_method']
									.				'</div>'
									.			'</div>';
		}

		$return						.=			'<div id="gjLogoUpload" class="cbft_file cbtt_input form-group row no-gutters cb_form_line' . ( $row->getString( 'logo' ) ? ' hidden' : null ) . '">'
									.				( ! $row->getString( 'logo' ) ? '<label for="logo" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Logo' ) . '</label>' : null )
									.				'<div class="cb_field' . ( $row->getString( 'logo' ) ? ' offset-sm-3' : null ) . ' col-sm-9">'
									.					$input['logo']
									.					getFieldIcons( null, 0, null, CBTxt::T( 'Optionally select the group logo. A logo should represent the topic of your group; please be respectful and tasteful when selecting a logo.' ) )
									.					'<div class="form-text">' . implode( ' ', $input['logo_limits'] ) . '</div>'
									.				'</div>'
									.			'</div>';

		if ( $row->getInt( 'type', 0 ) !== 4 ) {
			$return					.=			'<div class="cbft_select cbtt_select form-group row no-gutters cb_form_line">'
									.				'<label for="params__users" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Users' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['users']
									.					getFieldIcons( null, 0, null, CBTxt::T( 'Optionally enable or disable display of group users. Group owner and group administrators are exempt from this configuration and can always view group users.' ) )
									.				'</div>'
									.			'</div>';
		}

		if ( ( ! in_array( $row->getInt( 'type', 0 ), array( 3, 4 ), true ) ) && ( $isModerator || $plugin->params->getInt( 'groups_invites_display', 1 ) ) ) {
			$return					.=			'<div class="cbft_select cbtt_select form-group row no-gutters cb_form_line">'
									.				'<label for="params__invites" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Invites' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['invites']
									.					getFieldIcons( null, 0, null, CBTxt::T( 'Optionally enable or disable usage of group invites. Group invites allow group users to invite other users to join the group. Group owner and group administrators are exempt from this configuration and can always invite users. Note existing invites will still be accessible.' ) )
									.				'</div>'
									.			'</div>';
		}

		if ( is_array( $integrations ) && $integrations ) {
			$return					.=			implode( '', $integrations );
		}

		if ( $isModerator ) {
			$return					.=			'<div class="cbft_text cbtt_input form-group row no-gutters cb_form_line">'
									.				'<label for="user_id" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Owner' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['user_id']
									.					getFieldIcons( null, 1, null, CBTxt::T( 'Input the group owner id. Group owner determines the creator of the group specified as User ID.' ) )
									.				'</div>'
									.			'</div>';
		}

		if ( ( ! $isModerator ) && $plugin->params->getInt( 'groups_create_captcha', 0 ) ) {
			$_PLUGINS->loadPluginGroup( 'user' );

			$captcha				=	$_PLUGINS->trigger( 'onGetCaptchaHtmlElements', array( false ) );

			if ( ! empty( $captcha ) ) {
				$captcha			=	$captcha[0];

				$return				.=			'<div class="cbft_delimiter form-group row no-gutters cb_form_line">'
									.				'<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Captcha' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					( isset( $captcha[0] ) ? $captcha[0] : null )
									.				'</div>'
									.			'</div>'
									.			'<div class="cbft_text cbtt_input form-group row no-gutters cb_form_line">'
									.				'<div class="cb_field offset-sm-3 col-sm-9">'
									.					str_replace( 'inputbox', 'form-control', ( isset( $captcha[1] ) ? $captcha[1] : null ) )
									.					getFieldIcons( null, 1, null )
									.				'</div>'
									.			'</div>';
			}
		}

		$return						.=			'<div class="row no-gutters">'
									.				'<div class="offset-sm-3 col-sm-9">'
									.					'<input type="submit" value="' . htmlspecialchars( ( $row->getInt( 'id', 0 ) ? CBTxt::T( 'Update Group' ) : CBTxt::T( 'Create Group' ) ) ) . '" class="btn btn-primary btn-sm-block gjButton gjButtonSubmit" ' . cbValidator::getSubmitBtnHtmlAttributes() . ' />'
									.					' <input type="button" value="' . htmlspecialchars( CBTxt::T( 'Cancel' ) ) . '" class="btn btn-secondary btn-sm-block gjButton gjButtonCancel" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to cancel? All unsaved data will be lost!' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( htmlspecialchars( $returnUrl ) ) . '\'; })" />'
									.				'</div>'
									.			'</div>'
									.			cbGetSpoofInputTag( 'plugin' )
									.		'</form>'
									.	'</div>';

		$_CB_framework->setMenuMeta();

		$_PLUGINS->trigger( 'gj_onAfterDisplayGroupEdit', array( &$return, $row, $input, $category, $user ) );

		echo $return;
	}
}