<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Application\Application;
use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\GroupJive\Table\GroupTable;
use CB\Plugin\GroupJive\CBGroupJive;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_groupjiveGroup
{

	/**
	 * render frontend group
	 *
	 * @param GroupTable         $row
	 * @param mixed              $users
	 * @param mixed              $invites
	 * @param UserTable          $user
	 * @param CBplug_cbgroupjive $plugin
	 */
	public static function showGroup( $row, $users, $invites, $user, $plugin )
	{
		global $_CB_framework, $_PLUGINS;

		$_CB_framework->setPageTitle( CBTxt::T( $row->getString( 'name' ) ) );

		initToolTip();

		$isModerator					=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$isOwner						=	( $user->getInt( 'id', 0 ) === $row->getInt( 'user_id', 0 ) );
		$userStatus						=	CBGroupJive::getGroupStatus( $user, $row );
		$cssClass						=	$row->getString( 'css' );
		$counters						=	array();
		$buttons						=	array();
		$menu							=	array();
		$tabs							=	new cbTabs( 1, 1 );
		$return							=	null;

		$integrations					=	$_PLUGINS->trigger( 'gj_onBeforeDisplayGroup', array( &$return, &$row, &$users, &$invites, &$counters, &$buttons, &$menu, &$tabs, $user ) );

		if ( $isModerator && ( $row->getInt( 'published', 0 ) === -1 ) && $plugin->params->getInt( 'groups_create_approval', 0 ) ) {
			$buttons[]					=	'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="gjButton gjButtonApprove btn btn-sm btn-sm-block btn-success">' . CBTxt::T( 'Approve Group' ) . '</a>';
		} elseif ( ( ! $isOwner ) && ( $row->getInt( 'type', 0 ) !== 4 ) ) {
			if ( $userStatus === null ) {
				if ( $row->getInt( '_invite_id', 0 ) ) {
					$buttons[]			=	'<button type="button" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to reject all invites to this Group?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'reject', 'id' => $row->getInt( 'id', 0 ) ) ) ) . '\'; })" class="gjButton gjButtonReject btn btn-sm btn-sm-block btn-light border">' . CBTxt::T( 'Reject Group Invite' ) . '</button>';
				}

				if ( ( $row->getInt( 'type', 0 ) !== 5 ) || $row->getInt( '_invite_id', 0 ) ) {
					$buttons[]			=	'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'join', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="gjButton gjButtonJoin btn btn-sm btn-sm-block btn-success">' . ( $row->getInt( '_invite_id', 0 ) ? CBTxt::T( 'Accept Group Invite' ) : CBTxt::T( 'Join Group' ) ) . '</a>';
				}
			} elseif ( $userStatus === 0 ) {
				$buttons[]				=	'<button type="button" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to cancel your pending join request to this Group?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'cancel', 'id' => $row->getInt( 'id', 0 ) ) ) ) . '\'; })" class="gjButton gjButtonCancel btn btn-sm btn-sm-block btn-light border">' . CBTxt::T( 'Cancel Group Join Request' ) . '</button>';
			}
		}

		$groupTabs						=	null;

		foreach ( $integrations as $integration ) {
			if ( ( ! $integration ) || ( ! isset( $integration['id'] ) ) || ( ! isset( $integration['title'] ) ) || ( ! isset( $integration['content'] ) ) ) {
				continue;
			}

			$groupTabs					.=	$tabs->startTab( null, $integration['title'], 'grouptab' . $integration['id'], array( 'tab' => 'cbNavBarItem', 'pane' => 'tab-pane cbTabPaneMenu', 'link' => 'cbNavBarLink', 'override' => true ) )
										.		'<div class="cb_tab_content cb_tab_menu" id="cb_tabid_grouptab' . $integration['id'] . '">'
										.			$integration['content']
										.		'</div>'
										.	$tabs->endTab();
		}

		if ( $users ) {
			$groupTabs					.=	$tabs->startTab( null, CBTxt::T( 'GROUP_USERS', 'Users' ), 'grouptabusers', array( 'tab' => 'cbNavBarItem', 'pane' => 'tab-pane cbTabPaneMenu', 'link' => 'cbNavBarLink', 'override' => true ) )
										.		'<div class="cb_tab_content cb_tab_menu" id="cb_tabid_grouptabusers">'
										.			$users
										.		'</div>'
										.	$tabs->endTab();
		}

		if ( $invites ) {
			$groupTabs					.=	$tabs->startTab( null, CBTxt::T( 'Invites' ), 'grouptabinvites', array( 'tab' => 'cbNavBarItem', 'pane' => 'tab-pane cbTabPaneMenu', 'link' => 'cbNavBarLink', 'override' => true ) )
										.		'<div class="cb_tab_content cb_tab_menu" id="cb_tabid_grouptabinvites">'
										.			$invites
										.		'</div>'
										.	$tabs->endTab();
		}

		$return							.=	'<div class="gjGroup gjGroup' . $row->getInt( 'id', 0 ) . ( $cssClass ? ' ' . htmlspecialchars( $cssClass ) : null ) . '">';

		if ( ( $isModerator || $isOwner ) && ( ( $row->getInt( 'published', 0 ) === -1 ) && $plugin->params->getInt( 'groups_create_approval', 0 ) ) ) {
			$return						.=		'<div class="gjGroupPending alert alert-info">' . CBTxt::T( 'This group is awaiting approval.' ) . '</div>';
		}

		$return							.=		'<div class="position-relative no-overflow border' . ( $groupTabs ? ' border-bottom-0' : null ) . ' cbCanvasLayout">'
										.			'<div class="position-relative bg-light cbCanvasLayoutTop">'
										.				'<div class="position-absolute cbCanvasLayoutBackground">'
										.					$row->canvas()
										.				'</div>'
										.			'</div>'
										.			'<div class="position-relative row no-gutters bg-white border-top cbCanvasLayoutBottom">'
										.				'<div class="col-4 col-sm-3">'
										.					'<div class="position-absolute cbPosCanvasPhoto cbCanvasLayoutPhoto">'
										.						$row->logo()
										.					'</div>'
										.				'</div>'
										.				'<div class="col-8 col-sm-9">'
										.					'<div class="p-2">'
										.						'<div class="row no-gutters">'
										.							'<div class="order-0 col cbCanvasLayoutTitle">'
										.								'<strong class="text-primary text-large">' . htmlspecialchars( CBTxt::T( $row->getString( 'name' ) ) ) . '</strong>'
										.							'</div>';

		if ( $buttons ) {
			$return						.=							'<div class="ml-0 ml-sm-1 mt-2 mt-sm-0 order-last order-sm-1 col-12 col-sm-auto cbCanvasLayoutButtons">'
										.								implode( ' ', $buttons )
										.							'</div>';
		}

		if ( $isModerator || $isOwner || $menu || ( $userStatus >= 1 ) ) {
			$menuItems					=	'<ul class="list-unstyled dropdown-menu d-block position-relative m-0 gjMenuItems gjGroupMenuItems">';

			if ( $isModerator || $isOwner ) {
				$menuItems				.=		'<li class="gjMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'edit', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="dropdown-item"><span class="fa fa-edit"></span> ' . CBTxt::T( 'Edit' ) . '</a></li>';

				if ( ( $row->getInt( 'published', 0 ) === -1 ) && $plugin->params->getInt( 'groups_create_approval', 0 ) ) {
					if ( $isModerator ) {
						$menuItems		.=		'<li class="gjMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="dropdown-item"><span class="fa fa-check"></span> ' . CBTxt::T( 'Approve' ) . '</a></li>';
					}
				} elseif ( $row->getInt( 'published', 0 ) === 1 ) {
					$menuItems			.=		'<li class="gjMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to unpublish this Group?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'unpublish', 'id' => $row->getInt( 'id', 0 ) ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-times-circle"></span> ' . CBTxt::T( 'Unpublish' ) . '</a></li>';
				} else {
					$menuItems			.=		'<li class="gjMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="dropdown-item"><span class="fa fa-check"></span> ' . CBTxt::T( 'Publish' ) . '</a></li>';
				}
			}

			if ( $plugin->params->getInt( 'notifications', 1 )
				 && ( $row->getInt( 'type', 0 ) !== 4 )
				 && ( $isModerator || ( ( $row->getInt( 'published', 0 ) === 1 ) && ( $isOwner || ( $userStatus >= 1 ) ) ) )
			) {
				$menuItems				.=		'<li class="gjMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'notifications', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="dropdown-item"><span class="fa fa-envelope"></span> ' . CBTxt::T( 'Notifications' ) . '</a></li>';
			}

			if ( ( $row->getInt( 'type', 0 ) !== 4 ) && ( $isModerator || ( ( $row->getInt( 'published', 0 ) === 1 ) && $plugin->params->getInt( 'groups_message', 0 ) && ( $isOwner || ( $userStatus >= 3 ) ) ) ) ) {
				$delay					=	false;

				if ( ( ! $isModerator ) && $plugin->params->getInt( 'groups_message_delay', 60 ) && $row->params()->getString( 'messaged' ) ) {
					$seconds			=	$plugin->params->getInt( 'groups_message_delay', 60 );

					if ( $seconds && ( Application::Date( $row->params()->getString( 'messaged' ), 'UTC' )->add( $seconds . ' SECONDS' )->getTimestamp() >= Application::Date( 'now', 'UTC' )->getTimestamp() ) ) {
						$delay			=	true;
					}
				}

				if ( ! $delay ) {
					$menuItems			.=		'<li class="gjMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'message', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="dropdown-item"><span class="fa fa-comment"></span> ' . CBTxt::T( 'Message' ) . '</a></li>';
				}
			}

			if ( ( ! $isOwner ) && ( $userStatus >= 1 ) ) {
				$menuItems				.=		'<li class="gjMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to leave this Group?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'leave', 'id' => $row->getInt( 'id', 0 ) ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-minus-circle"></span> ' . CBTxt::T( 'Leave' ) . '</a></li>';
			}

			if ( $menu ) {
				$menuItems				.=		'<li class="gjMenuItem">' . implode( '</li><li class="gjMenuItem">', $menu ) . '</li>';
			}

			if ( $isModerator || $isOwner ) {
				$menuItems				.=		'<li class="gjMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to delete this Group?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'delete', 'id' => $row->getInt( 'id', 0 ) ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-trash-o"></span> ' . CBTxt::T( 'Delete' ) . '</a></li>';
			}

			$menuItems					.=	'</ul>';

			$menuAttr					=	cbTooltip( null, $menuItems, null, 'auto', null, null, null, 'class="border btn btn-light btn-sm cbCanvasLayoutMenu gjGroupMenu" data-cbtooltip-menu="true" data-cbtooltip-classes="qtip-nostyle" data-cbtooltip-open-classes="active"' );

			$return						.=							'<div class="ml-1 order-2 col-auto text-right cbCanvasLayoutActions">'
										.								'<button type="button" ' . trim( $menuAttr ) . '><span class="pl-2 pr-2 align-bottom text-large fa fa-ellipsis-v"></span></button>'
										.							'</div>';
		}

		$return							.=						'</div>'
										.						'<div class="mt-2 mt-sm-1 text-muted text-overflow text-small cbCanvasLayoutCounters">';

		if ( $row->getInt( 'category', 0 ) ) {
			$return						.=							'<span class="cbCanvasLayoutCounter gjGroupIconCategory"><span class="fa-before fa-folder">'
										.								' <a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'categories', 'func' => 'show', 'id' => $row->getInt( 'category', 0 ) ) ) . '">' . CBTxt::T( $row->category()->getString( 'name' ) ) . '</a>'
										.							'</span></span>';
		}

		$return							.=							'<span class="cbCanvasLayoutCounter gjGroupIconType"><span class="fa-before fa-globe"> ' . $row->type() . '</span></span>';

		if ( $users ) {
			$return						.=							'<span class="cbCanvasLayoutCounter gjGroupIconUsers"><span class="fa-before fa-user"> ' . CBTxt::T( 'GROUP_USERS_COUNT', '%%COUNT%% User|%%COUNT%% Users', array( '%%COUNT%%' => $row->getInt( '_users', 0 ) ) ) . '</span></span>';
		}

		$return							.=							( $counters ? '<span class="cbCanvasLayoutCounter">' . implode( '</span> <span class="cbCanvasLayoutCounter">', $counters ) . '</span>' : null )
										.						'</div>'
										.					'</div>'
										.				'</div>';

		if ( $row->getString( 'description' ) ) {
			$return						.=				'<div class="gjCanvasDescription gjGroupDescription">'
										.					cbTooltip( null, $row->getString( 'description' ), null, null, null, '<span class="bg-white border rounded-circle p-1 pl-2 pr-2 text-small fa fa-info text-muted"></span>' )
										.				'</div>';
		}

		$return							.=			'</div>'
										.		'</div>';

		if ( $groupTabs ) {
			$return						.=		'<div class="cbCanvasLayoutMain">'
										.			'<div class="cbTabs cbTabsMenu" id="cbtabsgrouptab" data-cbtabs-use-cookies="true">'
										.				'<div class="navbar navbar-expand navbar-light bg-light mb-3 border cbNavBar cbTabsMenuNavBar" role="navigation">'
										.					'<input type="checkbox" id="cbtabsgrouptaboverflow" aria-hidden="true" tabindex="-1" class="d-none cbNavBarOverflowToggle" />'
										.					'<div class="navbar-collapse cbNavBarContainer" id="cbtabsgrouptabMenu">'
										.						'<ul class="navbar-nav flex-wrap flex-grow-1 m-0 cbNavBarMenu cbTabsNav">'
										.							'<li class="position-absolute nav-item cbNavBarItem cbNavBarOverflow">'
										.								'<label for="cbtabsgrouptaboverflow" aria-hidden="true" class="m-0 nav-link cbNavBarLink">'
										.									'<span class="fa fa-bars cbNavBarOverflowMoreIcon"></span>'
										.									'<span class="fa fa-times cbNavBarOverflowCloseIcon"></span>'
										.									' ' . CBTxt::T( 'CBNAV_MORE', 'More' )
										.								'</label>'
										.							'</li>'
										.						'</ul>'
										.					'</div>'
										.				'</div>'
										.				'<div class="tab-content cbTabsContent cbTabsMenuContent">' . $groupTabs . '</div>'
										.			'</div>'
										.		'</div>';
		}

		$return							.=	'</div>';

		$_CB_framework->setMenuMeta();

		$_PLUGINS->trigger( 'gj_onAfterDisplayGroup', array( &$return, $row, $users, $invites, $user ) );

		echo $return;
	}
}