<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\GroupJive\Table\CategoryTable;
use CB\Plugin\GroupJive\Table\GroupTable;
use CB\Plugin\GroupJive\CBGroupJive;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_groupjiveCategory
{

	/**
	 * render frontend category
	 *
	 * @param CategoryTable      $category
	 * @param GroupTable[]       $rows
	 * @param cbPageNav          $pageNav
	 * @param bool               $searching
	 * @param array              $input
	 * @param UserTable          $user
	 * @param CBplug_cbgroupjive $plugin
	 */
	public static function showCategory( $category, $rows, $pageNav, $searching, $input, $user, $plugin )
	{
		global $_CB_framework, $_PLUGINS;

		$pageTitle							=	( $category->getInt( 'id', 0 ) ? CBTxt::T( $category->getString( 'name' ) ) : CBTxt::T( 'Uncategorized' ) );

		$_CB_framework->setPageTitle( $pageTitle );

		initToolTip();

		$isModerator						=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$canCreateGroup						=	CBGroupJive::canCreateGroup( $user, $category );
		$cssClass							=	$category->getString( 'css' );
		$canSearch							=	( $plugin->params->getInt( 'categories_groups_search', 1 ) && ( $searching || $pageNav->total ) );
		$counters							=	array();
		$return								=	null;

		$_PLUGINS->trigger( 'gj_onBeforeDisplayCategory', array( &$return, &$rows, &$category, &$counters, $user ) );

		$return								.=	'<div class="gjCategory gjCategory' . $category->getInt( 'id', 0 ) . ( $cssClass ? ' ' . htmlspecialchars( $cssClass ) : null ) . '">'
											.		'<div class="position-relative no-overflow border cbCanvasLayout">'
											.			'<div class="position-relative bg-light row no-gutters cbCanvasLayoutTop">'
											.				'<div class="position-absolute col-12 cbCanvasLayoutBackground">'
											.					$category->canvas()
											.				'</div>'
											.			'</div>'
											.			'<div class="position-relative row no-gutters bg-white border-top cbCanvasLayoutBottom">'
											.				'<div class="col-4 col-sm-3">'
											.					'<div class="position-absolute cbPosCanvasPhoto cbCanvasLayoutPhoto">'
											.						$category->logo()
											.					'</div>'
											.				'</div>'
											.				'<div class="col-8 col-sm-9">'
											.					'<div class="p-2">'
											.						'<div class="cbCanvasLayoutTitle">'
											.							'<strong class="text-primary text-large">' . $pageTitle . '</strong>'
											.						'</div>'
											.						'<div class="mt-2 mt-sm-1 text-muted text-overflow text-small cbCanvasLayoutCounters">'
											.							'<span class="cbCanvasLayoutCounter"><span class="gjCategoryGroupsIcon fa-before fa-users"> ' . CBTxt::T( 'GROUPS_COUNT', '%%COUNT%% Group|%%COUNT%% Groups', array( '%%COUNT%%' => (int) $pageNav->total ) ) . '</span></span>'
											.							( $counters ? '<span class="cbCanvasLayoutCounter">' . implode( '</span><span class="cbCanvasLayoutCounter">', $counters ) . '</span>' : null )
											.						'</div>'
											.					'</div>'
											.				'</div>';

		if ( $category->getString( 'description' ) ) {
			$return							.=				'<div class="gjCanvasDescription gjCategoryDescription">'
											.					cbTooltip( null, $category->getString( 'description' ), null, null, null, '<span class="bg-white border rounded-circle p-1 pl-2 pr-2 text-small fa fa-info text-muted"></span>' )
											.				'</div>';
		}

		$return								.=			'</div>'
											.		'</div>'
											.		'<div class="mt-3 cbCanvasLayoutMain">';

		if ( $canCreateGroup || $canSearch ) {
			$return							.=			'<div class="row no-gutters mb-3 gjHeader gjCategoryHeader">';

			if ( $canCreateGroup ) {
				$return						.=				'<div class="col-12 ' . ( $canSearch ? 'col-sm-6 mb-2 mb-sm-0' : null ) . '">'
											.					'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'new', 'category' => $category->getInt( 'id', 0 ), 'return' => CBGroupJive::getReturn() ) ) . '" class="btn btn-success btn-sm-block gjButton gjButtonNewGroup"><span class="fa fa-plus-circle"></span> ' . CBTxt::T( 'Create New Group' ) . '</a>'
											.				'</div>';
			}

			if ( $canSearch ) {
				$return						.=				'<div class="col-12 ' . ( ! $canCreateGroup ? 'offset-sm-6 ' : null ) . 'col-sm-6 text-sm-right">'
											.					'<form action="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'categories', 'func' => 'show', 'id' => $category->getInt( 'id', 0 ) ) ) . '" method="post" name="gjCategorySearchForm" class="m-0 gjCategorySearchForm">'
											.						'<div class="input-group">'
											.							$input['search']
											.							'<div class="input-group-append">'
											.								'<button type="submit" class="btn btn-light border" aria-label="' . htmlspecialchars( CBTxt::T( 'Search' ) ) . '"><span class="fa fa-search"></span></button>'
											.							'</div>'
											.						'</div>'
											.					'</form>'
											.				'</div>';
			}

			$return							.=			'</div>';
		}

		if ( $rows ) {
			$return							.=			'<div class="ml-n2 mr-n2 mb-n3 row no-gutters gjCategoryRows">';

			foreach ( $rows as $row ) {
				$rowOwner					=	( $user->getInt( 'id', 0 ) === $row->getInt( 'user_id', 0 ) );
				$userStatus					=	CBGroupJive::getGroupStatus( $user, $row );
				$cssClass					=	$row->getString( 'css' );

				$counters					=	array();
				$content					=	null;
				$menu						=	array();

				$_PLUGINS->trigger( 'gj_onDisplayGroup', array( &$row, &$counters, &$content, &$menu, 'category', $user ) );

				$buttons					=	array();

				if ( $isModerator && ( $row->getInt( 'published', 0 ) === -1 ) && $plugin->params->getInt( 'groups_create_approval', 0 ) ) {
					$buttons[]			=	'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ), 'return' => CBGroupJive::getReturn() ) ) . '" class="btn btn-block btn-sm btn-success gjButton gjButtonApprove">' . CBTxt::T( 'Approve Group' ) . '</a>';
				} elseif ( ( ! $rowOwner ) && ( $row->getInt( 'type', 0 ) !== 4 ) ) {
					if ( $userStatus === null ) {
						if ( ( $row->getInt( 'type', 0 ) !== 5 ) || $row->getInt( '_invite_id', 0 ) ) {
							$buttons[]	=	'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'join', 'id' => $row->getInt( 'id', 0 ), 'return' => CBGroupJive::getReturn() ) ) . '" class="btn btn-block btn-sm btn-secondary gjButton gjButtonJoin">' . ( $row->getInt( '_invite_id', 0 ) ? CBTxt::T( 'Accept Group Invite' ) : CBTxt::T( 'Join Group' ) ) . '</a>';
						}

						if ( $row->getInt( '_invite_id', 0 ) ) {
							$buttons[]	=	'<button type="button" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to reject all invites to this Group?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'reject', 'id' => $row->getInt( 'id', 0 ), 'return' => CBGroupJive::getReturn() ) ) ) . '\'; })" class="btn btn-block btn-sm btn-light border gjButton gjButtonReject">' . CBTxt::T( 'Reject Group Invite' ) . '</button>';
						}
					} elseif ( $userStatus === 0 ) {
						$buttons[]		=	'<button type="button" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to cancel your pending join request to this Group?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'cancel', 'id' => $row->getInt( 'id', 0 ), 'return' => CBGroupJive::getReturn() ) ) ) . '\'; })" class="btn btn-block btn-sm btn-light border gjButton gjButtonCancel">' . CBTxt::T( 'Cancel Group Join Request' ) . '</button>';
					}
				}

				$menuButton					=	null;

				if ( $isModerator || $rowOwner || $menu ) {
					$menuItems				=	'<ul class="list-unstyled dropdown-menu d-block position-relative m-0 gjMenuItems gjCategoryGroupMenuItems">';

					if ( $isModerator || $rowOwner ) {
						$menuItems			.=		'<li class="gjMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'edit', 'id' => $row->getInt( 'id', 0 ), 'return' => CBGroupJive::getReturn() ) ) . '" class="dropdown-item"><span class="fa fa-edit"></span> ' . CBTxt::T( 'Edit' ) . '</a></li>';

						if ( ( $row->getInt( 'published', 0 ) === -1 ) && $plugin->params->getInt( 'groups_create_approval', 0 ) ) {
							if ( $isModerator ) {
								$menuItems	.=		'<li class="gjMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ), 'return' => CBGroupJive::getReturn() ) ) . '" class="dropdown-item"><span class="fa fa-check"></span> ' . CBTxt::T( 'Approve' ) . '</a></li>';
							}
						} elseif ( $row->getInt( 'published', 0 ) === 1 ) {
							$menuItems		.=		'<li class="gjMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to unpublish this Group?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'unpublish', 'id' => $row->getInt( 'id', 0 ), 'return' => CBGroupJive::getReturn() ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-times-circle"></span> ' . CBTxt::T( 'Unpublish' ) . '</a></li>';
						} else {
							$menuItems		.=		'<li class="gjMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ), 'return' => CBGroupJive::getReturn() ) ) . '" class="dropdown-item"><span class="fa fa-check"></span> ' . CBTxt::T( 'Publish' ) . '</a></li>';
						}
					}

					if ( $menu ) {
						$menuItems			.=		'<li class="gjMenuItem">' . implode( '</li><li class="gjMenuItem">', $menu ) . '</li>';
					}

					if ( $isModerator || $rowOwner ) {
						$menuItems			.=		'<li class="gjMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to delete this Group?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'delete', 'id' => $row->getInt( 'id', 0 ), 'return' => CBGroupJive::getReturn() ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-trash-o"></span> ' . CBTxt::T( 'Delete' ) . '</a></li>';
					}

					$menuItems				.=	'</ul>';

					$menuAttr				=	cbTooltip( null, $menuItems, null, 'auto', null, null, null, 'class="border btn btn-light btn-sm cbCanvasLayoutMenu gjCategoryGroupMenu" data-cbtooltip-menu="true" data-cbtooltip-classes="qtip-nostyle" data-cbtooltip-open-classes="active"' );

					$menuButton				=	'<button type="button" ' . trim( $menuAttr ) . '><span class="pl-2 pr-2 align-bottom text-large fa fa-ellipsis-v"></span></button>';
				}

				$return						.=				'<div class="col-12 col-md-6 col-lg-4 pb-3 pl-2 pr-2 gjCategoryGroup gjCategoryGroup' . $row->getInt( 'id', 0 ) . ( $cssClass ? ' ' . htmlspecialchars( $cssClass ) : null ) . '">'
											.					'<div class="h-100 card no-overflow cbCanvasLayout cbCanvasLayoutMd">'
											.						'<div class="card-header p-0 position-relative cbCanvasLayoutTop">'
											.							'<div class="position-absolute cbCanvasLayoutBackground">'
											.								$row->canvas( true, true, true )
											.							'</div>';

				if ( $menuButton ) {
					$return					.=							'<div class="position-absolute text-right p-1 cbCanvasLayoutActions">'
											.								$menuButton
											.							'</div>';
				}

				$return						.=						'</div>'
											.						'<div class="position-relative cbCanvasLayoutBottom">'
											.							'<div class="position-absolute cbCanvasLayoutPhoto">'
											.								$row->logo( true, true, true )
											.							'</div>'
											.						'</div>'
											.						'<div class="d-flex flex-column card-body p-0 position-relative cbCanvasLayoutBody">'
											.							'<div class="flex-grow-1 ml-2 mr-2 mt-2 text-truncate cbCanvasLayoutContent">';

				if ( ( $isModerator || $rowOwner ) && ( ( $row->getInt( 'published', 0 ) === -1 ) && $plugin->params->getInt( 'groups_create_approval', 0 ) ) ) {
					$return					.=								'<span class="fa fa-clock-o text-warning gjCategoryGroupIconPending" title="' . htmlspecialchars( CBTxt::T( 'Awaiting Approval' ) ) . '"></span> ';
				}

				$return						.=								'<strong><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="text-large">' . htmlspecialchars( CBTxt::T( $row->getString( 'name' ) ) ) . '</a></strong>'
											.							'</div>'
											.							'<div class="border-top pl-2 pr-2 pt-2 mt-2 mb-2 text-small text-muted row no-gutters cbCanvasLayoutContent">'
											.								'<div class="mw-100 col-md-6 flex-grow-1 text-truncate cbCanvasLayoutContent gjCategoryGroupIconType"><span class="fa-before fa-globe"> ' . $row->type() . '</span></div>'
											.								( $row->getInt( 'type', 0 ) !== 4 ? '<div class="mw-100 col-md-6 flex-grow-1 text-truncate cbCanvasLayoutContent gjCategoryGroupIconUsers"><span class="fa-before fa-user"> ' . CBTxt::T( 'GROUP_USERS_COUNT', '%%COUNT%% User|%%COUNT%% Users', array( '%%COUNT%%' => $row->getInt( '_users', 0 ) ) ) . '</span></div>' : null )
											.								( $counters ? '<div class="mw-100 col-md-6 flex-grow-1 text-truncate cbCanvasLayoutContent">' . implode( '</div><div class="mw-100 col-md-6 flex-grow-1 text-truncate cbCanvasLayoutContent">', $counters ) . '</div>' : null )
											.							'</div>'
											.							( $content ? '<div class="m-2 cbCanvasLayoutContent gjCategoryGroupIntegrations">' . $content . '</div>' : null );

				if ( $row->getString( 'description' ) ) {
					$return					.=							'<div class="gjCanvasDescription gjCategoryGroupDescription">'
											.								cbTooltip( null, $row->getString( 'description' ), null, null, null, '<span class="bg-white border rounded-circle p-1 pl-2 pr-2 text-small fa fa-info text-muted"></span>' )
											.							'</div>';
				}

				if ( $buttons ) {
					$return					.=							'<div class="pl-2 pr-2 mb-2 cbCanvasLayoutButtons">'
											.								implode( ' ', $buttons )
											.							'</div>';
				}

				$return						.=						'</div>'
											.					'</div>'
											.				'</div>';
			}

			$return							.=			'</div>';

			if ( $plugin->params->getInt( 'categories_groups_paging', 1 ) && ( $pageNav->total > $pageNav->limit ) ) {
				$return						.=			'<div class="mt-3 gjCategoryPaging">'
											.				$pageNav->getListLinks()
											.			'</div>';
			}
		} else {
			$return							.=			'<div class="gjCategoryEmpty">';

			if ( $searching ) {
				$return						.=				CBTxt::T( 'No category group search results found.' );
			} else {
				$return						.=				CBTxt::T( 'There are no groups available in this category.' );
			}

			$return							.=			'</div>';
		}

		$return								.=		'</div>'
											.	'</div>';

		$_CB_framework->setMenuMeta();

		$_PLUGINS->trigger( 'gj_onAfterDisplayCategory', array( &$return, $rows, $category, $user ) );

		echo $return;
	}
}