(function($) {
	var instances = [];
	var methods = {
		init: function( options ) {
			return this.each( function () {
				var $this = this;
				var cbcondition = {};

				cbcondition.options = options;
				cbcondition.defaults = $.fn.cbcondition.defaults;
				cbcondition.settings = $.extend( true, {}, cbcondition.defaults, cbcondition.options );
				cbcondition.element = $( $this );
				cbcondition.inRepeat = cbcondition.element.closest( '.cbRepeatRow' ).length; // Lets us know we're inside a CB Repeat usage
				cbcondition.hasRepeat = []; // Lets us know what show/hide selectors are inside a CB Repeat usage

				if ( ( $this != window ) && cbcondition.settings.useData ) {
					$.each( cbcondition.defaults, function( key, value ) {
						if ( ( key != 'init' ) && ( key != 'useData' ) ) {
							// Dash Separated:
							var dataValue = cbcondition.element.data( 'cbcondition' + key.charAt( 0 ).toUpperCase() + key.slice( 1 ) );

							if ( typeof dataValue != 'undefined' ) {
								cbcondition.settings[key] = dataValue;
							} else {
								// No Separater:
								dataValue = cbcondition.element.data( 'cbcondition' + key.charAt( 0 ).toUpperCase() + key.slice( 1 ).toLowerCase() );

								if ( typeof dataValue != 'undefined' ) {
									cbcondition.settings[key] = dataValue;
								}
							}
						}
					});
				}

				cbcondition.element.triggerHandler( 'cbcondition.init.before', [cbcondition] );

				if ( ! cbcondition.settings.init ) {
					return;
				}

				if ( ! $.isArray( cbcondition.settings.conditions ) ) {
					cbcondition.settings.conditions = [];
				}

				if ( ! $.isArray( cbcondition.settings.show ) ) {
					cbcondition.settings.show = [];
				}

				if ( ! $.isArray( cbcondition.settings.hide ) ) {
					cbcondition.settings.hide = [];
				}

				if ( ! cbcondition.inRepeat ) {
					$.each( $.extend( [], cbcondition.settings.show, cbcondition.settings.hide ), function( i, selector ) {
						if ( cbcondition.hasRepeat.indexOf( selector ) != -1 ) {
							return;
						}

						var showHideElement = findSelector( cbcondition, selector );

						if ( ! showHideElement.length ) {
							return;
						}

						if ( showHideElement.closest( '.cbRepeatRow' ).length ) {
							cbcondition.hasRepeat.push( selector );
						}
					});
				}

				cbcondition.changeHandler = function() {
					conditionElement.call( this, cbcondition );
				};

				cbcondition.element.each( function() {
					if ( this != window ) {
						var target = findTarget.call( this );

						if ( ! target.length ) {
							return true;
						}

						target.on( 'keyup change condition', cbcondition.changeHandler );

						// The target element is being told to rebind so lets rebind its change handler:
						$( this ).on( 'rebind.cbconditiontarget', function() {
							// clear any existing bindings just encase to avoid double binding:
							target.off( 'keyup change condition', cbcondition.changeHandler );

							// redo the binding:
							target = findTarget.call( this );

							if ( ! target.length ) {
								return;
							}

							target.on( 'keyup change condition', cbcondition.changeHandler );
						});
					}
				});

				conditionElement.call( this, cbcondition );

				if ( $this != window ) {
					// Destroy the cbcondition element:
					cbcondition.element.on( 'remove.cbcondition destroy.cbcondition', function() {
						cbcondition.element.cbcondition( 'destroy' );
					});

					// Rebind the cbcondition element to pick up any data attribute modifications:
					cbcondition.element.on( 'rebind.cbcondition', function( e, reason ) {
						if ( reason == 'ajaxUpdateTarget' ) {
							return;
						}

						cbcondition.element.cbcondition( 'rebind' );
					});

					// If the cbcondition element is modified we need to rebuild it to ensure all our bindings are still ok:
					cbcondition.element.on( 'modified.cbcondition', function( e, oldId, newId, index ) {
						if ( oldId != newId ) {
							cbcondition.element.cbcondition( 'rebind' );
						}
					});

					// If the cbcondition is cloned we need to rebind it back:
					cbcondition.element.on( 'cloned.cbcondition', function() {
						$( this ).off( '.cbcondition' );
						$( this ).off( '.cbconditiontarget' );
						$( this ).removeData( 'cbconditions' );

						$( this ).each( function() {
							if ( this == window ) {
								return;
							}

							var target = findTarget.call( this );

							if ( ! target.length ) {
								return true;
							}

							target.off( 'keyup change condition', cbcondition.changeHandler );
						});

						$( this ).cbcondition( cbcondition.options );
					});
				}

				cbcondition.element.triggerHandler( 'cbcondition.init.after', [cbcondition] );

				if ( $this != window ) {
					// Bind the cbcondition to the element so it's reusable and chainable:
					var cbconditions = cbcondition.element.data( 'cbconditions' );

					if ( ! $.isArray( cbconditions ) ) {
						cbconditions = [];
					}

					cbconditions.push( cbcondition );

					cbcondition.element.data( 'cbconditions', cbconditions );
				}

				// Add this instance to our instance array so we can keep track of our cbcondition instances:
				instances.push( cbcondition );
			});
		},
		rebind: function() {
			var cbconditions = $( this ).data( 'cbconditions' );

			if ( ! cbconditions ) {
				return this;
			}

			$( this ).cbcondition( 'destroy' );

			$.each( cbconditions, function() {
				this.element.cbcondition( this.options );
			});

			return this;
		},
		destroy: function() {
			var cbconditions = $( this ).data( 'cbconditions' );

			if ( ! cbconditions ) {
				return false;
			}

			$.each( cbconditions, function() {
				var cbcondition = this;

				cbcondition.element.off( '.cbcondition' );
				cbcondition.element.off( '.cbconditiontarget' );

				cbcondition.element.each( function() {
					if ( this == window ) {
						return;
					}

					var target = findTarget.call( this );

					if ( ! target.length ) {
						return true;
					}

					target.off( 'keyup change condition', cbcondition.changeHandler );
				});

				$.each( instances, function( i, instance ) {
					if ( instance.element == cbcondition.element ) {
						instances.splice( i, 1 );

						return false;
					}

					return true;
				});

				showElements( cbcondition, $.extend( [], cbcondition.settings.show, cbcondition.settings.hide ) );

				cbcondition.element.triggerHandler( 'cbcondition.destroyed', [cbcondition] );
			});

			$( this ).removeData( 'cbconditions' );

			return true;
		},
		instances: function() {
			return instances;
		}
	};

	function findSelector( cbcondition, selector )
	{
		var element;

		if ( cbcondition.inRepeat ) {
			element = cbcondition.element.closest( '.cbRepeatRow' ).find( selector );

			if ( ! element.length ) {
				element = $( selector );
			}
		} else {
			element = $( selector );
		}

		return element;
	}

	function findTarget()
	{
		var element = ( this.jquery ? this : $( this ) );
		var target;

		if ( element.is( '#cbregUpgrades' ) ) {
			// Handle CBSubs specifically since it has a odd input naming convention:
			target = element.find( '.cbregTick input' );
		} else if ( element.is( 'input' ) || element.is( 'select' ) || element.is( 'textarea' ) ) {
			target = element;
		} else {
			target = element.find( 'input,select,textarea' ).not( '[name$="__srmch"]' ).first();

			if ( target.is( ':checkbox' ) || target.is( ':radio' ) ) {
				target = element.find( 'input[name="' + target.attr( 'name' ) + '"]' );
			}
		}

		return target;
	}

	function findTargetValue( value )
	{
		var element = ( this.jquery ? this : $( this ) );

		if ( typeof value == 'undefined' ) {
			value = null;
		}

		if ( element.is( 'input' ) || element.is( 'select' ) || element.is( 'textarea' ) ) {
			if ( element.is( 'input[type="checkbox"]' ) || element.is( 'input[type="radio"]' ) ) {
				value = [];

				element.each( function() {
					if ( $( this ).is( ':checked' ) ) {
						value.push( $( this ).val() );
					}
				});
			} else if ( element.is( 'select[multiple]' ) ) {
				value = element.val();

				if ( value && ( ! $.isArray( value ) ) ) {
					value = value.split( ',' );
				}
			} else {
				value = element.val();
			}
		}

		return value;
	}

	function conditionElement( cbcondition, match )
	{
		var $this = ( this.jquery ? this : $( this ) );
		var conditions = cbcondition.settings.conditions;

		if ( ! $.isArray( conditions ) ) {
			conditions = [];
		}

		var matched = false;

		if ( typeof match == 'undefined' ) {
			$.each( conditions, function( orIndex, orCondition ) {
				if ( ! $.isArray( orCondition ) ) {
					orCondition = [];
				}

				var andMatched = true;

				$.each( orCondition, function( andIndex, andCondition ) {
					var element = andCondition.element;
					var target = $this;
					var input = andCondition.input;

					if ( typeof element != 'undefined' ) {
						element = ( element.jquery ? element : findSelector( cbcondition, element ) );
						target = findTarget.call( element );
						input = findTargetValue.call( target, andCondition.input );

						if ( ( typeof element != 'undefined' )
							&& ( element.hasClass( 'cbft_image' )
							|| element.hasClass( 'cbft_file' )
							|| element.hasClass( 'cbft_video' )
							|| element.hasClass( 'cbft_audio' ) )
						) {
							if ( input === '' ) {
								input = andCondition.input;
							} else if ( input === 'delete' ) {
								input = '';
							}
						}

						if ( ( andCondition.type == 'subscription' ) && andCondition.input ) {
							// Always keep the subscriptions initial selected plan values in mind for conditions:
							if ( ! input ) {
								input = andCondition.input;
							} else if ( $.isArray( input ) ) {
								input.push( andCondition.input );
							}
						}
					}

					var isMatched = matchCondition( cbcondition, input, andCondition.operator, andCondition.value, andCondition.delimiter );

					if ( andMatched ) {
						andMatched = isMatched;
					}

					if ( cbcondition.settings.debug ) {
						console.log({
							orIndex: ( orIndex + 1 ),
							andIndex: ( andIndex + 1 ),
							element: element,
							target: target,
							input: input,
							matched: isMatched,
							condition: andCondition,
							show: cbcondition.settings.show,
							hide: cbcondition.settings.hide
						});
					}
				});

				if ( ( ! matched  ) && andMatched ) {
					matched = true;
				}
			});
		} else {
			matched = match;
		}

		if ( matched ) {
			showElements( cbcondition, cbcondition.settings.show );
			hideElements( cbcondition, cbcondition.settings.hide );

			cbcondition.element.triggerHandler( 'cbcondition.match.true', [cbcondition] );
		} else {
			hideElements( cbcondition, cbcondition.settings.show );
			showElements( cbcondition, cbcondition.settings.hide );

			cbcondition.element.triggerHandler( 'cbcondition.match.false', [cbcondition] );
		}

		// Trigger conditions for elements that might have been shown or hidden:
		$.each( $.extend( [], cbcondition.settings.show, cbcondition.settings.hide ), function( i, selector ) {
			var element = findSelector( cbcondition, selector );

			if ( element.is( $this ) ) {
				// Do not allow an element to trigger conditions on itself as it will get stuck in a loop:
				if ( cbcondition.settings.debug ) {
					console.log( 'Infinite loop detected.', $this, element );
				}

				return;
			}

			if ( element.is( 'input' ) || element.is( 'select' ) || element.is( 'textarea' ) || element.is( 'option' ) ) {
				element.triggerHandler( 'condition' );
			} else {
				element.find( 'input,select,textarea' ).triggerHandler( 'condition' );
			}
		});
	}

	function showElements( cbcondition, elements )
	{
		$.each( elements, function( i, selector ) {
			var showElem = findSelector( cbcondition, selector );

			showElement( cbcondition, showElem );

			if ( ( ! cbcondition.inRepeat )
				&& ( cbcondition.hasRepeat.indexOf( selector ) != -1 )
				&& showElem.closest( '.cbRepeatRow' ).length
			) {
				showElem.closest( '.cbRepeatRow' ).nextAll( '.cbRepeatRow' ).each( function() {
					showElement( cbcondition, $( this ).find( selector ) );
				});
			}
		});
	}

	function showElement( cbcondition, element )
	{
		if ( element.length && element.hasClass( 'cbDisplayDisabled' ) && ( ! element.parents( '.cbDisplayDisabled' ).length ) ) {
			if ( element.hasClass( 'cbTabPane' ) ) {
				var cbtabs = element.closest( '.cbTabs' );

				if ( cbtabs.data( 'cbtabs' ) ) {
					cbtabs.cbtabs( 'show', element.attr( 'id' ) );
				}
			} else if ( element.is( 'input[type="checkbox"]' ) || element.is( 'input[type="radio"]' ) ) {
				if ( element.closest( '.cbSingleCntrl' ).length ) {
					element.closest( '.cbSingleCntrl' ).removeClass( 'cbDisplayDisabled hidden' );
				} else if ( element.closest( '.cbSnglCtrlLbl' ).length ) {
					element.closest( '.cbSnglCtrlLbl' ).removeClass( 'cbDisplayDisabled hidden' );
				} else if ( element.parent( 'label' ).length ) {
					element.parent( 'label' ).removeClass( 'cbDisplayDisabled hidden' );
				}
			}

			if ( element.is( 'input' ) || element.is( 'select' ) || element.is( 'textarea' ) ) {
				element.removeClass( 'cbValidationDisabled' );
			} else if ( element.is( 'option' ) ) {
				element.prop( 'disabled', false );
			} else {
				element.find( 'input,select,textarea' ).removeClass( 'cbValidationDisabled' );
			}

			element.removeClass( 'cbDisplayDisabled hidden' );

			cbcondition.element.triggerHandler( 'cbcondition.show', [cbcondition, element] );
		}
	}

	function hideElements( cbcondition, elements )
	{
		$.each( elements, function( i, selector ) {
			var hideElem = findSelector( cbcondition, selector );

			hideElement( cbcondition, hideElem );

			if ( ( ! cbcondition.inRepeat )
				&& ( cbcondition.hasRepeat.indexOf( selector ) != -1 )
				&& hideElem.closest( '.cbRepeatRow' ).length
			) {
				hideElem.closest( '.cbRepeatRow' ).nextAll( '.cbRepeatRow' ).each( function() {
					hideElement( cbcondition, $( this ).find( selector ) );
				});
			}
		});
	}

	function hideElement( cbcondition, element )
	{
		if ( element.length && ( ! element.hasClass( 'cbDisplayDisabled' ) ) && ( ! element.parents( '.cbDisplayDisabled' ).length ) ) {
			if ( element.hasClass( 'cbTabPane' ) ) {
				var cbtabs = element.closest( '.cbTabs' );

				if ( cbtabs.data( 'cbtabs' ) ) {
					cbtabs.cbtabs( 'hide', element.attr( 'id' ) );
				}
			} else if ( element.is( 'input[type="checkbox"]' ) || element.is( 'input[type="radio"]' ) ) {
				if ( element.closest( '.cbSingleCntrl' ).length ) {
					element.closest( '.cbSingleCntrl' ).addClass( 'cbDisplayDisabled hidden' );
				} else if ( element.closest( '.cbSnglCtrlLbl' ).length ) {
					element.closest( '.cbSnglCtrlLbl' ).addClass( 'cbDisplayDisabled hidden' );
				} else if ( element.parent( 'label' ).length ) {
					element.parent( 'label' ).addClass( 'cbDisplayDisabled hidden' );
				}
			}

			if ( element.is( 'input' ) || element.is( 'select' ) || element.is( 'textarea' ) ) {
				if ( cbcondition.settings.reset ) {
					if ( element.is( 'input[type="checkbox"]' ) || element.is( 'input[type="radio"]' ) ) {
						element.prop( 'checked', false );
					} else if ( ! element.is( 'input[type="hidden"]' ) ) {
						element.val( '' );
					}
				}

				element.addClass( 'cbValidationDisabled' );
			} else if ( element.is( 'option' ) ) {
				if ( cbcondition.settings.reset ) {
					element.prop( 'selected', false );
				}

				element.prop( 'disabled', true );
			} else {
				var elements = element.find( 'input,select,textarea' );

				if ( cbcondition.settings.reset ) {
					elements.each( function() {
						if ( $( this ).is( 'input[type="checkbox"]' ) || $( this ).is( 'input[type="radio"]' ) ) {
							$( this ).prop( 'checked', false );
						} else if ( ! $( this ).is( 'input[type="hidden"]' ) ) {
							$( this ).val( '' );
						}
					});
				}

				elements.addClass( 'cbValidationDisabled' );
			}

			element.addClass( 'cbDisplayDisabled hidden' );

			cbcondition.element.triggerHandler( 'cbcondition.hide', [cbcondition, element] );
		}
	}

	function matchCondition( cbcondition, input, operator, value, delimiter )
	{
		var valueIsArray = false;

		if ( $.isArray( value ) ) {
			valueIsArray = true;

			value = value.join( ( delimiter ? delimiter : '|*|' ) );
		}

		var inputIsArray = false;

		if ( $.isArray( input ) ) {
			inputIsArray = true;

			input = input.join( ( delimiter ? delimiter : '|*|' ) );
		}

		input				=	$.trim( input );
		value				=	$.trim( value );

		var match			=	false;

		switch ( operator ) {
			case '!=':
			case '<>':
			case 1:
				match		=	( input != value );
				break;
			case '>':
			case 2:
				match		=	( input > value );
				break;
			case '<':
			case 3:
				match		=	( input < value );
				break;
			case '>=':
			case 4:
				match		=	( input >= value );
				break;
			case '<=':
			case 5:
				match		=	( input <= value );
				break;
			case 'empty':
			case 6:
				match		=	( ! input.length );
				break;
			case '!empty':
			case 7:
				match		=	( input.length );
				break;
			case 'contain':
			case 8:
				if ( delimiter ) {
					if ( valueIsArray ) {
						$.each( value.split( delimiter ), function( i, v ) {
							match	=	( input.split( delimiter ).indexOf( v ) != -1 );

							if ( match ) {
								return false;
							}
						});
					} else {
						match	=	( input.split( delimiter ).indexOf( value ) != -1 );
					}
				} else {
					if ( input === '' ) {
						// Can't have an empty needle so fallback to simple equal to check:
						return matchCondition( cbcondition, input, 0, value, delimiter );
					}

					match	=	( input.indexOf( value ) != -1 );
				}
				break;
			case '!contain':
			case 9:
				if ( delimiter ) {
					if ( valueIsArray ) {
						$.each( value.split( delimiter ), function( i, v ) {
							match	=	( input.split( delimiter ).indexOf( v ) == -1 );

							if ( match ) {
								return false;
							}
						});
					} else {
						match	=	( input.split( delimiter ).indexOf( value ) == -1 );
					}
				} else {
					if ( input === '' ) {
						// Can't have an empty needle so fallback to simple not equal to check:
						return matchCondition( cbcondition, input, 1, value, delimiter );
					}

					match	=	( input.indexOf( value ) == -1 );
				}
				break;
			case 'regexp':
			case 10:
				if ( value === '' ) {
					// Can't have an empty regexp so fallback to simple equal to check:
					return matchCondition( cbcondition, input, 0, value, delimiter );
				}

				try {
					match	=	stringToRegexp( value ).test( input );
				} catch( e ) {}
				break;
			case '!regexp':
			case 11:
				if ( value === '' ) {
					// Can't have an empty regexp so fallback to simple not equal to check:
					return matchCondition( cbcondition, input, 1, value, delimiter );
				}

				try {
					match	=	( ! stringToRegexp( value ).test( input ) );
				} catch( e ) {}
				break;
			case 'in':
			case 12:
				if ( delimiter ) {
					if ( inputIsArray ) {
						$.each( input.split( delimiter ), function( i, v ) {
							match	=	( value.split( delimiter ).indexOf( v ) != -1 );

							if ( match ) {
								return false;
							}
						});
					} else {
						match	=	( value.split( delimiter ).indexOf( input ) != -1 );
					}
				} else {
					if ( value === '' ) {
						// Can't have an empty needle so fallback to simple equal to check:
						return matchCondition( cbcondition, input, 0, value, delimiter );
					}

					match	=	( value.indexOf( input ) != -1 );
				}
				break;
			case '!in':
			case 13:
				if ( delimiter ) {
					if ( inputIsArray ) {
						$.each( input.split( delimiter ), function( i, v ) {
							match	=	( value.split( delimiter ).indexOf( v ) == -1 );

							if ( match ) {
								return false;
							}
						});
					} else {
						match	=	( value.split( delimiter ).indexOf( input ) == -1 );
					}
				} else {
					if ( value === '' ) {
						// Can't have an empty needle so fallback to simple not equal to check:
						return matchCondition( cbcondition, input, 1, value, delimiter );
					}

					match	=	( value.indexOf( input ) == -1 );
				}
				break;
			case '=':
			case 0:
			default:
				match		=	( input == value );
				break;
		}

		cbcondition.element.triggerHandler( 'cbcondition.match', [cbcondition, input, operator, value, match] );

		return match;
	}

	function stringToRegexp( regexpString )
	{
		var regexpDelimiter = regexpString.substr( 0, 1 );
		var regexpEnd = regexpString.lastIndexOf( regexpDelimiter );
		var regexpPattern = regexpString.slice( 1, regexpEnd );
		var regexpModifiers = regexpString.substr( ( regexpEnd + 1 ) );

		return new RegExp( regexpPattern, regexpModifiers );
	}

	$.fn.cbcondition = function( options ) {
		if ( ! $( this ).length ) {
			// Looks like condition was called on an element that doesn't exist so lets just fallback to an unbound condition:
			return $( window ).cbcondition( options );
		}

		if ( methods[options] ) {
			return methods[ options ].apply( this, Array.prototype.slice.call( arguments, 1 ) );
		} else if ( ( typeof options === 'object' ) || ( ! options ) ) {
			return methods.init.apply( this, arguments );
		}

		return this;
	};

	$.fn.cbcondition.defaults = {
		init: true,
		useData: true,
		conditions: [],
		show: [],
		hide: [],
		reset: true,
		debug: false
	};
})(jQuery);