<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2022 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var int    $complete
 * @var bool   $bar
 * @var bool   $barCompleteness
 * @var string $barColor
 * @var string $barStyle
 * @var int    $barHeight
 * @var array  $checklist
 * @var int    $checklistColumns
 * @var bool   $checklistLinks
 */
?>
<div class="d-flex flex-column cbProgress" style="gap: 0.5rem;">
	<?php if ( $bar || $checklist ) { ?>
		<?php if ( $bar ) { ?>
		<div class="m-0 progress cbProgressBar"<?php echo ( $barHeight ? ' style="height: ' . $barHeight . 'px;"' : '' ); ?>>
			<div class="progress-bar<?php echo $barStyle; ?>" role="progressbar" aria-valuenow="<?php echo $complete; ?>" aria-valuemin="0" aria-valuemax="100" style="width: <?php echo $complete; ?>%;<?php echo ( $barColor ? ' background-color: ' . $barColor . ';' : '' ); ?>">
				<?php if ( $barCompleteness ) { ?>
					<?php echo CBTxt::T( 'PROFILE_COMPLETE_PERCENT', '[complete]%', [ '[complete]' => $complete ] ); ?>
				<?php } ?>
			</div>
		</div>
		<?php } ?>
		<?php if ( $checklist ) { ?>
		<div class="rounded bg-light border p-2 cbProgressChecklist" style="display: grid; gap: 0.5rem;<?php echo ( $checklistColumns > 1 ? ' grid-template-columns: repeat( ' . $checklistColumns . ', 1fr );' : '' ); ?>">
			<?php foreach( $checklist as $userField ) { ?>
				<div class="<?php echo ( $userField->complete ? 'cbProgressChecklistComplete' : 'cbProgressChecklistInComplete' ); ?>">
					<span class="fa <?php echo ( $userField->complete ? 'fa-check text-success' : 'fa-times text-danger' ); ?> text-center" style="width: 20px;"></span>
					<?php if ( $checklistLinks && ( ! $userField->complete ) ) { ?>
						<a href="<?php echo $userField->link; ?>" class="cbProgressChecklistLink">
							<?php echo $userField->title; ?>
						</a>
					<?php } else { ?>
						<?php echo $userField->title; ?>
					<?php } ?>
				</div>
			<?php } ?>
		</div>
		<?php } ?>
	<?php } else { ?>
		<?php echo CBTxt::T( 'PROFILE_COMPLETE_PERCENT', '[complete]%', [ '[complete]' => $complete ] ); ?>
	<?php } ?>
</div>
