<?php
/**
 * Community Builder (TM)
 * @version $Id: $
 * @package CommunityBuilder
 * @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
 * @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
 */

namespace CB\Plugin\Code\Field;

use CB\Database\Table\UserTable;
use CB\Database\Table\FieldTable;
use CB\Plugin\Code\CBCodeField;
use CBLib\Application\Application;
use CBLib\Registry\GetterInterface;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class CodeField extends \cbFieldHandler
{

	/**
	 * Accessor:
	 * Returns a field in specified format
	 *
	 * @param  FieldTable  $field
	 * @param  UserTable   $user
	 * @param  string      $output               'html', 'xml', 'json', 'php', 'csvheader', 'csv', 'rss', 'fieldslist', 'htmledit'
	 * @param  string      $reason               'profile' for user profile view, 'edit' for profile edit, 'register' for registration, 'search' for searches
	 * @param  int         $list_compare_types   IF reason == 'search' : 0 : simple 'is' search, 1 : advanced search with modes, 2 : simple 'any' search
	 * @return mixed
	 */
	public function getField( &$field, &$user, $output, $reason, $list_compare_types )
	{
		// Force the user object to CBuser instance to allow substitutions for non-existant users to work:
		$cbUser				=	new \CBuser();
		$cbUser->_cbuser	=	$user;

		$code				=	$cbUser->replaceUserVars( $field->params->get( 'code', '', GetterInterface::RAW ), false, false, array( 'reason' => $reason ), false );

		if ( $code && $field->params->getBool( 'code_content_plugins', false ) ) {
			$code			=	Application::Cms()->prepareHtmlContentPlugins( $code, 'field.code', $user->getInt( 'id', 0 ) );
		}

		try {
			ob_start();
			require CBCodeField::getTemplate( $field, 'display' );
			$return			=	ob_get_contents();
			ob_end_clean();
		} catch ( \Exception $e ) {
			if ( Application::MyUser()->isGlobalModerator() ) {
				$return		=	'<div class="alert alert-danger">' . $e->getMessage() . '</div>';
			} else {
				$return		=	null;
			}
		}

		switch ( $output ) {
			case 'html':
			case 'rss':
			case 'htmledit':
				if ( $reason == 'search' ) {
					return	null;
				} else {
					return $this->formatFieldValueLayout( $this->_formatFieldOutput( $field->get( 'name', null, GetterInterface::STRING ), $return, $output, false ), $reason, $field, $user );
				}
			default:
				return $this->_formatFieldOutput( $field->get( 'name', null, GetterInterface::STRING ), $return, $output, false );
		}
	}
}