<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Core\AutoLoader;
use CBLib\Registry\GetterInterface;
use CBLib\Database\Table\Table;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

AutoLoader::registerExactMap( '%^CB/Plugin/AntiSpam/(.+)%i', __DIR__ . '/library/$1.php' );

function plug_cbantispam_install()
{
	global $_CB_database;

	$query					=	'SELECT *'
							.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_plugin_antispam_block' )
							.	"\n WHERE " . $_CB_database->NameQuote( 'type' ) . " IN " . $_CB_database->safeArrayOfStrings( array( 'ip', 'email', 'domain' ) )
							.	"\n AND " . $_CB_database->NameQuote( 'value' ) . " LIKE " . $_CB_database->Quote( '%' . $_CB_database->getEscaped( '%', true ) . '%' );
	$_CB_database->setQuery( $query );
	$blocks					=	$_CB_database->loadObjectList( null, '\CBLib\Database\Table\Table', array( $_CB_database, '#__comprofiler_plugin_antispam_block', 'id' ) );

	/** @var Table[] $blocks */
	foreach ( $blocks as $block ) {
		$block->set( 'type', $block->get( 'type', null, GetterInterface::STRING ) . '_partial' );

		$block->store();
	}

	$query					=	'SELECT *'
							.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_plugin_antispam_whitelist' )
							.	"\n WHERE " . $_CB_database->NameQuote( 'params' ) . " IN " . $_CB_database->safeArrayOfStrings( array( 'ip', 'email', 'domain' ) )
							.	"\n AND " . $_CB_database->NameQuote( 'value' ) . " LIKE " . $_CB_database->Quote( '%' . $_CB_database->getEscaped( '%', true ) . '%' );
	$_CB_database->setQuery( $query );
	$whitelists				=	$_CB_database->loadObjectList( null, '\CBLib\Database\Table\Table', array( $_CB_database, '#__comprofiler_plugin_antispam_whitelist', 'id' ) );

	/** @var Table[] $whitelists */
	foreach ( $whitelists as $whitelist ) {
		$whitelist->set( 'type', $whitelist->get( 'type', null, GetterInterface::STRING ) . '_partial' );

		$whitelist->store();
	}
}