<?php
/**
 * @version			2.2.0
 * @author			Nicholas G. Antimisiaris
 * @authoremail		nant@joomlapolis.com
 * @authorurl		www.joomlapolis.com
 * @package			Joomla 2 CiviCRM User Sync
 * @file			civicrmlversion.php
 * @copyright		Copyright (C) 2013-2019. All rights reserved
 * @license			GNU GPL version 2
 * @description		Code used by Joomla plugin parameter form to grab version from CiviCRM installation
 * 					Basically we are overriding the core Joomla text field class
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

jimport('joomla.form.formfield');
jimport('joomla.form.helper');
JFormHelper::loadFieldClass('text');


class JFormFieldcivicrmversion extends JFormFieldText
{
	protected $type = 'civicrmversion';

	protected function getInput()
	{
		// Initialize some field attributes.
		$size = $this->element['size'] ? ' size="' . (int) $this->element['size'] . '"' : '';
		$maxLength = $this->element['maxlength'] ? ' maxlength="' . (int) $this->element['maxlength'] . '"' : '';
		$class = $this->element['class'] ? ' class="' . (string) $this->element['class'] . '"' : '';
		$readonly = ((string) $this->element['readonly'] == 'true') ? ' readonly="readonly"' : '';
		$disabled = ((string) $this->element['disabled'] == 'true') ? ' disabled="disabled"' : '';

		// Initialize JavaScript field attributes.
		$onchange = $this->element['onchange'] ? ' onchange="' . (string) $this->element['onchange'] . '"' : '';

		if (file_exists(JPATH_ROOT . '/administrator/components/com_civicrm/helpers/api.php')) {
			// if this file exists, then CiviCRM is installed and we can load api to get version

			require_once JPATH_ROOT . '/administrator/components/com_civicrm/helpers/api.php';
			CivicrmHelperApi::civiimport('api');


			$component = \JComponentHelper::getComponent('com_civicrm');
			$extension = \JTable::getInstance('extension');
			$extension->load($component->id);
			$manifest = new \Joomla\Registry\Registry($extension->manifest_cache);
			$j2c_value = $manifest->get('version');


		} else {
			// no file means that CiviCRM is not installed on this Joomla site
			$j2c_value = (string) "0"; // means that CiviCRM is not installed
		}

		return '<input type="text" name="' . $this->name . '" id="' . $this->id . '"' . ' value="'
		. htmlspecialchars($j2c_value, ENT_COMPAT, 'UTF-8') . '"' . $class . $size . $disabled . $readonly . $onchange . $maxLength . '/>';
	}
}
