<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\UserTable;
use CBLib\Language\CBTxt;
use CB\Plugin\Activity\CBActivity;
use CB\Plugin\Activity\Table\NotificationTable;
use CB\Plugin\Activity\Notifications;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var NotificationTable[] $rows
 * @var cbPageNav           $pageNav
 * @var UserTable           $viewer
 * @var Notifications       $stream
 * @var CBplug_cbactivity   $this
 * @var string              $output
 *
 * @var string              $direction
 */
?>
<?php if ( in_array( $output, array( 'load', 'update' ), true ) ) { ?>
	<?php if ( ( $direction === 'up' ) && $stream->getBool( 'paging', true ) && ( $pageNav->total > $pageNav->limit ) ) { ?>
	<div class="notificationsStreamToolbar streamToolbar streamMoreContainer">
		<a href="javascript: void(0);" data-cbactivity-more-url="<?php echo $pageNav->limitstartUrl( $pageNav->limitstart ); ?>" class="btn btn-info btn-sm btn-block notificationsButton notificationsButtonMore streamMore"><?php echo CBTxt::T( 'Previous' ); ?></a>
	</div>
	<?php } ?>
<?php } ?>
<?php if ( $rows ) { ?>
	<?php foreach ( $rows as $row ) { ?>
		<?php require CBActivity::getTemplate( $stream->getString( 'template' ), 'notifications/container', false ); ?>
	<?php } ?>
<?php } elseif ( ( ! $stream->getBool( 'inline', false ) ) && ( $output !== 'modal' ) ) { ?>
<div class="notificationsStreamEmpty streamEmpty">
	<?php echo CBTxt::T( 'No notifications to display.' ); ?>
</div>
<?php } ?>
<?php if ( in_array( $output, array( 'load', 'update' ), true ) ) { ?>
	<?php if ( ( $direction === 'down' ) && $stream->getBool( 'paging', true ) && ( $pageNav->total > $pageNav->limit ) ) { ?>
	<div class="notificationsStreamToolbar streamToolbar streamMoreContainer">
		<a href="javascript: void(0);" data-cbactivity-more-url="<?php echo $pageNav->limitstartUrl( $pageNav->limitstart ); ?>" class="btn btn-info btn-sm btn-block notificationsButton notificationsButtonMore streamMore"><?php echo CBTxt::T( 'More' ); ?></a>
	</div>
	<?php } ?>
	<?php echo CBActivity::reloadHeaders(); ?>
<?php } ?>