<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\UserTable;
use CBLib\Language\CBTxt;
use CB\Plugin\Activity\Likes;
use CB\Plugin\Activity\CBActivity;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var UserTable         $viewer
 * @var Likes             $stream
 * @var CBplug_cbactivity $this
 * @var string            $output
 *
 * @var string            $layout
 * @var bool              $liked
 * @var bool              $canCreate
 * @var int               $total
 * @var array             $likes
 */

global $_CB_framework, $_PLUGINS;

$likeCount				=	null;

if ( $total ) {
	$likeCount			=	CBTxt::T( 'LIKES_COUNT', '[likes] Like|[likes] Likes|%%COUNT%%', array( '%%COUNT%%' => $total, '[likes]' => CBActivity::getFormattedTotal( $total ) ) );
}
?>
<span class="likeStream<?php echo ( in_array( $layout, array( 'simple', 'extended' ), true ) ? ' likeStreamSimple' : null ); ?> streamBind streamContainer stream<?php echo htmlspecialchars( $stream->id() ); ?>" data-cbactivity-stream="<?php echo htmlspecialchars( $stream->id() ); ?>">
	<?php echo implode( '', $_PLUGINS->trigger( 'activity_onBeforeDisplayStreamLike', array( &$liked, $total, $viewer, &$stream, $output ) ) ); ?>
	<?php if ( $canCreate ) { ?>
		<?php require CBActivity::getTemplate( $stream->getString( 'template' ), 'likes/button', false ); ?>
	<?php } ?>
	<?php if ( $total ) { ?>
		<?php if ( in_array( $layout, array( 'simple', 'extended' ), true ) ) { ?>
		<span class="text-small likeStreamCount streamCount">
			<a href="javascript: void(0);" class="<?php echo ( $canCreate ? 'text-muted ' : null ); ?>cbTooltip streamModal" data-cbactivity-modal-url="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'likes', 'func' => 'modal', 'stream' => $stream->id() ), 'raw', 0, true ); ?>" data-cbtooltip-title="<?php echo htmlspecialchars( $likeCount ); ?>" data-cbtooltip-modal="true" data-cbtooltip-open-solo=".likesModalContainer" data-cbtooltip-width="800px" data-cbtooltip-height="600px" data-cbtooltip-classes="streamModalContainer streamModalContainerLoad likesModalContainer" data-cbtooltip-content-classes="p-0">
				<?php echo ( ! $canCreate ? '<span class="fa fa-thumbs-o-up"></span> ' : null ); ?>
				<?php
				if ( ( $layout === 'extended' ) && $likes ) {
					$likeCount		=	count( $likes );
					$likeOne		=	'<span class="likeStreamLiked">' . array_shift( $likes ) . '</span>';
					$likeTwo		=	'<span class="likeStreamLiked">' . array_shift( $likes ) . '</span>';

					if ( $likeCount > 2 ) {
						echo CBTxt::T( 'LIKES_MORE_THAN_TWO', '[like_1], [like_2], and [more] other liked this|[like_1], [like_2], and [more] others liked this|%%COUNT%%', array( '%%COUNT%%' => ( $total - 2 ), '[like_1]' => $likeOne, '[like_2]' => $likeTwo, '[more]' => CBActivity::getFormattedTotal( ( $total - 2 ) ) ) );
					} elseif ( $likeCount > 1 ) {
						echo CBTxt::T( 'LIKES_TWO', '[like_1] and [like_2] liked this', array( '[like_1]' => $likeOne, '[like_2]' => $likeTwo ) );
					} else {
						echo CBTxt::T( 'LIKES_ONE', '[like_1] liked this', array( '[like_1]' => $likeOne ) );
					}
				} else {
					echo CBActivity::getFormattedTotal( $total );
				}
				?>
			</a>
		</span>
		<?php } else { ?>
		<span class="position-relative align-middle text-small likeStreamCount streamCount streamCountLabel">
			<?php echo ( $canCreate ? '<span class="position-absolute d-block border-right likeStreamCountArrow streamCountLabelArrow"></span>' : null ); ?>
			<span class="d-inline-block border rounded bg-white text-center likeStreamCountContent streamCountLabelContent">
				<a href="javascript: void(0);" class="d-block w-100 pl-3 pr-3 pt-1 pb-1<?php echo ( $canCreate ? ' text-muted' : null ); ?> cbTooltip streamModal" data-cbactivity-modal-url="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'likes', 'func' => 'modal', 'stream' => $stream->id() ), 'raw', 0, true ); ?>" data-cbtooltip-title="<?php echo htmlspecialchars( $likeCount ); ?>" data-cbtooltip-modal="true" data-cbtooltip-open-solo=".likesModalContainer" data-cbtooltip-width="800px" data-cbtooltip-height="600px" data-cbtooltip-classes="streamModalContainer streamModalContainerLoad likesModalContainer" data-cbtooltip-content-classes="p-0">
					<?php echo ( ! $canCreate ? '<span class="fa fa-thumbs-o-up"></span> ' : null ); ?>
					<?php echo CBActivity::getFormattedTotal( $total ); ?>
				</a>
			</span>
		</span>
		<?php } ?>
	<?php } ?>
	<?php echo implode( '', $_PLUGINS->trigger( 'activity_onAfterDisplayStreamLike', array( $liked, $total, $viewer, $stream, $output ) ) ); ?>
	<?php echo ( $output === 'save' ? CBActivity::reloadHeaders() : null ); ?>
</span>